/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.community.rest.client.dto.AbstractSetRemovalTimeDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.SetRemovalTimeToHistoricProcessInstancesDtoAllOf;

/**
 * SetRemovalTimeToHistoricProcessInstancesDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-23T14:22:53.022768Z[Etc/UTC]")
public class SetRemovalTimeToHistoricProcessInstancesDto {
  public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_IDS = "historicProcessInstanceIds";
  @SerializedName(SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_IDS)
  private List<String> historicProcessInstanceIds = null;

  public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
  @SerializedName(SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY)
  private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

  public static final String SERIALIZED_NAME_HIERARCHICAL = "hierarchical";
  @SerializedName(SERIALIZED_NAME_HIERARCHICAL)
  private Boolean hierarchical;

  public static final String SERIALIZED_NAME_ABSOLUTE_REMOVAL_TIME = "absoluteRemovalTime";
  @SerializedName(SERIALIZED_NAME_ABSOLUTE_REMOVAL_TIME)
  private Date absoluteRemovalTime;

  public static final String SERIALIZED_NAME_CLEARED_REMOVAL_TIME = "clearedRemovalTime";
  @SerializedName(SERIALIZED_NAME_CLEARED_REMOVAL_TIME)
  private Boolean clearedRemovalTime;

  public static final String SERIALIZED_NAME_CALCULATED_REMOVAL_TIME = "calculatedRemovalTime";
  @SerializedName(SERIALIZED_NAME_CALCULATED_REMOVAL_TIME)
  private Boolean calculatedRemovalTime;


  public SetRemovalTimeToHistoricProcessInstancesDto historicProcessInstanceIds(List<String> historicProcessInstanceIds) {
    
    this.historicProcessInstanceIds = historicProcessInstanceIds;
    return this;
  }

  public SetRemovalTimeToHistoricProcessInstancesDto addHistoricProcessInstanceIdsItem(String historicProcessInstanceIdsItem) {
    if (this.historicProcessInstanceIds == null) {
      this.historicProcessInstanceIds = new ArrayList<String>();
    }
    this.historicProcessInstanceIds.add(historicProcessInstanceIdsItem);
    return this;
  }

   /**
   * The id of the process instance.
   * @return historicProcessInstanceIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process instance.")

  public List<String> getHistoricProcessInstanceIds() {
    return historicProcessInstanceIds;
  }


  public void setHistoricProcessInstanceIds(List<String> historicProcessInstanceIds) {
    this.historicProcessInstanceIds = historicProcessInstanceIds;
  }


  public SetRemovalTimeToHistoricProcessInstancesDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    return this;
  }

   /**
   * Get historicProcessInstanceQuery
   * @return historicProcessInstanceQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
    return historicProcessInstanceQuery;
  }


  public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
    this.historicProcessInstanceQuery = historicProcessInstanceQuery;
  }


  public SetRemovalTimeToHistoricProcessInstancesDto hierarchical(Boolean hierarchical) {
    
    this.hierarchical = hierarchical;
    return this;
  }

   /**
   * Sets the removal time to all historic process instances in the hierarchy. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return hierarchical
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sets the removal time to all historic process instances in the hierarchy. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getHierarchical() {
    return hierarchical;
  }


  public void setHierarchical(Boolean hierarchical) {
    this.hierarchical = hierarchical;
  }


  public SetRemovalTimeToHistoricProcessInstancesDto absoluteRemovalTime(Date absoluteRemovalTime) {
    
    this.absoluteRemovalTime = absoluteRemovalTime;
    return this;
  }

   /**
   * The date for which the instances shall be removed. Value may not be &#x60;null&#x60;.  **Note:** Cannot be set in conjunction with &#x60;clearedRemovalTime&#x60; or &#x60;calculatedRemovalTime&#x60;.
   * @return absoluteRemovalTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The date for which the instances shall be removed. Value may not be `null`.  **Note:** Cannot be set in conjunction with `clearedRemovalTime` or `calculatedRemovalTime`.")

  public Date getAbsoluteRemovalTime() {
    return absoluteRemovalTime;
  }


  public void setAbsoluteRemovalTime(Date absoluteRemovalTime) {
    this.absoluteRemovalTime = absoluteRemovalTime;
  }


  public SetRemovalTimeToHistoricProcessInstancesDto clearedRemovalTime(Boolean clearedRemovalTime) {
    
    this.clearedRemovalTime = clearedRemovalTime;
    return this;
  }

   /**
   * Sets the removal time to &#x60;null&#x60;. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.  **Note:** Cannot be set in conjunction with &#x60;absoluteRemovalTime&#x60; or &#x60;calculatedRemovalTime&#x60;.
   * @return clearedRemovalTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sets the removal time to `null`. Value may only be `true`, as `false` is the default behavior.  **Note:** Cannot be set in conjunction with `absoluteRemovalTime` or `calculatedRemovalTime`.")

  public Boolean getClearedRemovalTime() {
    return clearedRemovalTime;
  }


  public void setClearedRemovalTime(Boolean clearedRemovalTime) {
    this.clearedRemovalTime = clearedRemovalTime;
  }


  public SetRemovalTimeToHistoricProcessInstancesDto calculatedRemovalTime(Boolean calculatedRemovalTime) {
    
    this.calculatedRemovalTime = calculatedRemovalTime;
    return this;
  }

   /**
   * The removal time is calculated based on the engine&#39;s configuration settings. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.  **Note:** Cannot be set in conjunction with &#x60;absoluteRemovalTime&#x60; or &#x60;clearedRemovalTime&#x60;.
   * @return calculatedRemovalTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The removal time is calculated based on the engine's configuration settings. Value may only be `true`, as `false` is the default behavior.  **Note:** Cannot be set in conjunction with `absoluteRemovalTime` or `clearedRemovalTime`.")

  public Boolean getCalculatedRemovalTime() {
    return calculatedRemovalTime;
  }


  public void setCalculatedRemovalTime(Boolean calculatedRemovalTime) {
    this.calculatedRemovalTime = calculatedRemovalTime;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto = (SetRemovalTimeToHistoricProcessInstancesDto) o;
    return Objects.equals(this.historicProcessInstanceIds, setRemovalTimeToHistoricProcessInstancesDto.historicProcessInstanceIds) &&
        Objects.equals(this.historicProcessInstanceQuery, setRemovalTimeToHistoricProcessInstancesDto.historicProcessInstanceQuery) &&
        Objects.equals(this.hierarchical, setRemovalTimeToHistoricProcessInstancesDto.hierarchical) &&
        Objects.equals(this.absoluteRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.absoluteRemovalTime) &&
        Objects.equals(this.clearedRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.clearedRemovalTime) &&
        Objects.equals(this.calculatedRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.calculatedRemovalTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(historicProcessInstanceIds, historicProcessInstanceQuery, hierarchical, absoluteRemovalTime, clearedRemovalTime, calculatedRemovalTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SetRemovalTimeToHistoricProcessInstancesDto {\n");
    sb.append("    historicProcessInstanceIds: ").append(toIndentedString(historicProcessInstanceIds)).append("\n");
    sb.append("    historicProcessInstanceQuery: ").append(toIndentedString(historicProcessInstanceQuery)).append("\n");
    sb.append("    hierarchical: ").append(toIndentedString(hierarchical)).append("\n");
    sb.append("    absoluteRemovalTime: ").append(toIndentedString(absoluteRemovalTime)).append("\n");
    sb.append("    clearedRemovalTime: ").append(toIndentedString(clearedRemovalTime)).append("\n");
    sb.append("    calculatedRemovalTime: ").append(toIndentedString(calculatedRemovalTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

