/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.ProcessInstanceModificationInstructionDto;
import org.camunda.community.rest.client.dto.VariableValueDto;

/**
 * StartProcessInstanceDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-23T14:22:53.022768Z[Etc/UTC]")
public class StartProcessInstanceDto {
  public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
  @SerializedName(SERIALIZED_NAME_BUSINESS_KEY)
  private String businessKey;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private Map<String, VariableValueDto> variables = null;

  public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
  @SerializedName(SERIALIZED_NAME_CASE_INSTANCE_ID)
  private String caseInstanceId;

  public static final String SERIALIZED_NAME_START_INSTRUCTIONS = "startInstructions";
  @SerializedName(SERIALIZED_NAME_START_INSTRUCTIONS)
  private List<ProcessInstanceModificationInstructionDto> startInstructions = null;

  public static final String SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
  @SerializedName(SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS)
  private Boolean skipCustomListeners;

  public static final String SERIALIZED_NAME_SKIP_IO_MAPPINGS = "skipIoMappings";
  @SerializedName(SERIALIZED_NAME_SKIP_IO_MAPPINGS)
  private Boolean skipIoMappings;

  public static final String SERIALIZED_NAME_WITH_VARIABLES_IN_RETURN = "withVariablesInReturn";
  @SerializedName(SERIALIZED_NAME_WITH_VARIABLES_IN_RETURN)
  private Boolean withVariablesInReturn;


  public StartProcessInstanceDto businessKey(String businessKey) {
    
    this.businessKey = businessKey;
    return this;
  }

   /**
   * The business key of the process instance.
   * @return businessKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The business key of the process instance.")

  public String getBusinessKey() {
    return businessKey;
  }


  public void setBusinessKey(String businessKey) {
    this.businessKey = businessKey;
  }


  public StartProcessInstanceDto variables(Map<String, VariableValueDto> variables) {
    
    this.variables = variables;
    return this;
  }

  public StartProcessInstanceDto putVariablesItem(String key, VariableValueDto variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<String, VariableValueDto>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

   /**
   * Get variables
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Map<String, VariableValueDto> getVariables() {
    return variables;
  }


  public void setVariables(Map<String, VariableValueDto> variables) {
    this.variables = variables;
  }


  public StartProcessInstanceDto caseInstanceId(String caseInstanceId) {
    
    this.caseInstanceId = caseInstanceId;
    return this;
  }

   /**
   * The case instance id the process instance is to be initialized with.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The case instance id the process instance is to be initialized with.")

  public String getCaseInstanceId() {
    return caseInstanceId;
  }


  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }


  public StartProcessInstanceDto startInstructions(List<ProcessInstanceModificationInstructionDto> startInstructions) {
    
    this.startInstructions = startInstructions;
    return this;
  }

  public StartProcessInstanceDto addStartInstructionsItem(ProcessInstanceModificationInstructionDto startInstructionsItem) {
    if (this.startInstructions == null) {
      this.startInstructions = new ArrayList<ProcessInstanceModificationInstructionDto>();
    }
    this.startInstructions.add(startInstructionsItem);
    return this;
  }

   /**
   * **Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.
   * @return startInstructions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "**Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.")

  public List<ProcessInstanceModificationInstructionDto> getStartInstructions() {
    return startInstructions;
  }


  public void setStartInstructions(List<ProcessInstanceModificationInstructionDto> startInstructions) {
    this.startInstructions = startInstructions;
  }


  public StartProcessInstanceDto skipCustomListeners(Boolean skipCustomListeners) {
    
    this.skipCustomListeners = skipCustomListeners;
    return this;
  }

   /**
   * Skip execution listener invocation for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the &#x60;startInstructions&#x60; property.
   * @return skipCustomListeners
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Skip execution listener invocation for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.")

  public Boolean getSkipCustomListeners() {
    return skipCustomListeners;
  }


  public void setSkipCustomListeners(Boolean skipCustomListeners) {
    this.skipCustomListeners = skipCustomListeners;
  }


  public StartProcessInstanceDto skipIoMappings(Boolean skipIoMappings) {
    
    this.skipIoMappings = skipIoMappings;
    return this;
  }

   /**
   * Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the &#x60;startInstructions&#x60; property.
   * @return skipIoMappings
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request. **Note**: This option is currently only respected when start instructions are submitted via the `startInstructions` property.")

  public Boolean getSkipIoMappings() {
    return skipIoMappings;
  }


  public void setSkipIoMappings(Boolean skipIoMappings) {
    this.skipIoMappings = skipIoMappings;
  }


  public StartProcessInstanceDto withVariablesInReturn(Boolean withVariablesInReturn) {
    
    this.withVariablesInReturn = withVariablesInReturn;
    return this;
  }

   /**
   * Indicates if the variables, which was used by the process instance during execution, should be returned. Default value: &#x60;false&#x60;
   * @return withVariablesInReturn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Indicates if the variables, which was used by the process instance during execution, should be returned. Default value: `false`")

  public Boolean getWithVariablesInReturn() {
    return withVariablesInReturn;
  }


  public void setWithVariablesInReturn(Boolean withVariablesInReturn) {
    this.withVariablesInReturn = withVariablesInReturn;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StartProcessInstanceDto startProcessInstanceDto = (StartProcessInstanceDto) o;
    return Objects.equals(this.businessKey, startProcessInstanceDto.businessKey) &&
        Objects.equals(this.variables, startProcessInstanceDto.variables) &&
        Objects.equals(this.caseInstanceId, startProcessInstanceDto.caseInstanceId) &&
        Objects.equals(this.startInstructions, startProcessInstanceDto.startInstructions) &&
        Objects.equals(this.skipCustomListeners, startProcessInstanceDto.skipCustomListeners) &&
        Objects.equals(this.skipIoMappings, startProcessInstanceDto.skipIoMappings) &&
        Objects.equals(this.withVariablesInReturn, startProcessInstanceDto.withVariablesInReturn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessKey, variables, caseInstanceId, startInstructions, skipCustomListeners, skipIoMappings, withVariablesInReturn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StartProcessInstanceDto {\n");
    sb.append("    businessKey: ").append(toIndentedString(businessKey)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    startInstructions: ").append(toIndentedString(startInstructions)).append("\n");
    sb.append("    skipCustomListeners: ").append(toIndentedString(skipCustomListeners)).append("\n");
    sb.append("    skipIoMappings: ").append(toIndentedString(skipIoMappings)).append("\n");
    sb.append("    withVariablesInReturn: ").append(toIndentedString(withVariablesInReturn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

