/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.CamundaFormRef;

/**
 * TaskDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-23T14:22:53.022768Z[Etc/UTC]")
public class TaskDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
  @SerializedName(SERIALIZED_NAME_ASSIGNEE)
  private String assignee;

  public static final String SERIALIZED_NAME_OWNER = "owner";
  @SerializedName(SERIALIZED_NAME_OWNER)
  private String owner;

  public static final String SERIALIZED_NAME_CREATED = "created";
  @SerializedName(SERIALIZED_NAME_CREATED)
  private Date created;

  public static final String SERIALIZED_NAME_DUE = "due";
  @SerializedName(SERIALIZED_NAME_DUE)
  private Date due;

  public static final String SERIALIZED_NAME_FOLLOW_UP = "followUp";
  @SerializedName(SERIALIZED_NAME_FOLLOW_UP)
  private Date followUp;

  /**
   * The task&#39;s delegation state. Possible values are &#x60;PENDING&#x60; and &#x60;RESOLVED&#x60;.
   */
  @JsonAdapter(DelegationStateEnum.Adapter.class)
  public enum DelegationStateEnum {
    PENDING("PENDING"),
    
    RESOLVED("RESOLVED");

    private String value;

    DelegationStateEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DelegationStateEnum fromValue(String value) {
      for (DelegationStateEnum b : DelegationStateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<DelegationStateEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DelegationStateEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DelegationStateEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DelegationStateEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DELEGATION_STATE = "delegationState";
  @SerializedName(SERIALIZED_NAME_DELEGATION_STATE)
  private DelegationStateEnum delegationState;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_PARENT_TASK_ID = "parentTaskId";
  @SerializedName(SERIALIZED_NAME_PARENT_TASK_ID)
  private String parentTaskId;

  public static final String SERIALIZED_NAME_PRIORITY = "priority";
  @SerializedName(SERIALIZED_NAME_PRIORITY)
  private Integer priority;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
  @SerializedName(SERIALIZED_NAME_CASE_EXECUTION_ID)
  private String caseExecutionId;

  public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
  @SerializedName(SERIALIZED_NAME_CASE_DEFINITION_ID)
  private String caseDefinitionId;

  public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
  @SerializedName(SERIALIZED_NAME_CASE_INSTANCE_ID)
  private String caseInstanceId;

  public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY = "taskDefinitionKey";
  @SerializedName(SERIALIZED_NAME_TASK_DEFINITION_KEY)
  private String taskDefinitionKey;

  public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
  @SerializedName(SERIALIZED_NAME_SUSPENDED)
  private Boolean suspended;

  public static final String SERIALIZED_NAME_FORM_KEY = "formKey";
  @SerializedName(SERIALIZED_NAME_FORM_KEY)
  private String formKey;

  public static final String SERIALIZED_NAME_CAMUNDA_FORM_REF = "camundaFormRef";
  @SerializedName(SERIALIZED_NAME_CAMUNDA_FORM_REF)
  private Map<String, CamundaFormRef> camundaFormRef = null;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;


  public TaskDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The task id.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The task id.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public TaskDto name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The task name.
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The task name.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public TaskDto assignee(String assignee) {
    
    this.assignee = assignee;
    return this;
  }

   /**
   * The assignee&#39;s id.
   * @return assignee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The assignee's id.")

  public String getAssignee() {
    return assignee;
  }


  public void setAssignee(String assignee) {
    this.assignee = assignee;
  }


  public TaskDto owner(String owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * The owner&#39;s id.
   * @return owner
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The owner's id.")

  public String getOwner() {
    return owner;
  }


  public void setOwner(String owner) {
    this.owner = owner;
  }


  public TaskDto created(Date created) {
    
    this.created = created;
    return this;
  }

   /**
   * The date the task was created on. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return created
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The date the task was created on. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")

  public Date getCreated() {
    return created;
  }


  public void setCreated(Date created) {
    this.created = created;
  }


  public TaskDto due(Date due) {
    
    this.due = due;
    return this;
  }

   /**
   * The task&#39;s due date. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return due
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The task's due date. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")

  public Date getDue() {
    return due;
  }


  public void setDue(Date due) {
    this.due = due;
  }


  public TaskDto followUp(Date followUp) {
    
    this.followUp = followUp;
    return this;
  }

   /**
   * The follow-up date for the task. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   * @return followUp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The follow-up date for the task. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")

  public Date getFollowUp() {
    return followUp;
  }


  public void setFollowUp(Date followUp) {
    this.followUp = followUp;
  }


  public TaskDto delegationState(DelegationStateEnum delegationState) {
    
    this.delegationState = delegationState;
    return this;
  }

   /**
   * The task&#39;s delegation state. Possible values are &#x60;PENDING&#x60; and &#x60;RESOLVED&#x60;.
   * @return delegationState
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The task's delegation state. Possible values are `PENDING` and `RESOLVED`.")

  public DelegationStateEnum getDelegationState() {
    return delegationState;
  }


  public void setDelegationState(DelegationStateEnum delegationState) {
    this.delegationState = delegationState;
  }


  public TaskDto description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The task&#39;s description.
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The task's description.")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public TaskDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * The id of the execution the task belongs to.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the execution the task belongs to.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public TaskDto parentTaskId(String parentTaskId) {
    
    this.parentTaskId = parentTaskId;
    return this;
  }

   /**
   * The id the parent task, if this task is a subtask.
   * @return parentTaskId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id the parent task, if this task is a subtask.")

  public String getParentTaskId() {
    return parentTaskId;
  }


  public void setParentTaskId(String parentTaskId) {
    this.parentTaskId = parentTaskId;
  }


  public TaskDto priority(Integer priority) {
    
    this.priority = priority;
    return this;
  }

   /**
   * The task&#39;s priority.
   * @return priority
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The task's priority.")

  public Integer getPriority() {
    return priority;
  }


  public void setPriority(Integer priority) {
    this.priority = priority;
  }


  public TaskDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * The id of the process definition the task belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process definition the task belongs to.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public TaskDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * The id of the process instance the task belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process instance the task belongs to.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public TaskDto caseExecutionId(String caseExecutionId) {
    
    this.caseExecutionId = caseExecutionId;
    return this;
  }

   /**
   * The id of the case execution the task belongs to.
   * @return caseExecutionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the case execution the task belongs to.")

  public String getCaseExecutionId() {
    return caseExecutionId;
  }


  public void setCaseExecutionId(String caseExecutionId) {
    this.caseExecutionId = caseExecutionId;
  }


  public TaskDto caseDefinitionId(String caseDefinitionId) {
    
    this.caseDefinitionId = caseDefinitionId;
    return this;
  }

   /**
   * The id of the case definition the task belongs to.
   * @return caseDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the case definition the task belongs to.")

  public String getCaseDefinitionId() {
    return caseDefinitionId;
  }


  public void setCaseDefinitionId(String caseDefinitionId) {
    this.caseDefinitionId = caseDefinitionId;
  }


  public TaskDto caseInstanceId(String caseInstanceId) {
    
    this.caseInstanceId = caseInstanceId;
    return this;
  }

   /**
   * The id of the case instance the task belongs to.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the case instance the task belongs to.")

  public String getCaseInstanceId() {
    return caseInstanceId;
  }


  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }


  public TaskDto taskDefinitionKey(String taskDefinitionKey) {
    
    this.taskDefinitionKey = taskDefinitionKey;
    return this;
  }

   /**
   * The task&#39;s key.
   * @return taskDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The task's key.")

  public String getTaskDefinitionKey() {
    return taskDefinitionKey;
  }


  public void setTaskDefinitionKey(String taskDefinitionKey) {
    this.taskDefinitionKey = taskDefinitionKey;
  }


  public TaskDto suspended(Boolean suspended) {
    
    this.suspended = suspended;
    return this;
  }

   /**
   * Whether the task belongs to a process instance that is suspended.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the task belongs to a process instance that is suspended.")

  public Boolean getSuspended() {
    return suspended;
  }


  public void setSuspended(Boolean suspended) {
    this.suspended = suspended;
  }


  public TaskDto formKey(String formKey) {
    
    this.formKey = formKey;
    return this;
  }

   /**
   * If not &#x60;null&#x60;, the form key for the task.
   * @return formKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If not `null`, the form key for the task.")

  public String getFormKey() {
    return formKey;
  }


  public void setFormKey(String formKey) {
    this.formKey = formKey;
  }


  public TaskDto camundaFormRef(Map<String, CamundaFormRef> camundaFormRef) {
    
    this.camundaFormRef = camundaFormRef;
    return this;
  }

  public TaskDto putCamundaFormRefItem(String key, CamundaFormRef camundaFormRefItem) {
    if (this.camundaFormRef == null) {
      this.camundaFormRef = new HashMap<String, CamundaFormRef>();
    }
    this.camundaFormRef.put(key, camundaFormRefItem);
    return this;
  }

   /**
   * A reference to a specific version of a Camunda Form.
   * @return camundaFormRef
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A reference to a specific version of a Camunda Form.")

  public Map<String, CamundaFormRef> getCamundaFormRef() {
    return camundaFormRef;
  }


  public void setCamundaFormRef(Map<String, CamundaFormRef> camundaFormRef) {
    this.camundaFormRef = camundaFormRef;
  }


  public TaskDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * If not &#x60;null&#x60;, the tenant id of the task.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If not `null`, the tenant id of the task.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskDto taskDto = (TaskDto) o;
    return Objects.equals(this.id, taskDto.id) &&
        Objects.equals(this.name, taskDto.name) &&
        Objects.equals(this.assignee, taskDto.assignee) &&
        Objects.equals(this.owner, taskDto.owner) &&
        Objects.equals(this.created, taskDto.created) &&
        Objects.equals(this.due, taskDto.due) &&
        Objects.equals(this.followUp, taskDto.followUp) &&
        Objects.equals(this.delegationState, taskDto.delegationState) &&
        Objects.equals(this.description, taskDto.description) &&
        Objects.equals(this.executionId, taskDto.executionId) &&
        Objects.equals(this.parentTaskId, taskDto.parentTaskId) &&
        Objects.equals(this.priority, taskDto.priority) &&
        Objects.equals(this.processDefinitionId, taskDto.processDefinitionId) &&
        Objects.equals(this.processInstanceId, taskDto.processInstanceId) &&
        Objects.equals(this.caseExecutionId, taskDto.caseExecutionId) &&
        Objects.equals(this.caseDefinitionId, taskDto.caseDefinitionId) &&
        Objects.equals(this.caseInstanceId, taskDto.caseInstanceId) &&
        Objects.equals(this.taskDefinitionKey, taskDto.taskDefinitionKey) &&
        Objects.equals(this.suspended, taskDto.suspended) &&
        Objects.equals(this.formKey, taskDto.formKey) &&
        Objects.equals(this.camundaFormRef, taskDto.camundaFormRef) &&
        Objects.equals(this.tenantId, taskDto.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, assignee, owner, created, due, followUp, delegationState, description, executionId, parentTaskId, priority, processDefinitionId, processInstanceId, caseExecutionId, caseDefinitionId, caseInstanceId, taskDefinitionKey, suspended, formKey, camundaFormRef, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    due: ").append(toIndentedString(due)).append("\n");
    sb.append("    followUp: ").append(toIndentedString(followUp)).append("\n");
    sb.append("    delegationState: ").append(toIndentedString(delegationState)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    parentTaskId: ").append(toIndentedString(parentTaskId)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    caseExecutionId: ").append(toIndentedString(caseExecutionId)).append("\n");
    sb.append("    caseDefinitionId: ").append(toIndentedString(caseDefinitionId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    taskDefinitionKey: ").append(toIndentedString(taskDefinitionKey)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    formKey: ").append(toIndentedString(formKey)).append("\n");
    sb.append("    camundaFormRef: ").append(toIndentedString(camundaFormRef)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

