/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.camunda.community.rest.client.dto.ConditionQueryParameterDto;
import org.camunda.community.rest.client.dto.VariableQueryParameterDtoAllOf;

/**
 * VariableQueryParameterDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-23T14:22:53.022768Z[Etc/UTC]")
public class VariableQueryParameterDto {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * Comparison operator to be used. &#x60;notLike&#x60; is not supported by all endpoints.
   */
  @JsonAdapter(OperatorEnum.Adapter.class)
  public enum OperatorEnum {
    EQ("eq"),
    
    NEQ("neq"),
    
    GT("gt"),
    
    GTEQ("gteq"),
    
    LT("lt"),
    
    LTEQ("lteq"),
    
    LIKE("like"),
    
    NOTLIKE("notLike");

    private String value;

    OperatorEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static OperatorEnum fromValue(String value) {
      for (OperatorEnum b : OperatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<OperatorEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final OperatorEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public OperatorEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return OperatorEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_OPERATOR = "operator";
  @SerializedName(SERIALIZED_NAME_OPERATOR)
  private OperatorEnum operator;

  public static final String SERIALIZED_NAME_VALUE = "value";
  @SerializedName(SERIALIZED_NAME_VALUE)
  private Object value = null;


  public VariableQueryParameterDto name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Variable name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Variable name")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public VariableQueryParameterDto operator(OperatorEnum operator) {
    
    this.operator = operator;
    return this;
  }

   /**
   * Comparison operator to be used. &#x60;notLike&#x60; is not supported by all endpoints.
   * @return operator
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Comparison operator to be used. `notLike` is not supported by all endpoints.")

  public OperatorEnum getOperator() {
    return operator;
  }


  public void setOperator(OperatorEnum operator) {
    this.operator = operator;
  }


  public VariableQueryParameterDto value(Object value) {
    
    this.value = value;
    return this;
  }

   /**
   * Can be any value - string, number, boolean, array or object.  **Note**: Not every endpoint supports every type.
   * @return value
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be any value - string, number, boolean, array or object.  **Note**: Not every endpoint supports every type.")

  public Object getValue() {
    return value;
  }


  public void setValue(Object value) {
    this.value = value;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VariableQueryParameterDto variableQueryParameterDto = (VariableQueryParameterDto) o;
    return Objects.equals(this.name, variableQueryParameterDto.name) &&
        Objects.equals(this.operator, variableQueryParameterDto.operator) &&
        Objects.equals(this.value, variableQueryParameterDto.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, operator, value);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VariableQueryParameterDto {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

