/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.ActivityStatisticsResultDto;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CalledProcessDefinitionDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.FormDto;
import org.camunda.community.rest.client.dto.HistoryTimeToLiveDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDiagramDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionStatisticsResultDto;
import org.camunda.community.rest.client.dto.ProcessDefinitionSuspensionStateDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.ProcessInstanceWithVariablesDto;
import org.camunda.community.rest.client.dto.RestartProcessInstanceDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceDto;
import org.camunda.community.rest.client.dto.StartProcessInstanceFormDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class ProcessDefinitionApi {
    private ApiClient localVarApiClient;

    public ProcessDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProcessDefinitionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteProcessDefinitionCall(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cascade != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cascade", cascade));
        }
        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }
        if (skipIoMappings != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProcessDefinitionValidateBeforeCall(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProcessDefinition(Async)");
        }
        Call localVarCall = this.deleteProcessDefinitionCall(id, cascade, skipCustomListeners, skipIoMappings, _callback);
        return localVarCall;
    }

    public void deleteProcessDefinition(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteProcessDefinitionWithHttpInfo(id, cascade, skipCustomListeners, skipIoMappings);
    }

    public ApiResponse<Void> deleteProcessDefinitionWithHttpInfo(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        Call localVarCall = this.deleteProcessDefinitionValidateBeforeCall(id, cascade, skipCustomListeners, skipIoMappings, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProcessDefinitionAsync(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProcessDefinitionValidateBeforeCall(id, cascade, skipCustomListeners, skipIoMappings, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteProcessDefinitionsByKeyCall(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cascade != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cascade", cascade));
        }
        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }
        if (skipIoMappings != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProcessDefinitionsByKeyValidateBeforeCall(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling deleteProcessDefinitionsByKey(Async)");
        }
        Call localVarCall = this.deleteProcessDefinitionsByKeyCall(key, cascade, skipCustomListeners, skipIoMappings, _callback);
        return localVarCall;
    }

    public void deleteProcessDefinitionsByKey(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteProcessDefinitionsByKeyWithHttpInfo(key, cascade, skipCustomListeners, skipIoMappings);
    }

    public ApiResponse<Void> deleteProcessDefinitionsByKeyWithHttpInfo(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        Call localVarCall = this.deleteProcessDefinitionsByKeyValidateBeforeCall(key, cascade, skipCustomListeners, skipIoMappings, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProcessDefinitionsByKeyAsync(String key, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProcessDefinitionsByKeyValidateBeforeCall(key, cascade, skipCustomListeners, skipIoMappings, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteProcessDefinitionsByKeyAndTenantIdCall(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cascade != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cascade", cascade));
        }
        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }
        if (skipIoMappings != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProcessDefinitionsByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling deleteProcessDefinitionsByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling deleteProcessDefinitionsByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.deleteProcessDefinitionsByKeyAndTenantIdCall(key, tenantId, cascade, skipCustomListeners, skipIoMappings, _callback);
        return localVarCall;
    }

    public void deleteProcessDefinitionsByKeyAndTenantId(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteProcessDefinitionsByKeyAndTenantIdWithHttpInfo(key, tenantId, cascade, skipCustomListeners, skipIoMappings);
    }

    public ApiResponse<Void> deleteProcessDefinitionsByKeyAndTenantIdWithHttpInfo(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        Call localVarCall = this.deleteProcessDefinitionsByKeyAndTenantIdValidateBeforeCall(key, tenantId, cascade, skipCustomListeners, skipIoMappings, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProcessDefinitionsByKeyAndTenantIdAsync(String key, String tenantId, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProcessDefinitionsByKeyAndTenantIdValidateBeforeCall(key, tenantId, cascade, skipCustomListeners, skipIoMappings, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getActivityStatisticsCall(String id, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/statistics".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (failedJobs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }
        if (incidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidents", incidents));
        }
        if (incidentsForType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getActivityStatisticsValidateBeforeCall(String id, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getActivityStatistics(Async)");
        }
        Call localVarCall = this.getActivityStatisticsCall(id, failedJobs, incidents, incidentsForType, _callback);
        return localVarCall;
    }

    public List<ActivityStatisticsResultDto> getActivityStatistics(String id, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        ApiResponse<List<ActivityStatisticsResultDto>> localVarResp = this.getActivityStatisticsWithHttpInfo(id, failedJobs, incidents, incidentsForType);
        return localVarResp.getData();
    }

    public ApiResponse<List<ActivityStatisticsResultDto>> getActivityStatisticsWithHttpInfo(String id, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        Call localVarCall = this.getActivityStatisticsValidateBeforeCall(id, failedJobs, incidents, incidentsForType, null);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getActivityStatisticsAsync(String id, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback<List<ActivityStatisticsResultDto>> _callback) throws ApiException {
        Call localVarCall = this.getActivityStatisticsValidateBeforeCall(id, failedJobs, incidents, incidentsForType, _callback);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getActivityStatisticsByProcessDefinitionKeyCall(String key, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/statistics".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (failedJobs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }
        if (incidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidents", incidents));
        }
        if (incidentsForType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getActivityStatisticsByProcessDefinitionKeyValidateBeforeCall(String key, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getActivityStatisticsByProcessDefinitionKey(Async)");
        }
        Call localVarCall = this.getActivityStatisticsByProcessDefinitionKeyCall(key, failedJobs, incidents, incidentsForType, _callback);
        return localVarCall;
    }

    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKey(String key, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        ApiResponse<List<ActivityStatisticsResultDto>> localVarResp = this.getActivityStatisticsByProcessDefinitionKeyWithHttpInfo(key, failedJobs, incidents, incidentsForType);
        return localVarResp.getData();
    }

    public ApiResponse<List<ActivityStatisticsResultDto>> getActivityStatisticsByProcessDefinitionKeyWithHttpInfo(String key, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        Call localVarCall = this.getActivityStatisticsByProcessDefinitionKeyValidateBeforeCall(key, failedJobs, incidents, incidentsForType, null);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getActivityStatisticsByProcessDefinitionKeyAsync(String key, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback<List<ActivityStatisticsResultDto>> _callback) throws ApiException {
        Call localVarCall = this.getActivityStatisticsByProcessDefinitionKeyValidateBeforeCall(key, failedJobs, incidents, incidentsForType, _callback);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getActivityStatisticsByProcessDefinitionKeyAndTenantIdCall(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/statistics".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (failedJobs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }
        if (incidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidents", incidents));
        }
        if (incidentsForType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getActivityStatisticsByProcessDefinitionKeyAndTenantIdValidateBeforeCall(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getActivityStatisticsByProcessDefinitionKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getActivityStatisticsByProcessDefinitionKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getActivityStatisticsByProcessDefinitionKeyAndTenantIdCall(key, tenantId, failedJobs, incidents, incidentsForType, _callback);
        return localVarCall;
    }

    public List<ActivityStatisticsResultDto> getActivityStatisticsByProcessDefinitionKeyAndTenantId(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        ApiResponse<List<ActivityStatisticsResultDto>> localVarResp = this.getActivityStatisticsByProcessDefinitionKeyAndTenantIdWithHttpInfo(key, tenantId, failedJobs, incidents, incidentsForType);
        return localVarResp.getData();
    }

    public ApiResponse<List<ActivityStatisticsResultDto>> getActivityStatisticsByProcessDefinitionKeyAndTenantIdWithHttpInfo(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType) throws ApiException {
        Call localVarCall = this.getActivityStatisticsByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, failedJobs, incidents, incidentsForType, null);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getActivityStatisticsByProcessDefinitionKeyAndTenantIdAsync(String key, String tenantId, Boolean failedJobs, Boolean incidents, String incidentsForType, ApiCallback<List<ActivityStatisticsResultDto>> _callback) throws ApiException {
        Call localVarCall = this.getActivityStatisticsByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, failedJobs, incidents, incidentsForType, _callback);
        Type localVarReturnType = new TypeToken<List<ActivityStatisticsResultDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeployedStartFormCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/deployed-start-form".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeployedStartFormValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDeployedStartForm(Async)");
        }
        Call localVarCall = this.getDeployedStartFormCall(id, _callback);
        return localVarCall;
    }

    public File getDeployedStartForm(String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getDeployedStartFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDeployedStartFormWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getDeployedStartFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeployedStartFormAsync(String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDeployedStartFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeployedStartFormByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/deployed-start-form".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeployedStartFormByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDeployedStartFormByKey(Async)");
        }
        Call localVarCall = this.getDeployedStartFormByKeyCall(key, _callback);
        return localVarCall;
    }

    public File getDeployedStartFormByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = this.getDeployedStartFormByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDeployedStartFormByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getDeployedStartFormByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeployedStartFormByKeyAsync(String key, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDeployedStartFormByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeployedStartFormByKeyAndTenantIdCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/deployed-start-form".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeployedStartFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getDeployedStartFormByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getDeployedStartFormByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getDeployedStartFormByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;
    }

    public File getDeployedStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = this.getDeployedStartFormByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDeployedStartFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getDeployedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeployedStartFormByKeyAndTenantIdAsync(String key, String tenantId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDeployedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLatestProcessDefinitionByTenantIdCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLatestProcessDefinitionByTenantIdValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getLatestProcessDefinitionByTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getLatestProcessDefinitionByTenantId(Async)");
        }
        Call localVarCall = this.getLatestProcessDefinitionByTenantIdCall(key, tenantId, _callback);
        return localVarCall;
    }

    public ProcessDefinitionDto getLatestProcessDefinitionByTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<ProcessDefinitionDto> localVarResp = this.getLatestProcessDefinitionByTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessDefinitionDto> getLatestProcessDefinitionByTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getLatestProcessDefinitionByTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLatestProcessDefinitionByTenantIdAsync(String key, String tenantId, ApiCallback<ProcessDefinitionDto> _callback) throws ApiException {
        Call localVarCall = this.getLatestProcessDefinitionByTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessDefinition(Async)");
        }
        Call localVarCall = this.getProcessDefinitionCall(id, _callback);
        return localVarCall;
    }

    public ProcessDefinitionDto getProcessDefinition(String id) throws ApiException {
        ApiResponse<ProcessDefinitionDto> localVarResp = this.getProcessDefinitionWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessDefinitionDto> getProcessDefinitionWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getProcessDefinitionValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionAsync(String id, ApiCallback<ProcessDefinitionDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionBpmn20XmlCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/xml".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionBpmn20XmlValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessDefinitionBpmn20Xml(Async)");
        }
        Call localVarCall = this.getProcessDefinitionBpmn20XmlCall(id, _callback);
        return localVarCall;
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20Xml(String id) throws ApiException {
        ApiResponse<ProcessDefinitionDiagramDto> localVarResp = this.getProcessDefinitionBpmn20XmlWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessDefinitionDiagramDto> getProcessDefinitionBpmn20XmlWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getProcessDefinitionBpmn20XmlValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionBpmn20XmlAsync(String id, ApiCallback<ProcessDefinitionDiagramDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionBpmn20XmlValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionBpmn20XmlByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/xml".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionBpmn20XmlByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionBpmn20XmlByKey(Async)");
        }
        Call localVarCall = this.getProcessDefinitionBpmn20XmlByKeyCall(key, _callback);
        return localVarCall;
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKey(String key) throws ApiException {
        ApiResponse<ProcessDefinitionDiagramDto> localVarResp = this.getProcessDefinitionBpmn20XmlByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessDefinitionDiagramDto> getProcessDefinitionBpmn20XmlByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getProcessDefinitionBpmn20XmlByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionBpmn20XmlByKeyAsync(String key, ApiCallback<ProcessDefinitionDiagramDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionBpmn20XmlByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionBpmn20XmlByKeyAndTenantIdCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/xml".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionBpmn20XmlByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionBpmn20XmlByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getProcessDefinitionBpmn20XmlByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getProcessDefinitionBpmn20XmlByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;
    }

    public ProcessDefinitionDiagramDto getProcessDefinitionBpmn20XmlByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<ProcessDefinitionDiagramDto> localVarResp = this.getProcessDefinitionBpmn20XmlByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessDefinitionDiagramDto> getProcessDefinitionBpmn20XmlByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getProcessDefinitionBpmn20XmlByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionBpmn20XmlByKeyAndTenantIdAsync(String key, String tenantId, ApiCallback<ProcessDefinitionDiagramDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionBpmn20XmlByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDiagramDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionByKey(Async)");
        }
        Call localVarCall = this.getProcessDefinitionByKeyCall(key, _callback);
        return localVarCall;
    }

    public ProcessDefinitionDto getProcessDefinitionByKey(String key) throws ApiException {
        ApiResponse<ProcessDefinitionDto> localVarResp = this.getProcessDefinitionByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessDefinitionDto> getProcessDefinitionByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getProcessDefinitionByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionByKeyAsync(String key, ApiCallback<ProcessDefinitionDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<ProcessDefinitionDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionDiagramCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/diagram".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionDiagramValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessDefinitionDiagram(Async)");
        }
        Call localVarCall = this.getProcessDefinitionDiagramCall(id, _callback);
        return localVarCall;
    }

    public File getProcessDefinitionDiagram(String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getProcessDefinitionDiagramWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getProcessDefinitionDiagramWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getProcessDefinitionDiagramValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionDiagramAsync(String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionDiagramValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionDiagramByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/diagram".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionDiagramByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionDiagramByKey(Async)");
        }
        Call localVarCall = this.getProcessDefinitionDiagramByKeyCall(key, _callback);
        return localVarCall;
    }

    public File getProcessDefinitionDiagramByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = this.getProcessDefinitionDiagramByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<File> getProcessDefinitionDiagramByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getProcessDefinitionDiagramByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionDiagramByKeyAsync(String key, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionDiagramByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionDiagramByKeyAndTenantIdCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/diagram".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getProcessDefinitionDiagramByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getProcessDefinitionDiagramByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getProcessDefinitionDiagramByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;
    }

    public File getProcessDefinitionDiagramByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = this.getProcessDefinitionDiagramByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getProcessDefinitionDiagramByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getProcessDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionDiagramByKeyAndTenantIdAsync(String key, String tenantId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionDiagramByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionStatisticsCall(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/statistics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (failedJobs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedJobs", failedJobs));
        }
        if (incidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidents", incidents));
        }
        if (incidentsForType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentsForType", incidentsForType));
        }
        if (rootIncidents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rootIncidents", rootIncidents));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionStatisticsValidateBeforeCall(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionStatisticsCall(failedJobs, incidents, incidentsForType, rootIncidents, _callback);
        return localVarCall;
    }

    public List<ProcessDefinitionStatisticsResultDto> getProcessDefinitionStatistics(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents) throws ApiException {
        ApiResponse<List<ProcessDefinitionStatisticsResultDto>> localVarResp = this.getProcessDefinitionStatisticsWithHttpInfo(failedJobs, incidents, incidentsForType, rootIncidents);
        return localVarResp.getData();
    }

    public ApiResponse<List<ProcessDefinitionStatisticsResultDto>> getProcessDefinitionStatisticsWithHttpInfo(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents) throws ApiException {
        Call localVarCall = this.getProcessDefinitionStatisticsValidateBeforeCall(failedJobs, incidents, incidentsForType, rootIncidents, null);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionStatisticsResultDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionStatisticsAsync(Boolean failedJobs, Boolean incidents, String incidentsForType, Boolean rootIncidents, ApiCallback<List<ProcessDefinitionStatisticsResultDto>> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionStatisticsValidateBeforeCall(failedJobs, incidents, incidentsForType, rootIncidents, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionStatisticsResultDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionsCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (deploymentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }
        if (deployedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }
        if (deployedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }
        if (key != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("key", key));
        }
        if (keysIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keysIn", keysIn));
        }
        if (keyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keyLike", keyLike));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category", category));
        }
        if (categoryLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (latestVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }
        if (resourceName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceName", resourceName));
        }
        if (resourceNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }
        if (startableBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startableBy", startableBy));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeProcessDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeProcessDefinitionsWithoutTenantId", includeProcessDefinitionsWithoutTenantId));
        }
        if (versionTag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTag", versionTag));
        }
        if (versionTagLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }
        if (withoutVersionTag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutVersionTag", withoutVersionTag));
        }
        if (startableInTasklist != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startableInTasklist", startableInTasklist));
        }
        if (notStartableInTasklist != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("notStartableInTasklist", notStartableInTasklist));
        }
        if (startablePermissionCheck != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startablePermissionCheck", startablePermissionCheck));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionsValidateBeforeCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionsCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<ProcessDefinitionDto> getProcessDefinitions(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<ProcessDefinitionDto>> localVarResp = this.getProcessDefinitionsWithHttpInfo(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<ProcessDefinitionDto>> getProcessDefinitionsWithHttpInfo(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getProcessDefinitionsValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionsAsync(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<ProcessDefinitionDto>> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionsValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessDefinitionDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessDefinitionsCountCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (deploymentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }
        if (deployedAfter != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAfter", deployedAfter));
        }
        if (deployedAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployedAt", deployedAt));
        }
        if (key != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("key", key));
        }
        if (keysIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keysIn", keysIn));
        }
        if (keyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("keyLike", keyLike));
        }
        if (category != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("category", category));
        }
        if (categoryLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("categoryLike", categoryLike));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (latestVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("latestVersion", latestVersion));
        }
        if (resourceName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceName", resourceName));
        }
        if (resourceNameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceNameLike", resourceNameLike));
        }
        if (startableBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startableBy", startableBy));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeProcessDefinitionsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeProcessDefinitionsWithoutTenantId", includeProcessDefinitionsWithoutTenantId));
        }
        if (versionTag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTag", versionTag));
        }
        if (versionTagLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("versionTagLike", versionTagLike));
        }
        if (withoutVersionTag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutVersionTag", withoutVersionTag));
        }
        if (startableInTasklist != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startableInTasklist", startableInTasklist));
        }
        if (notStartableInTasklist != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("notStartableInTasklist", notStartableInTasklist));
        }
        if (startablePermissionCheck != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startablePermissionCheck", startablePermissionCheck));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessDefinitionsCountValidateBeforeCall(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionsCountCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, _callback);
        return localVarCall;
    }

    public CountResultDto getProcessDefinitionsCount(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getProcessDefinitionsCountWithHttpInfo(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getProcessDefinitionsCountWithHttpInfo(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck) throws ApiException {
        Call localVarCall = this.getProcessDefinitionsCountValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessDefinitionsCountAsync(String processDefinitionId, String processDefinitionIdIn, String name, String nameLike, String deploymentId, Date deployedAfter, Date deployedAt, String key, String keysIn, String keyLike, String category, String categoryLike, Integer version, Boolean latestVersion, String resourceName, String resourceNameLike, String startableBy, Boolean active, Boolean suspended, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean includeProcessDefinitionsWithoutTenantId, String versionTag, String versionTagLike, Boolean withoutVersionTag, Boolean startableInTasklist, Boolean notStartableInTasklist, Boolean startablePermissionCheck, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessDefinitionsCountValidateBeforeCall(processDefinitionId, processDefinitionIdIn, name, nameLike, deploymentId, deployedAfter, deployedAt, key, keysIn, keyLike, category, categoryLike, version, latestVersion, resourceName, resourceNameLike, startableBy, active, suspended, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, includeProcessDefinitionsWithoutTenantId, versionTag, versionTagLike, withoutVersionTag, startableInTasklist, notStartableInTasklist, startablePermissionCheck, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRenderedStartFormCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/rendered-form".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRenderedStartFormValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getRenderedStartForm(Async)");
        }
        Call localVarCall = this.getRenderedStartFormCall(id, _callback);
        return localVarCall;
    }

    public File getRenderedStartForm(String id) throws ApiException {
        ApiResponse<File> localVarResp = this.getRenderedStartFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<File> getRenderedStartFormWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getRenderedStartFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRenderedStartFormAsync(String id, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getRenderedStartFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRenderedStartFormByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/rendered-form".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRenderedStartFormByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getRenderedStartFormByKey(Async)");
        }
        Call localVarCall = this.getRenderedStartFormByKeyCall(key, _callback);
        return localVarCall;
    }

    public File getRenderedStartFormByKey(String key) throws ApiException {
        ApiResponse<File> localVarResp = this.getRenderedStartFormByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<File> getRenderedStartFormByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getRenderedStartFormByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRenderedStartFormByKeyAsync(String key, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getRenderedStartFormByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRenderedStartFormByKeyAndTenantIdCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/rendered-form".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/xhtml+xml", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRenderedStartFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getRenderedStartFormByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getRenderedStartFormByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getRenderedStartFormByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;
    }

    public File getRenderedStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<File> localVarResp = this.getRenderedStartFormByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getRenderedStartFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getRenderedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRenderedStartFormByKeyAndTenantIdAsync(String key, String tenantId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getRenderedStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStartFormCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/startForm".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStartFormValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStartForm(Async)");
        }
        Call localVarCall = this.getStartFormCall(id, _callback);
        return localVarCall;
    }

    public FormDto getStartForm(String id) throws ApiException {
        ApiResponse<FormDto> localVarResp = this.getStartFormWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<FormDto> getStartFormWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getStartFormValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStartFormAsync(String id, ApiCallback<FormDto> _callback) throws ApiException {
        Call localVarCall = this.getStartFormValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStartFormByKeyCall(String key, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/startForm".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStartFormByKeyValidateBeforeCall(String key, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormByKey(Async)");
        }
        Call localVarCall = this.getStartFormByKeyCall(key, _callback);
        return localVarCall;
    }

    public FormDto getStartFormByKey(String key) throws ApiException {
        ApiResponse<FormDto> localVarResp = this.getStartFormByKeyWithHttpInfo(key);
        return localVarResp.getData();
    }

    public ApiResponse<FormDto> getStartFormByKeyWithHttpInfo(String key) throws ApiException {
        Call localVarCall = this.getStartFormByKeyValidateBeforeCall(key, null);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStartFormByKeyAsync(String key, ApiCallback<FormDto> _callback) throws ApiException {
        Call localVarCall = this.getStartFormByKeyValidateBeforeCall(key, _callback);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStartFormByKeyAndTenantIdCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/startForm".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStartFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getStartFormByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getStartFormByKeyAndTenantIdCall(key, tenantId, _callback);
        return localVarCall;
    }

    public FormDto getStartFormByKeyAndTenantId(String key, String tenantId) throws ApiException {
        ApiResponse<FormDto> localVarResp = this.getStartFormByKeyAndTenantIdWithHttpInfo(key, tenantId);
        return localVarResp.getData();
    }

    public ApiResponse<FormDto> getStartFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId) throws ApiException {
        Call localVarCall = this.getStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, null);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStartFormByKeyAndTenantIdAsync(String key, String tenantId, ApiCallback<FormDto> _callback) throws ApiException {
        Call localVarCall = this.getStartFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, _callback);
        Type localVarReturnType = new TypeToken<FormDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStartFormVariablesCall(String id, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/form-variables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (variableNames != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNames", variableNames));
        }
        if (deserializeValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStartFormVariablesValidateBeforeCall(String id, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStartFormVariables(Async)");
        }
        Call localVarCall = this.getStartFormVariablesCall(id, variableNames, deserializeValues, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> getStartFormVariables(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.getStartFormVariablesWithHttpInfo(id, variableNames, deserializeValues);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> getStartFormVariablesWithHttpInfo(String id, String variableNames, Boolean deserializeValues) throws ApiException {
        Call localVarCall = this.getStartFormVariablesValidateBeforeCall(id, variableNames, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStartFormVariablesAsync(String id, String variableNames, Boolean deserializeValues, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.getStartFormVariablesValidateBeforeCall(id, variableNames, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStartFormVariablesByKeyCall(String key, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/form-variables".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (variableNames != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNames", variableNames));
        }
        if (deserializeValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStartFormVariablesByKeyValidateBeforeCall(String key, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormVariablesByKey(Async)");
        }
        Call localVarCall = this.getStartFormVariablesByKeyCall(key, variableNames, deserializeValues, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> getStartFormVariablesByKey(String key, String variableNames, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.getStartFormVariablesByKeyWithHttpInfo(key, variableNames, deserializeValues);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> getStartFormVariablesByKeyWithHttpInfo(String key, String variableNames, Boolean deserializeValues) throws ApiException {
        Call localVarCall = this.getStartFormVariablesByKeyValidateBeforeCall(key, variableNames, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStartFormVariablesByKeyAsync(String key, String variableNames, Boolean deserializeValues, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.getStartFormVariablesByKeyValidateBeforeCall(key, variableNames, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStartFormVariablesByKeyAndTenantIdCall(String key, String tenantId, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/form-variables".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (variableNames != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNames", variableNames));
        }
        if (deserializeValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStartFormVariablesByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, String variableNames, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getStartFormVariablesByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling getStartFormVariablesByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.getStartFormVariablesByKeyAndTenantIdCall(key, tenantId, variableNames, deserializeValues, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> getStartFormVariablesByKeyAndTenantId(String key, String tenantId, String variableNames, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.getStartFormVariablesByKeyAndTenantIdWithHttpInfo(key, tenantId, variableNames, deserializeValues);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> getStartFormVariablesByKeyAndTenantIdWithHttpInfo(String key, String tenantId, String variableNames, Boolean deserializeValues) throws ApiException {
        Call localVarCall = this.getStartFormVariablesByKeyAndTenantIdValidateBeforeCall(key, tenantId, variableNames, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStartFormVariablesByKeyAndTenantIdAsync(String key, String tenantId, String variableNames, Boolean deserializeValues, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.getStartFormVariablesByKeyAndTenantIdValidateBeforeCall(key, tenantId, variableNames, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStaticCalledProcessDefinitionsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-definition/{id}/static-called-process-definitions".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStaticCalledProcessDefinitionsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStaticCalledProcessDefinitions(Async)");
        }
        Call localVarCall = this.getStaticCalledProcessDefinitionsCall(id, _callback);
        return localVarCall;
    }

    public List<CalledProcessDefinitionDto> getStaticCalledProcessDefinitions(String id) throws ApiException {
        ApiResponse<List<CalledProcessDefinitionDto>> localVarResp = this.getStaticCalledProcessDefinitionsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<List<CalledProcessDefinitionDto>> getStaticCalledProcessDefinitionsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getStaticCalledProcessDefinitionsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<List<CalledProcessDefinitionDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStaticCalledProcessDefinitionsAsync(String id, ApiCallback<List<CalledProcessDefinitionDto>> _callback) throws ApiException {
        Call localVarCall = this.getStaticCalledProcessDefinitionsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<List<CalledProcessDefinitionDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call restartProcessInstanceCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, ApiCallback _callback) throws ApiException {
        RestartProcessInstanceDto localVarPostBody = restartProcessInstanceDto;
        String localVarPath = "/process-definition/{id}/restart".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restartProcessInstanceValidateBeforeCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling restartProcessInstance(Async)");
        }
        Call localVarCall = this.restartProcessInstanceCall(id, restartProcessInstanceDto, _callback);
        return localVarCall;
    }

    public void restartProcessInstance(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        this.restartProcessInstanceWithHttpInfo(id, restartProcessInstanceDto);
    }

    public ApiResponse<Void> restartProcessInstanceWithHttpInfo(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        Call localVarCall = this.restartProcessInstanceValidateBeforeCall(id, restartProcessInstanceDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call restartProcessInstanceAsync(String id, RestartProcessInstanceDto restartProcessInstanceDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.restartProcessInstanceValidateBeforeCall(id, restartProcessInstanceDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call restartProcessInstanceAsyncOperationCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, ApiCallback _callback) throws ApiException {
        RestartProcessInstanceDto localVarPostBody = restartProcessInstanceDto;
        String localVarPath = "/process-definition/{id}/restart-async".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call restartProcessInstanceAsyncOperationValidateBeforeCall(String id, RestartProcessInstanceDto restartProcessInstanceDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling restartProcessInstanceAsyncOperation(Async)");
        }
        Call localVarCall = this.restartProcessInstanceAsyncOperationCall(id, restartProcessInstanceDto, _callback);
        return localVarCall;
    }

    public BatchDto restartProcessInstanceAsyncOperation(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.restartProcessInstanceAsyncOperationWithHttpInfo(id, restartProcessInstanceDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> restartProcessInstanceAsyncOperationWithHttpInfo(String id, RestartProcessInstanceDto restartProcessInstanceDto) throws ApiException {
        Call localVarCall = this.restartProcessInstanceAsyncOperationValidateBeforeCall(id, restartProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call restartProcessInstanceAsyncOperationAsync(String id, RestartProcessInstanceDto restartProcessInstanceDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.restartProcessInstanceAsyncOperationValidateBeforeCall(id, restartProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call startProcessInstanceCall(String id, StartProcessInstanceDto startProcessInstanceDto, ApiCallback _callback) throws ApiException {
        StartProcessInstanceDto localVarPostBody = startProcessInstanceDto;
        String localVarPath = "/process-definition/{id}/start".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call startProcessInstanceValidateBeforeCall(String id, StartProcessInstanceDto startProcessInstanceDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling startProcessInstance(Async)");
        }
        Call localVarCall = this.startProcessInstanceCall(id, startProcessInstanceDto, _callback);
        return localVarCall;
    }

    public ProcessInstanceWithVariablesDto startProcessInstance(String id, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        ApiResponse<ProcessInstanceWithVariablesDto> localVarResp = this.startProcessInstanceWithHttpInfo(id, startProcessInstanceDto);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessInstanceWithVariablesDto> startProcessInstanceWithHttpInfo(String id, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        Call localVarCall = this.startProcessInstanceValidateBeforeCall(id, startProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call startProcessInstanceAsync(String id, StartProcessInstanceDto startProcessInstanceDto, ApiCallback<ProcessInstanceWithVariablesDto> _callback) throws ApiException {
        Call localVarCall = this.startProcessInstanceValidateBeforeCall(id, startProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call startProcessInstanceByKeyCall(String key, StartProcessInstanceDto startProcessInstanceDto, ApiCallback _callback) throws ApiException {
        StartProcessInstanceDto localVarPostBody = startProcessInstanceDto;
        String localVarPath = "/process-definition/key/{key}/start".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call startProcessInstanceByKeyValidateBeforeCall(String key, StartProcessInstanceDto startProcessInstanceDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling startProcessInstanceByKey(Async)");
        }
        Call localVarCall = this.startProcessInstanceByKeyCall(key, startProcessInstanceDto, _callback);
        return localVarCall;
    }

    public ProcessInstanceWithVariablesDto startProcessInstanceByKey(String key, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        ApiResponse<ProcessInstanceWithVariablesDto> localVarResp = this.startProcessInstanceByKeyWithHttpInfo(key, startProcessInstanceDto);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessInstanceWithVariablesDto> startProcessInstanceByKeyWithHttpInfo(String key, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        Call localVarCall = this.startProcessInstanceByKeyValidateBeforeCall(key, startProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call startProcessInstanceByKeyAsync(String key, StartProcessInstanceDto startProcessInstanceDto, ApiCallback<ProcessInstanceWithVariablesDto> _callback) throws ApiException {
        Call localVarCall = this.startProcessInstanceByKeyValidateBeforeCall(key, startProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call startProcessInstanceByKeyAndTenantIdCall(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto, ApiCallback _callback) throws ApiException {
        StartProcessInstanceDto localVarPostBody = startProcessInstanceDto;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/start".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call startProcessInstanceByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling startProcessInstanceByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling startProcessInstanceByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.startProcessInstanceByKeyAndTenantIdCall(key, tenantId, startProcessInstanceDto, _callback);
        return localVarCall;
    }

    public ProcessInstanceWithVariablesDto startProcessInstanceByKeyAndTenantId(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        ApiResponse<ProcessInstanceWithVariablesDto> localVarResp = this.startProcessInstanceByKeyAndTenantIdWithHttpInfo(key, tenantId, startProcessInstanceDto);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessInstanceWithVariablesDto> startProcessInstanceByKeyAndTenantIdWithHttpInfo(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto) throws ApiException {
        Call localVarCall = this.startProcessInstanceByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call startProcessInstanceByKeyAndTenantIdAsync(String key, String tenantId, StartProcessInstanceDto startProcessInstanceDto, ApiCallback<ProcessInstanceWithVariablesDto> _callback) throws ApiException {
        Call localVarCall = this.startProcessInstanceByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceWithVariablesDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitFormCall(String id, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback _callback) throws ApiException {
        StartProcessInstanceFormDto localVarPostBody = startProcessInstanceFormDto;
        String localVarPath = "/process-definition/{id}/submit-form".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitFormValidateBeforeCall(String id, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling submitForm(Async)");
        }
        Call localVarCall = this.submitFormCall(id, startProcessInstanceFormDto, _callback);
        return localVarCall;
    }

    public ProcessInstanceDto submitForm(String id, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = this.submitFormWithHttpInfo(id, startProcessInstanceFormDto);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessInstanceDto> submitFormWithHttpInfo(String id, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        Call localVarCall = this.submitFormValidateBeforeCall(id, startProcessInstanceFormDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitFormAsync(String id, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback<ProcessInstanceDto> _callback) throws ApiException {
        Call localVarCall = this.submitFormValidateBeforeCall(id, startProcessInstanceFormDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitFormByKeyCall(String key, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback _callback) throws ApiException {
        StartProcessInstanceFormDto localVarPostBody = startProcessInstanceFormDto;
        String localVarPath = "/process-definition/key/{key}/submit-form".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitFormByKeyValidateBeforeCall(String key, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling submitFormByKey(Async)");
        }
        Call localVarCall = this.submitFormByKeyCall(key, startProcessInstanceFormDto, _callback);
        return localVarCall;
    }

    public ProcessInstanceDto submitFormByKey(String key, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = this.submitFormByKeyWithHttpInfo(key, startProcessInstanceFormDto);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessInstanceDto> submitFormByKeyWithHttpInfo(String key, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        Call localVarCall = this.submitFormByKeyValidateBeforeCall(key, startProcessInstanceFormDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitFormByKeyAsync(String key, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback<ProcessInstanceDto> _callback) throws ApiException {
        Call localVarCall = this.submitFormByKeyValidateBeforeCall(key, startProcessInstanceFormDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call submitFormByKeyAndTenantIdCall(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback _callback) throws ApiException {
        StartProcessInstanceFormDto localVarPostBody = startProcessInstanceFormDto;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/submit-form".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call submitFormByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling submitFormByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling submitFormByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.submitFormByKeyAndTenantIdCall(key, tenantId, startProcessInstanceFormDto, _callback);
        return localVarCall;
    }

    public ProcessInstanceDto submitFormByKeyAndTenantId(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = this.submitFormByKeyAndTenantIdWithHttpInfo(key, tenantId, startProcessInstanceFormDto);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessInstanceDto> submitFormByKeyAndTenantIdWithHttpInfo(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto) throws ApiException {
        Call localVarCall = this.submitFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceFormDto, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call submitFormByKeyAndTenantIdAsync(String key, String tenantId, StartProcessInstanceFormDto startProcessInstanceFormDto, ApiCallback<ProcessInstanceDto> _callback) throws ApiException {
        Call localVarCall = this.submitFormByKeyAndTenantIdValidateBeforeCall(key, tenantId, startProcessInstanceFormDto, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateHistoryTimeToLiveByProcessDefinitionIdCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        String localVarPath = "/process-definition/{id}/history-time-to-live".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateHistoryTimeToLiveByProcessDefinitionIdValidateBeforeCall(String id, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateHistoryTimeToLiveByProcessDefinitionId(Async)");
        }
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionIdCall(id, historyTimeToLiveDto, _callback);
        return localVarCall;
    }

    public void updateHistoryTimeToLiveByProcessDefinitionId(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByProcessDefinitionIdWithHttpInfo(id, historyTimeToLiveDto);
    }

    public ApiResponse<Void> updateHistoryTimeToLiveByProcessDefinitionIdWithHttpInfo(String id, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateHistoryTimeToLiveByProcessDefinitionIdAsync(String id, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionIdValidateBeforeCall(id, historyTimeToLiveDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateHistoryTimeToLiveByProcessDefinitionKeyCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        String localVarPath = "/process-definition/key/{key}/history-time-to-live".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateHistoryTimeToLiveByProcessDefinitionKeyValidateBeforeCall(String key, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByProcessDefinitionKey(Async)");
        }
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionKeyCall(key, historyTimeToLiveDto, _callback);
        return localVarCall;
    }

    public void updateHistoryTimeToLiveByProcessDefinitionKey(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByProcessDefinitionKeyWithHttpInfo(key, historyTimeToLiveDto);
    }

    public ApiResponse<Void> updateHistoryTimeToLiveByProcessDefinitionKeyWithHttpInfo(String key, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateHistoryTimeToLiveByProcessDefinitionKeyAsync(String key, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionKeyValidateBeforeCall(key, historyTimeToLiveDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        HistoryTimeToLiveDto localVarPostBody = historyTimeToLiveDto;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdValidateBeforeCall(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(Async)");
        }
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdCall(key, tenantId, historyTimeToLiveDto, _callback);
        return localVarCall;
    }

    public void updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantId(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        this.updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdWithHttpInfo(key, tenantId, historyTimeToLiveDto);
    }

    public ApiResponse<Void> updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdWithHttpInfo(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, historyTimeToLiveDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdAsync(String key, String tenantId, HistoryTimeToLiveDto historyTimeToLiveDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateHistoryTimeToLiveByProcessDefinitionKeyAndTenantIdValidateBeforeCall(key, tenantId, historyTimeToLiveDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateProcessDefinitionSuspensionStateCall(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        String localVarPath = "/process-definition/suspended";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProcessDefinitionSuspensionStateValidateBeforeCall(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateCall(processDefinitionSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateProcessDefinitionSuspensionState(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionStateWithHttpInfo(processDefinitionSuspensionStateDto);
    }

    public ApiResponse<Void> updateProcessDefinitionSuspensionStateWithHttpInfo(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateValidateBeforeCall(processDefinitionSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateProcessDefinitionSuspensionStateAsync(ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateValidateBeforeCall(processDefinitionSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateProcessDefinitionSuspensionStateByIdCall(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        String localVarPath = "/process-definition/{id}/suspended".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProcessDefinitionSuspensionStateByIdValidateBeforeCall(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateProcessDefinitionSuspensionStateById(Async)");
        }
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByIdCall(id, processDefinitionSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateProcessDefinitionSuspensionStateById(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionStateByIdWithHttpInfo(id, processDefinitionSuspensionStateDto);
    }

    public ApiResponse<Void> updateProcessDefinitionSuspensionStateByIdWithHttpInfo(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByIdValidateBeforeCall(id, processDefinitionSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateProcessDefinitionSuspensionStateByIdAsync(String id, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByIdValidateBeforeCall(id, processDefinitionSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateProcessDefinitionSuspensionStateByKeyCall(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        String localVarPath = "/process-definition/key/{key}/suspended".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProcessDefinitionSuspensionStateByKeyValidateBeforeCall(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateProcessDefinitionSuspensionStateByKey(Async)");
        }
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByKeyCall(key, processDefinitionSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateProcessDefinitionSuspensionStateByKey(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionStateByKeyWithHttpInfo(key, processDefinitionSuspensionStateDto);
    }

    public ApiResponse<Void> updateProcessDefinitionSuspensionStateByKeyWithHttpInfo(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByKeyValidateBeforeCall(key, processDefinitionSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateProcessDefinitionSuspensionStateByKeyAsync(String key, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByKeyValidateBeforeCall(key, processDefinitionSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateProcessDefinitionSuspensionStateByKeyAndTenantIdCall(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        ProcessDefinitionSuspensionStateDto localVarPostBody = processDefinitionSuspensionStateDto;
        String localVarPath = "/process-definition/key/{key}/tenant-id/{tenant-id}/suspended".replaceAll("\\{key\\}", this.localVarApiClient.escapeString(key.toString())).replaceAll("\\{tenant-id\\}", this.localVarApiClient.escapeString(tenantId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateProcessDefinitionSuspensionStateByKeyAndTenantIdValidateBeforeCall(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback _callback) throws ApiException {
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling updateProcessDefinitionSuspensionStateByKeyAndTenantId(Async)");
        }
        if (tenantId == null) {
            throw new ApiException("Missing the required parameter 'tenantId' when calling updateProcessDefinitionSuspensionStateByKeyAndTenantId(Async)");
        }
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByKeyAndTenantIdCall(key, tenantId, processDefinitionSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateProcessDefinitionSuspensionStateByKeyAndTenantId(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        this.updateProcessDefinitionSuspensionStateByKeyAndTenantIdWithHttpInfo(key, tenantId, processDefinitionSuspensionStateDto);
    }

    public ApiResponse<Void> updateProcessDefinitionSuspensionStateByKeyAndTenantIdWithHttpInfo(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByKeyAndTenantIdValidateBeforeCall(key, tenantId, processDefinitionSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateProcessDefinitionSuspensionStateByKeyAndTenantIdAsync(String key, String tenantId, ProcessDefinitionSuspensionStateDto processDefinitionSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateProcessDefinitionSuspensionStateByKeyAndTenantIdValidateBeforeCall(key, tenantId, processDefinitionSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

