/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class EventSubscriptionDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
    @SerializedName(value="eventType")
    private String eventType;
    public static final String SERIALIZED_NAME_EVENT_NAME = "eventName";
    @SerializedName(value="eventName")
    private String eventName;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_CREATED_DATE = "createdDate";
    @SerializedName(value="createdDate")
    private Date createdDate;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;

    public EventSubscriptionDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the event subscription.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EventSubscriptionDto eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the event subscription.")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public EventSubscriptionDto eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the event this subscription belongs to as defined in the process model.")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public EventSubscriptionDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The execution that is subscribed on the referenced event.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public EventSubscriptionDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance this subscription belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public EventSubscriptionDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public EventSubscriptionDto createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time this event subscription was created.")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public EventSubscriptionDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant this event subscription belongs to. Can be `null` if the subscription belongs to no single tenant.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSubscriptionDto eventSubscriptionDto = (EventSubscriptionDto)o;
        return Objects.equals(this.id, eventSubscriptionDto.id) && Objects.equals(this.eventType, eventSubscriptionDto.eventType) && Objects.equals(this.eventName, eventSubscriptionDto.eventName) && Objects.equals(this.executionId, eventSubscriptionDto.executionId) && Objects.equals(this.processInstanceId, eventSubscriptionDto.processInstanceId) && Objects.equals(this.activityId, eventSubscriptionDto.activityId) && Objects.equals(this.createdDate, eventSubscriptionDto.createdDate) && Objects.equals(this.tenantId, eventSubscriptionDto.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.eventType, this.eventName, this.executionId, this.processInstanceId, this.activityId, this.createdDate, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventSubscriptionDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

