/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ExternalTaskQueryDtoSorting;

@ApiModel(description="A JSON object with the following properties:")
public class ExternalTaskQueryDto {
    public static final String SERIALIZED_NAME_EXTERNAL_TASK_ID = "externalTaskId";
    @SerializedName(value="externalTaskId")
    private String externalTaskId;
    public static final String SERIALIZED_NAME_EXTERNAL_TASK_ID_IN = "externalTaskIdIn";
    @SerializedName(value="externalTaskIdIn")
    private List<String> externalTaskIdIn = null;
    public static final String SERIALIZED_NAME_TOPIC_NAME = "topicName";
    @SerializedName(value="topicName")
    private String topicName;
    public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
    @SerializedName(value="workerId")
    private String workerId;
    public static final String SERIALIZED_NAME_LOCKED = "locked";
    @SerializedName(value="locked")
    private Boolean locked;
    public static final String SERIALIZED_NAME_NOT_LOCKED = "notLocked";
    @SerializedName(value="notLocked")
    private Boolean notLocked;
    public static final String SERIALIZED_NAME_WITH_RETRIES_LEFT = "withRetriesLeft";
    @SerializedName(value="withRetriesLeft")
    private Boolean withRetriesLeft;
    public static final String SERIALIZED_NAME_NO_RETRIES_LEFT = "noRetriesLeft";
    @SerializedName(value="noRetriesLeft")
    private Boolean noRetriesLeft;
    public static final String SERIALIZED_NAME_LOCK_EXPIRATION_AFTER = "lockExpirationAfter";
    @SerializedName(value="lockExpirationAfter")
    private Date lockExpirationAfter;
    public static final String SERIALIZED_NAME_LOCK_EXPIRATION_BEFORE = "lockExpirationBefore";
    @SerializedName(value="lockExpirationBefore")
    private Date lockExpirationBefore;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
    @SerializedName(value="activityIdIn")
    private List<String> activityIdIn = null;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
    @SerializedName(value="processInstanceIdIn")
    private List<String> processInstanceIdIn = null;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_PRIORITY_HIGHER_THAN_OR_EQUALS = "priorityHigherThanOrEquals";
    @SerializedName(value="priorityHigherThanOrEquals")
    private Long priorityHigherThanOrEquals;
    public static final String SERIALIZED_NAME_PRIORITY_LOWER_THAN_OR_EQUALS = "priorityLowerThanOrEquals";
    @SerializedName(value="priorityLowerThanOrEquals")
    private Long priorityLowerThanOrEquals;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<ExternalTaskQueryDtoSorting> sorting = null;

    public ExternalTaskQueryDto externalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by an external task's id.")
    public String getExternalTaskId() {
        return this.externalTaskId;
    }

    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    public ExternalTaskQueryDto externalTaskIdIn(List<String> externalTaskIdIn) {
        this.externalTaskIdIn = externalTaskIdIn;
        return this;
    }

    public ExternalTaskQueryDto addExternalTaskIdInItem(String externalTaskIdInItem) {
        if (this.externalTaskIdIn == null) {
            this.externalTaskIdIn = new ArrayList<String>();
        }
        this.externalTaskIdIn.add(externalTaskIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the comma-separated list of external task ids.")
    public List<String> getExternalTaskIdIn() {
        return this.externalTaskIdIn;
    }

    public void setExternalTaskIdIn(List<String> externalTaskIdIn) {
        this.externalTaskIdIn = externalTaskIdIn;
    }

    public ExternalTaskQueryDto topicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by an external task topic.")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public ExternalTaskQueryDto workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the worker that the task was most recently locked by.")
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public ExternalTaskQueryDto locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include external tasks that are currently locked (i.e., they have a lock time and it has not expired). Value may only be `true`, as `false` matches any external task.")
    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public ExternalTaskQueryDto notLocked(Boolean notLocked) {
        this.notLocked = notLocked;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include external tasks that are currently not locked (i.e., they have no lock or it has expired). Value may only be `true`, as `false` matches any external task.")
    public Boolean getNotLocked() {
        return this.notLocked;
    }

    public void setNotLocked(Boolean notLocked) {
        this.notLocked = notLocked;
    }

    public ExternalTaskQueryDto withRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include external tasks that have a positive (&gt; 0) number of retries (or `null`). Value may only be `true`, as `false` matches any external task.")
    public Boolean getWithRetriesLeft() {
        return this.withRetriesLeft;
    }

    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    public ExternalTaskQueryDto noRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include external tasks that have 0 retries. Value may only be `true`, as `false` matches any external task.")
    public Boolean getNoRetriesLeft() {
        return this.noRetriesLeft;
    }

    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    public ExternalTaskQueryDto lockExpirationAfter(Date lockExpirationAfter) {
        this.lockExpirationAfter = lockExpirationAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to external tasks that have a lock that expires after a given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getLockExpirationAfter() {
        return this.lockExpirationAfter;
    }

    public void setLockExpirationAfter(Date lockExpirationAfter) {
        this.lockExpirationAfter = lockExpirationAfter;
    }

    public ExternalTaskQueryDto lockExpirationBefore(Date lockExpirationBefore) {
        this.lockExpirationBefore = lockExpirationBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to external tasks that have a lock that expires before a given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getLockExpirationBefore() {
        return this.lockExpirationBefore;
    }

    public void setLockExpirationBefore(Date lockExpirationBefore) {
        this.lockExpirationBefore = lockExpirationBefore;
    }

    public ExternalTaskQueryDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the activity that an external task is created for.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public ExternalTaskQueryDto activityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
        return this;
    }

    public ExternalTaskQueryDto addActivityIdInItem(String activityIdInItem) {
        if (this.activityIdIn == null) {
            this.activityIdIn = new ArrayList<String>();
        }
        this.activityIdIn.add(activityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the comma-separated list of ids of the activities that an external task is created for.")
    public List<String> getActivityIdIn() {
        return this.activityIdIn;
    }

    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public ExternalTaskQueryDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the execution that an external task belongs to.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public ExternalTaskQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the process instance that an external task belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ExternalTaskQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
        return this;
    }

    public ExternalTaskQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
        if (this.processInstanceIdIn == null) {
            this.processInstanceIdIn = new ArrayList<String>();
        }
        this.processInstanceIdIn.add(processInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a comma-separated list of process instance ids that an external task may belong to.")
    public List<String> getProcessInstanceIdIn() {
        return this.processInstanceIdIn;
    }

    public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    public ExternalTaskQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the process definition that an external task belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ExternalTaskQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public ExternalTaskQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a comma-separated list of tenant ids. An external task must have one of the given tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public ExternalTaskQueryDto active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include active tasks. Value may only be `true`, as `false` matches any external task.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ExternalTaskQueryDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include suspended tasks. Value may only be `true`, as `false` matches any external task.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public ExternalTaskQueryDto priorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include jobs with a priority higher than or equal to the given value. Value must be a valid `long` value.")
    public Long getPriorityHigherThanOrEquals() {
        return this.priorityHigherThanOrEquals;
    }

    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    public ExternalTaskQueryDto priorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include jobs with a priority lower than or equal to the given value. Value must be a valid `long` value.")
    public Long getPriorityLowerThanOrEquals() {
        return this.priorityLowerThanOrEquals;
    }

    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    public ExternalTaskQueryDto sorting(List<ExternalTaskQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public ExternalTaskQueryDto addSortingItem(ExternalTaskQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<ExternalTaskQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON array of criteria to sort the result by. Each element of the array is a JSON object that                     specifies one ordering. The position in the array identifies the rank of an ordering, i.e., whether                     it is primary, secondary, etc. The ordering objects have the following properties:                      **Note:** The `sorting` properties will not be applied to the External Task count query.")
    public List<ExternalTaskQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<ExternalTaskQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTaskQueryDto externalTaskQueryDto = (ExternalTaskQueryDto)o;
        return Objects.equals(this.externalTaskId, externalTaskQueryDto.externalTaskId) && Objects.equals(this.externalTaskIdIn, externalTaskQueryDto.externalTaskIdIn) && Objects.equals(this.topicName, externalTaskQueryDto.topicName) && Objects.equals(this.workerId, externalTaskQueryDto.workerId) && Objects.equals(this.locked, externalTaskQueryDto.locked) && Objects.equals(this.notLocked, externalTaskQueryDto.notLocked) && Objects.equals(this.withRetriesLeft, externalTaskQueryDto.withRetriesLeft) && Objects.equals(this.noRetriesLeft, externalTaskQueryDto.noRetriesLeft) && Objects.equals(this.lockExpirationAfter, externalTaskQueryDto.lockExpirationAfter) && Objects.equals(this.lockExpirationBefore, externalTaskQueryDto.lockExpirationBefore) && Objects.equals(this.activityId, externalTaskQueryDto.activityId) && Objects.equals(this.activityIdIn, externalTaskQueryDto.activityIdIn) && Objects.equals(this.executionId, externalTaskQueryDto.executionId) && Objects.equals(this.processInstanceId, externalTaskQueryDto.processInstanceId) && Objects.equals(this.processInstanceIdIn, externalTaskQueryDto.processInstanceIdIn) && Objects.equals(this.processDefinitionId, externalTaskQueryDto.processDefinitionId) && Objects.equals(this.tenantIdIn, externalTaskQueryDto.tenantIdIn) && Objects.equals(this.active, externalTaskQueryDto.active) && Objects.equals(this.suspended, externalTaskQueryDto.suspended) && Objects.equals(this.priorityHigherThanOrEquals, externalTaskQueryDto.priorityHigherThanOrEquals) && Objects.equals(this.priorityLowerThanOrEquals, externalTaskQueryDto.priorityLowerThanOrEquals) && Objects.equals(this.sorting, externalTaskQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.externalTaskId, this.externalTaskIdIn, this.topicName, this.workerId, this.locked, this.notLocked, this.withRetriesLeft, this.noRetriesLeft, this.lockExpirationAfter, this.lockExpirationBefore, this.activityId, this.activityIdIn, this.executionId, this.processInstanceId, this.processInstanceIdIn, this.processDefinitionId, this.tenantIdIn, this.active, this.suspended, this.priorityHigherThanOrEquals, this.priorityLowerThanOrEquals, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalTaskQueryDto {\n");
        sb.append("    externalTaskId: ").append(this.toIndentedString(this.externalTaskId)).append("\n");
        sb.append("    externalTaskIdIn: ").append(this.toIndentedString(this.externalTaskIdIn)).append("\n");
        sb.append("    topicName: ").append(this.toIndentedString(this.topicName)).append("\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    notLocked: ").append(this.toIndentedString(this.notLocked)).append("\n");
        sb.append("    withRetriesLeft: ").append(this.toIndentedString(this.withRetriesLeft)).append("\n");
        sb.append("    noRetriesLeft: ").append(this.toIndentedString(this.noRetriesLeft)).append("\n");
        sb.append("    lockExpirationAfter: ").append(this.toIndentedString(this.lockExpirationAfter)).append("\n");
        sb.append("    lockExpirationBefore: ").append(this.toIndentedString(this.lockExpirationBefore)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityIdIn: ").append(this.toIndentedString(this.activityIdIn)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processInstanceIdIn: ").append(this.toIndentedString(this.processInstanceIdIn)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    priorityHigherThanOrEquals: ").append(this.toIndentedString(this.priorityHigherThanOrEquals)).append("\n");
        sb.append("    priorityLowerThanOrEquals: ").append(this.toIndentedString(this.priorityLowerThanOrEquals)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

