/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricActivityInstanceQueryDtoSorting;

@ApiModel(description="A historic activity instance query which defines a group of historic activity instances")
public class HistoricActivityInstanceQueryDto {
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_NAME = "activityName";
    @SerializedName(value="activityName")
    private String activityName;
    public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activityType";
    @SerializedName(value="activityType")
    private String activityType;
    public static final String SERIALIZED_NAME_TASK_ASSIGNEE = "taskAssignee";
    @SerializedName(value="taskAssignee")
    private String taskAssignee;
    public static final String SERIALIZED_NAME_FINISHED = "finished";
    @SerializedName(value="finished")
    private Boolean finished;
    public static final String SERIALIZED_NAME_UNFINISHED = "unfinished";
    @SerializedName(value="unfinished")
    private Boolean unfinished;
    public static final String SERIALIZED_NAME_CANCELED = "canceled";
    @SerializedName(value="canceled")
    private Boolean canceled;
    public static final String SERIALIZED_NAME_COMPLETE_SCOPE = "completeScope";
    @SerializedName(value="completeScope")
    private Boolean completeScope;
    public static final String SERIALIZED_NAME_STARTED_BEFORE = "startedBefore";
    @SerializedName(value="startedBefore")
    private Date startedBefore;
    public static final String SERIALIZED_NAME_STARTED_AFTER = "startedAfter";
    @SerializedName(value="startedAfter")
    private Date startedAfter;
    public static final String SERIALIZED_NAME_FINISHED_BEFORE = "finishedBefore";
    @SerializedName(value="finishedBefore")
    private Date finishedBefore;
    public static final String SERIALIZED_NAME_FINISHED_AFTER = "finishedAfter";
    @SerializedName(value="finishedAfter")
    private Date finishedAfter;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricActivityInstanceQueryDtoSorting> sorting = null;

    public HistoricActivityInstanceQueryDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by activity instance id.")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public HistoricActivityInstanceQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process instance id.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricActivityInstanceQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by process definition id.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricActivityInstanceQueryDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the id of the execution that executed the activity instance.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricActivityInstanceQueryDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the activity id (according to BPMN 2.0 XML).")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public HistoricActivityInstanceQueryDto activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the activity name (according to BPMN 2.0 XML).")
    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public HistoricActivityInstanceQueryDto activityType(String activityType) {
        this.activityType = activityType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by activity type.")
    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public HistoricActivityInstanceQueryDto taskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include activity instances that are user tasks and assigned to a given user.")
    public String getTaskAssignee() {
        return this.taskAssignee;
    }

    public void setTaskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
    }

    public HistoricActivityInstanceQueryDto finished(Boolean finished) {
        this.finished = finished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include finished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.")
    public Boolean getFinished() {
        return this.finished;
    }

    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    public HistoricActivityInstanceQueryDto unfinished(Boolean unfinished) {
        this.unfinished = unfinished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include unfinished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.")
    public Boolean getUnfinished() {
        return this.unfinished;
    }

    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    public HistoricActivityInstanceQueryDto canceled(Boolean canceled) {
        this.canceled = canceled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include canceled activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.")
    public Boolean getCanceled() {
        return this.canceled;
    }

    public void setCanceled(Boolean canceled) {
        this.canceled = canceled;
    }

    public HistoricActivityInstanceQueryDto completeScope(Boolean completeScope) {
        this.completeScope = completeScope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include activity instances which completed a scope. Value may only be `true`, as `false` behaves the same as when the property is not set.")
    public Boolean getCompleteScope() {
        return this.completeScope;
    }

    public void setCompleteScope(Boolean completeScope) {
        this.completeScope = completeScope;
    }

    public HistoricActivityInstanceQueryDto startedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    public HistoricActivityInstanceQueryDto startedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    public HistoricActivityInstanceQueryDto finishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    public HistoricActivityInstanceQueryDto finishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.19/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    public HistoricActivityInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricActivityInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Must be a JSON array of Strings. An activity instance must have one of the given tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricActivityInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic activity instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricActivityInstanceQueryDto sorting(List<HistoricActivityInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricActivityInstanceQueryDto addSortingItem(HistoricActivityInstanceQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricActivityInstanceQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply sorting of the result")
    public List<HistoricActivityInstanceQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricActivityInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto = (HistoricActivityInstanceQueryDto)o;
        return Objects.equals(this.activityInstanceId, historicActivityInstanceQueryDto.activityInstanceId) && Objects.equals(this.processInstanceId, historicActivityInstanceQueryDto.processInstanceId) && Objects.equals(this.processDefinitionId, historicActivityInstanceQueryDto.processDefinitionId) && Objects.equals(this.executionId, historicActivityInstanceQueryDto.executionId) && Objects.equals(this.activityId, historicActivityInstanceQueryDto.activityId) && Objects.equals(this.activityName, historicActivityInstanceQueryDto.activityName) && Objects.equals(this.activityType, historicActivityInstanceQueryDto.activityType) && Objects.equals(this.taskAssignee, historicActivityInstanceQueryDto.taskAssignee) && Objects.equals(this.finished, historicActivityInstanceQueryDto.finished) && Objects.equals(this.unfinished, historicActivityInstanceQueryDto.unfinished) && Objects.equals(this.canceled, historicActivityInstanceQueryDto.canceled) && Objects.equals(this.completeScope, historicActivityInstanceQueryDto.completeScope) && Objects.equals(this.startedBefore, historicActivityInstanceQueryDto.startedBefore) && Objects.equals(this.startedAfter, historicActivityInstanceQueryDto.startedAfter) && Objects.equals(this.finishedBefore, historicActivityInstanceQueryDto.finishedBefore) && Objects.equals(this.finishedAfter, historicActivityInstanceQueryDto.finishedAfter) && Objects.equals(this.tenantIdIn, historicActivityInstanceQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicActivityInstanceQueryDto.withoutTenantId) && Objects.equals(this.sorting, historicActivityInstanceQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.activityInstanceId, this.processInstanceId, this.processDefinitionId, this.executionId, this.activityId, this.activityName, this.activityType, this.taskAssignee, this.finished, this.unfinished, this.canceled, this.completeScope, this.startedBefore, this.startedAfter, this.finishedBefore, this.finishedAfter, this.tenantIdIn, this.withoutTenantId, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricActivityInstanceQueryDto {\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityName: ").append(this.toIndentedString(this.activityName)).append("\n");
        sb.append("    activityType: ").append(this.toIndentedString(this.activityType)).append("\n");
        sb.append("    taskAssignee: ").append(this.toIndentedString(this.taskAssignee)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    unfinished: ").append(this.toIndentedString(this.unfinished)).append("\n");
        sb.append("    canceled: ").append(this.toIndentedString(this.canceled)).append("\n");
        sb.append("    completeScope: ").append(this.toIndentedString(this.completeScope)).append("\n");
        sb.append("    startedBefore: ").append(this.toIndentedString(this.startedBefore)).append("\n");
        sb.append("    startedAfter: ").append(this.toIndentedString(this.startedAfter)).append("\n");
        sb.append("    finishedBefore: ").append(this.toIndentedString(this.finishedBefore)).append("\n");
        sb.append("    finishedAfter: ").append(this.toIndentedString(this.finishedAfter)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

