/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricVariableInstanceQueryDtoSorting;

@ApiModel(description="A Historic Variable Instance instance query which defines a list of Historic Variable Instance instances")
public class HistoricVariableInstanceQueryDto {
    public static final String SERIALIZED_NAME_VARIABLE_NAME = "variableName";
    @SerializedName(value="variableName")
    private String variableName;
    public static final String SERIALIZED_NAME_VARIABLE_NAME_LIKE = "variableNameLike";
    @SerializedName(value="variableNameLike")
    private String variableNameLike;
    public static final String SERIALIZED_NAME_VARIABLE_VALUE = "variableValue";
    @SerializedName(value="variableValue")
    private Object variableValue;
    public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
    @SerializedName(value="variableNamesIgnoreCase")
    private Boolean variableNamesIgnoreCase;
    public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
    @SerializedName(value="variableValuesIgnoreCase")
    private Boolean variableValuesIgnoreCase;
    public static final String SERIALIZED_NAME_VARIABLE_TYPE_IN = "variableTypeIn";
    @SerializedName(value="variableTypeIn")
    private List<String> variableTypeIn = null;
    public static final String SERIALIZED_NAME_INCLUDE_DELETED = "includeDeleted";
    @SerializedName(value="includeDeleted")
    private Boolean includeDeleted;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID_IN = "processInstanceIdIn";
    @SerializedName(value="processInstanceIdIn")
    private List<String> processInstanceIdIn = null;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_EXECUTION_ID_IN = "executionIdIn";
    @SerializedName(value="executionIdIn")
    private List<String> executionIdIn = null;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_CASE_EXECUTION_ID_IN = "caseExecutionIdIn";
    @SerializedName(value="caseExecutionIdIn")
    private List<String> caseExecutionIdIn = null;
    public static final String SERIALIZED_NAME_CASE_ACTIVITY_ID_IN = "caseActivityIdIn";
    @SerializedName(value="caseActivityIdIn")
    private List<String> caseActivityIdIn = null;
    public static final String SERIALIZED_NAME_TASK_ID_IN = "taskIdIn";
    @SerializedName(value="taskIdIn")
    private List<String> taskIdIn = null;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
    @SerializedName(value="activityInstanceIdIn")
    private List<String> activityInstanceIdIn = null;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_VARIABLE_NAME_IN = "variableNameIn";
    @SerializedName(value="variableNameIn")
    private List<String> variableNameIn = null;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricVariableInstanceQueryDtoSorting> sorting = null;

    public HistoricVariableInstanceQueryDto variableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by variable name.")
    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public HistoricVariableInstanceQueryDto variableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to variables with a name like the parameter.")
    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public void setVariableNameLike(String variableNameLike) {
        this.variableNameLike = variableNameLike;
    }

    public HistoricVariableInstanceQueryDto variableValue(Object variableValue) {
        this.variableValue = variableValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by variable value. May be `String`, `Number` or `Boolean`.")
    public Object getVariableValue() {
        return this.variableValue;
    }

    public void setVariableValue(Object variableValue) {
        this.variableValue = variableValue;
    }

    public HistoricVariableInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match the variable name provided in `variableName` and `variableNameLike` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.")
    public Boolean getVariableNamesIgnoreCase() {
        return this.variableNamesIgnoreCase;
    }

    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    public HistoricVariableInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Match the variable value provided in `variableValue` case-insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.")
    public Boolean getVariableValuesIgnoreCase() {
        return this.variableValuesIgnoreCase;
    }

    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public HistoricVariableInstanceQueryDto variableTypeIn(List<String> variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addVariableTypeInItem(String variableTypeInItem) {
        if (this.variableTypeIn == null) {
            this.variableTypeIn = new ArrayList<String>();
        }
        this.variableTypeIn.add(variableTypeInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.19/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type 'serializable'.")
    public List<String> getVariableTypeIn() {
        return this.variableTypeIn;
    }

    public void setVariableTypeIn(List<String> variableTypeIn) {
        this.variableTypeIn = variableTypeIn;
    }

    public HistoricVariableInstanceQueryDto includeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include variables that has already been deleted during the execution.")
    public Boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public HistoricVariableInstanceQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the process instance the variable belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricVariableInstanceQueryDto processInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addProcessInstanceIdInItem(String processInstanceIdInItem) {
        if (this.processInstanceIdIn == null) {
            this.processInstanceIdIn = new ArrayList<String>();
        }
        this.processInstanceIdIn.add(processInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed  process instance ids.")
    public List<String> getProcessInstanceIdIn() {
        return this.processInstanceIdIn;
    }

    public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    public HistoricVariableInstanceQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the process definition the variable belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricVariableInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a key of the process definition the variable belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricVariableInstanceQueryDto executionIdIn(List<String> executionIdIn) {
        this.executionIdIn = executionIdIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addExecutionIdInItem(String executionIdInItem) {
        if (this.executionIdIn == null) {
            this.executionIdIn = new ArrayList<String>();
        }
        this.executionIdIn.add(executionIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed and  execution ids.")
    public List<String> getExecutionIdIn() {
        return this.executionIdIn;
    }

    public void setExecutionIdIn(List<String> executionIdIn) {
        this.executionIdIn = executionIdIn;
    }

    public HistoricVariableInstanceQueryDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the case instance the variable belongs to.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricVariableInstanceQueryDto caseExecutionIdIn(List<String> caseExecutionIdIn) {
        this.caseExecutionIdIn = caseExecutionIdIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addCaseExecutionIdInItem(String caseExecutionIdInItem) {
        if (this.caseExecutionIdIn == null) {
            this.caseExecutionIdIn = new ArrayList<String>();
        }
        this.caseExecutionIdIn.add(caseExecutionIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed and  case execution ids.")
    public List<String> getCaseExecutionIdIn() {
        return this.caseExecutionIdIn;
    }

    public void setCaseExecutionIdIn(List<String> caseExecutionIdIn) {
        this.caseExecutionIdIn = caseExecutionIdIn;
    }

    public HistoricVariableInstanceQueryDto caseActivityIdIn(List<String> caseActivityIdIn) {
        this.caseActivityIdIn = caseActivityIdIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addCaseActivityIdInItem(String caseActivityIdInItem) {
        if (this.caseActivityIdIn == null) {
            this.caseActivityIdIn = new ArrayList<String>();
        }
        this.caseActivityIdIn.add(caseActivityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed and  case activity ids.")
    public List<String> getCaseActivityIdIn() {
        return this.caseActivityIdIn;
    }

    public void setCaseActivityIdIn(List<String> caseActivityIdIn) {
        this.caseActivityIdIn = caseActivityIdIn;
    }

    public HistoricVariableInstanceQueryDto taskIdIn(List<String> taskIdIn) {
        this.taskIdIn = taskIdIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addTaskIdInItem(String taskIdInItem) {
        if (this.taskIdIn == null) {
            this.taskIdIn = new ArrayList<String>();
        }
        this.taskIdIn.add(taskIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed and  task ids.")
    public List<String> getTaskIdIn() {
        return this.taskIdIn;
    }

    public void setTaskIdIn(List<String> taskIdIn) {
        this.taskIdIn = taskIdIn;
    }

    public HistoricVariableInstanceQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
        if (this.activityInstanceIdIn == null) {
            this.activityInstanceIdIn = new ArrayList<String>();
        }
        this.activityInstanceIdIn.add(activityInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed and  activity instance ids.")
    public List<String> getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    public HistoricVariableInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed and comma- separated tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricVariableInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricVariableInstanceQueryDto variableNameIn(List<String> variableNameIn) {
        this.variableNameIn = variableNameIn;
        return this;
    }

    public HistoricVariableInstanceQueryDto addVariableNameInItem(String variableNameInItem) {
        if (this.variableNameIn == null) {
            this.variableNameIn = new ArrayList<String>();
        }
        this.variableNameIn.add(variableNameInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic variable instances which belong to one of the passed  variable names.")
    public List<String> getVariableNameIn() {
        return this.variableNameIn;
    }

    public void setVariableNameIn(List<String> variableNameIn) {
        this.variableNameIn = variableNameIn;
    }

    public HistoricVariableInstanceQueryDto sorting(List<HistoricVariableInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricVariableInstanceQueryDto addSortingItem(HistoricVariableInstanceQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricVariableInstanceQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                      an object that specifies one ordering. The position in the array                      identifies the rank of an ordering, i.e., whether it is primary, secondary,                      etc. Sorting has no effect for `count` endpoints")
    public List<HistoricVariableInstanceQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricVariableInstanceQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto = (HistoricVariableInstanceQueryDto)o;
        return Objects.equals(this.variableName, historicVariableInstanceQueryDto.variableName) && Objects.equals(this.variableNameLike, historicVariableInstanceQueryDto.variableNameLike) && Objects.equals(this.variableValue, historicVariableInstanceQueryDto.variableValue) && Objects.equals(this.variableNamesIgnoreCase, historicVariableInstanceQueryDto.variableNamesIgnoreCase) && Objects.equals(this.variableValuesIgnoreCase, historicVariableInstanceQueryDto.variableValuesIgnoreCase) && Objects.equals(this.variableTypeIn, historicVariableInstanceQueryDto.variableTypeIn) && Objects.equals(this.includeDeleted, historicVariableInstanceQueryDto.includeDeleted) && Objects.equals(this.processInstanceId, historicVariableInstanceQueryDto.processInstanceId) && Objects.equals(this.processInstanceIdIn, historicVariableInstanceQueryDto.processInstanceIdIn) && Objects.equals(this.processDefinitionId, historicVariableInstanceQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicVariableInstanceQueryDto.processDefinitionKey) && Objects.equals(this.executionIdIn, historicVariableInstanceQueryDto.executionIdIn) && Objects.equals(this.caseInstanceId, historicVariableInstanceQueryDto.caseInstanceId) && Objects.equals(this.caseExecutionIdIn, historicVariableInstanceQueryDto.caseExecutionIdIn) && Objects.equals(this.caseActivityIdIn, historicVariableInstanceQueryDto.caseActivityIdIn) && Objects.equals(this.taskIdIn, historicVariableInstanceQueryDto.taskIdIn) && Objects.equals(this.activityInstanceIdIn, historicVariableInstanceQueryDto.activityInstanceIdIn) && Objects.equals(this.tenantIdIn, historicVariableInstanceQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicVariableInstanceQueryDto.withoutTenantId) && Objects.equals(this.variableNameIn, historicVariableInstanceQueryDto.variableNameIn) && Objects.equals(this.sorting, historicVariableInstanceQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.variableName, this.variableNameLike, this.variableValue, this.variableNamesIgnoreCase, this.variableValuesIgnoreCase, this.variableTypeIn, this.includeDeleted, this.processInstanceId, this.processInstanceIdIn, this.processDefinitionId, this.processDefinitionKey, this.executionIdIn, this.caseInstanceId, this.caseExecutionIdIn, this.caseActivityIdIn, this.taskIdIn, this.activityInstanceIdIn, this.tenantIdIn, this.withoutTenantId, this.variableNameIn, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricVariableInstanceQueryDto {\n");
        sb.append("    variableName: ").append(this.toIndentedString(this.variableName)).append("\n");
        sb.append("    variableNameLike: ").append(this.toIndentedString(this.variableNameLike)).append("\n");
        sb.append("    variableValue: ").append(this.toIndentedString(this.variableValue)).append("\n");
        sb.append("    variableNamesIgnoreCase: ").append(this.toIndentedString(this.variableNamesIgnoreCase)).append("\n");
        sb.append("    variableValuesIgnoreCase: ").append(this.toIndentedString(this.variableValuesIgnoreCase)).append("\n");
        sb.append("    variableTypeIn: ").append(this.toIndentedString(this.variableTypeIn)).append("\n");
        sb.append("    includeDeleted: ").append(this.toIndentedString(this.includeDeleted)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processInstanceIdIn: ").append(this.toIndentedString(this.processInstanceIdIn)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    executionIdIn: ").append(this.toIndentedString(this.executionIdIn)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    caseExecutionIdIn: ").append(this.toIndentedString(this.caseExecutionIdIn)).append("\n");
        sb.append("    caseActivityIdIn: ").append(this.toIndentedString(this.caseActivityIdIn)).append("\n");
        sb.append("    taskIdIn: ").append(this.toIndentedString(this.taskIdIn)).append("\n");
        sb.append("    activityInstanceIdIn: ").append(this.toIndentedString(this.activityInstanceIdIn)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    variableNameIn: ").append(this.toIndentedString(this.variableNameIn)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

