/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ExecutionDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.VariableValueDto;

@ApiModel(description="The `processInstance` property only has a value if the resultType is set to `ProcessDefinition`. The processInstance with the properties as described in the [get single instance](https://docs.camunda.org/manual/7.19/reference/rest/process-instance/get/) method.  The `execution` property only has a value if the resultType is set to `Execution`. The execution with the properties as described in the [get single execution](https://docs.camunda.org/manual/7.19/reference/rest/execution/get/) method.")
public class MessageCorrelationResultWithVariableDto {
    public static final String SERIALIZED_NAME_RESULT_TYPE = "resultType";
    @SerializedName(value="resultType")
    private ResultTypeEnum resultType;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE = "processInstance";
    @SerializedName(value="processInstance")
    private ProcessInstanceDto processInstance = null;
    public static final String SERIALIZED_NAME_EXECUTION = "execution";
    @SerializedName(value="execution")
    private ExecutionDto execution;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;

    public MessageCorrelationResultWithVariableDto resultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the message was correlated to a message start event or an  intermediate message catching event. In the first case, the resultType is  `ProcessDefinition` and otherwise `Execution`.")
    public ResultTypeEnum getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultTypeEnum resultType) {
        this.resultType = resultType;
    }

    public MessageCorrelationResultWithVariableDto processInstance(ProcessInstanceDto processInstance) {
        this.processInstance = processInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessInstanceDto getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstanceDto processInstance) {
        this.processInstance = processInstance;
    }

    public MessageCorrelationResultWithVariableDto execution(ExecutionDto execution) {
        this.execution = execution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ExecutionDto getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionDto execution) {
        this.execution = execution;
    }

    public MessageCorrelationResultWithVariableDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public MessageCorrelationResultWithVariableDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This property is returned if the `variablesInResultEnabled` is set to `true`. Contains a list of the process variables. ")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageCorrelationResultWithVariableDto messageCorrelationResultWithVariableDto = (MessageCorrelationResultWithVariableDto)o;
        return Objects.equals((Object)this.resultType, (Object)messageCorrelationResultWithVariableDto.resultType) && Objects.equals(this.processInstance, messageCorrelationResultWithVariableDto.processInstance) && Objects.equals(this.execution, messageCorrelationResultWithVariableDto.execution) && Objects.equals(this.variables, messageCorrelationResultWithVariableDto.variables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resultType, this.processInstance, this.execution, this.variables});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageCorrelationResultWithVariableDto {\n");
        sb.append("    resultType: ").append(this.toIndentedString((Object)this.resultType)).append("\n");
        sb.append("    processInstance: ").append(this.toIndentedString(this.processInstance)).append("\n");
        sb.append("    execution: ").append(this.toIndentedString(this.execution)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultTypeEnum {
        EXECUTION("Execution"),
        PROCESSDEFINITION("ProcessDefinition");

        private String value;

        private ResultTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultTypeEnum fromValue(String value) {
            for (ResultTypeEnum b : ResultTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ResultTypeEnum> {
            public void write(JsonWriter jsonWriter, ResultTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResultTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultTypeEnum.fromValue(value);
            }
        }
    }
}

