/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.AuthorizationExceptionDto;
import org.camunda.community.rest.client.dto.EvaluationConditionDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConditionApi {
    private ApiClient localVarApiClient;

    public ConditionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ConditionApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for evaluateCondition
     * @param evaluationConditionDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> If both tenantId and withoutTenantId are supplied. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the user is not allowed to start the process instance of the process definition, which start condition was evaluated to &#x60;true&#x60;. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateConditionCall(EvaluationConditionDto evaluationConditionDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = evaluationConditionDto;

        // create path and map variables
        String localVarPath = "/condition";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call evaluateConditionValidateBeforeCall(EvaluationConditionDto evaluationConditionDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = evaluateConditionCall(evaluationConditionDto, _callback);
        return localVarCall;

    }

    /**
     * Evaluate
     * Triggers evaluation of conditions for conditional start event(s).  Internally this maps to the engines condition evaluation builder method ConditionEvaluationBuilder#evaluateStartConditions().  For more information see the [Conditional Start Events](https://docs.camunda.org/manual/7.20/reference/bpmn20/events/conditional-events/#conditional-start-event) section of the [BPMN 2.0 Implementation Reference](https://docs.camunda.org/manual/7.20/reference/bpmn20/).
     * @param evaluationConditionDto  (optional)
     * @return List&lt;ProcessInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> If both tenantId and withoutTenantId are supplied. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the user is not allowed to start the process instance of the process definition, which start condition was evaluated to &#x60;true&#x60;. </td><td>  -  </td></tr>
     </table>
     */
    public List<ProcessInstanceDto> evaluateCondition(EvaluationConditionDto evaluationConditionDto) throws ApiException {
        ApiResponse<List<ProcessInstanceDto>> localVarResp = evaluateConditionWithHttpInfo(evaluationConditionDto);
        return localVarResp.getData();
    }

    /**
     * Evaluate
     * Triggers evaluation of conditions for conditional start event(s).  Internally this maps to the engines condition evaluation builder method ConditionEvaluationBuilder#evaluateStartConditions().  For more information see the [Conditional Start Events](https://docs.camunda.org/manual/7.20/reference/bpmn20/events/conditional-events/#conditional-start-event) section of the [BPMN 2.0 Implementation Reference](https://docs.camunda.org/manual/7.20/reference/bpmn20/).
     * @param evaluationConditionDto  (optional)
     * @return ApiResponse&lt;List&lt;ProcessInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> If both tenantId and withoutTenantId are supplied. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the user is not allowed to start the process instance of the process definition, which start condition was evaluated to &#x60;true&#x60;. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ProcessInstanceDto>> evaluateConditionWithHttpInfo(EvaluationConditionDto evaluationConditionDto) throws ApiException {
        okhttp3.Call localVarCall = evaluateConditionValidateBeforeCall(evaluationConditionDto, null);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Evaluate (asynchronously)
     * Triggers evaluation of conditions for conditional start event(s).  Internally this maps to the engines condition evaluation builder method ConditionEvaluationBuilder#evaluateStartConditions().  For more information see the [Conditional Start Events](https://docs.camunda.org/manual/7.20/reference/bpmn20/events/conditional-events/#conditional-start-event) section of the [BPMN 2.0 Implementation Reference](https://docs.camunda.org/manual/7.20/reference/bpmn20/).
     * @param evaluationConditionDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> If both tenantId and withoutTenantId are supplied. </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> If the user is not allowed to start the process instance of the process definition, which start condition was evaluated to &#x60;true&#x60;. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call evaluateConditionAsync(EvaluationConditionDto evaluationConditionDto, final ApiCallback<List<ProcessInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = evaluateConditionValidateBeforeCall(evaluationConditionDto, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
