/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricExternalTaskLogDto;
import org.camunda.community.rest.client.dto.HistoricExternalTaskLogQueryDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricExternalTaskLogApi {
    private ApiClient localVarApiClient;

    public HistoricExternalTaskLogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricExternalTaskLogApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getErrorDetailsHistoricExternalTaskLog
     * @param id The id of the historic external task log to get the error details for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getErrorDetailsHistoricExternalTaskLogCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/external-task-log/{id}/error-details"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getErrorDetailsHistoricExternalTaskLogValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getErrorDetailsHistoricExternalTaskLog(Async)");
        }
        

        okhttp3.Call localVarCall = getErrorDetailsHistoricExternalTaskLogCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get External Task Log Error Details
     * Retrieves the corresponding error details of the passed historic external task log by id.
     * @param id The id of the historic external task log to get the error details for. (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public Object getErrorDetailsHistoricExternalTaskLog(String id) throws ApiException {
        ApiResponse<Object> localVarResp = getErrorDetailsHistoricExternalTaskLogWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get External Task Log Error Details
     * Retrieves the corresponding error details of the passed historic external task log by id.
     * @param id The id of the historic external task log to get the error details for. (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> getErrorDetailsHistoricExternalTaskLogWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getErrorDetailsHistoricExternalTaskLogValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get External Task Log Error Details (asynchronously)
     * Retrieves the corresponding error details of the passed historic external task log by id.
     * @param id The id of the historic external task log to get the error details for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getErrorDetailsHistoricExternalTaskLogAsync(String id, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = getErrorDetailsHistoricExternalTaskLogValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricExternalTaskLog
     * @param id The id of the log entry. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricExternalTaskLogCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/external-task-log/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricExternalTaskLogValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricExternalTaskLog(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricExternalTaskLogCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get External Task Log
     * Retrieves a historic external task log by id.
     * @param id The id of the log entry. (required)
     * @return HistoricExternalTaskLogDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public HistoricExternalTaskLogDto getHistoricExternalTaskLog(String id) throws ApiException {
        ApiResponse<HistoricExternalTaskLogDto> localVarResp = getHistoricExternalTaskLogWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get External Task Log
     * Retrieves a historic external task log by id.
     * @param id The id of the log entry. (required)
     * @return ApiResponse&lt;HistoricExternalTaskLogDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricExternalTaskLogDto> getHistoricExternalTaskLogWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getHistoricExternalTaskLogValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<HistoricExternalTaskLogDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get External Task Log (asynchronously)
     * Retrieves a historic external task log by id.
     * @param id The id of the log entry. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic external task log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricExternalTaskLogAsync(String id, final ApiCallback<HistoricExternalTaskLogDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricExternalTaskLogValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<HistoricExternalTaskLogDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricExternalTaskLogs
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricExternalTaskLogsCall(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/external-task-log";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (logId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logId", logId));
        }

        if (externalTaskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("externalTaskId", externalTaskId));
        }

        if (topicName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("topicName", topicName));
        }

        if (workerId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workerId", workerId));
        }

        if (errorMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("errorMessage", errorMessage));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }

        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }

        if (creationLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("creationLog", creationLog));
        }

        if (failureLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failureLog", failureLog));
        }

        if (successLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("successLog", successLog));
        }

        if (deletionLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deletionLog", deletionLog));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricExternalTaskLogsValidateBeforeCall(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricExternalTaskLogsCall(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get External Task Logs
     * Queries for historic external task logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get External Task Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;HistoricExternalTaskLogDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricExternalTaskLogDto> getHistoricExternalTaskLogs(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricExternalTaskLogDto>> localVarResp = getHistoricExternalTaskLogsWithHttpInfo(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get External Task Logs
     * Queries for historic external task logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get External Task Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;HistoricExternalTaskLogDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricExternalTaskLogDto>> getHistoricExternalTaskLogsWithHttpInfo(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getHistoricExternalTaskLogsValidateBeforeCall(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricExternalTaskLogDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get External Task Logs (asynchronously)
     * Queries for historic external task logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get External Task Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricExternalTaskLogsAsync(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<HistoricExternalTaskLogDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricExternalTaskLogsValidateBeforeCall(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricExternalTaskLogDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricExternalTaskLogsCount
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricExternalTaskLogsCountCall(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/external-task-log/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (logId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logId", logId));
        }

        if (externalTaskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("externalTaskId", externalTaskId));
        }

        if (topicName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("topicName", topicName));
        }

        if (workerId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("workerId", workerId));
        }

        if (errorMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("errorMessage", errorMessage));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }

        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }

        if (creationLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("creationLog", creationLog));
        }

        if (failureLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failureLog", failureLog));
        }

        if (successLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("successLog", successLog));
        }

        if (deletionLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deletionLog", deletionLog));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricExternalTaskLogsCountValidateBeforeCall(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricExternalTaskLogsCountCall(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, _callback);
        return localVarCall;

    }

    /**
     * Get External Task Log Count
     * Queries for the number of historic external task logs that fulfill the given parameters. Takes the same parameters as the [Get External Task Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query/) method.
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricExternalTaskLogsCount(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricExternalTaskLogsCountWithHttpInfo(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog);
        return localVarResp.getData();
    }

    /**
     * Get External Task Log Count
     * Queries for the number of historic external task logs that fulfill the given parameters. Takes the same parameters as the [Get External Task Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query/) method.
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricExternalTaskLogsCountWithHttpInfo(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog) throws ApiException {
        okhttp3.Call localVarCall = getHistoricExternalTaskLogsCountValidateBeforeCall(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get External Task Log Count (asynchronously)
     * Queries for the number of historic external task logs that fulfill the given parameters. Takes the same parameters as the [Get External Task Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query/) method.
     * @param logId Filter by historic external task log id. (optional)
     * @param externalTaskId Filter by external task id. (optional)
     * @param topicName Filter by an external task topic. (optional)
     * @param workerId Filter by the id of the worker that the task was most recently locked by. (optional)
     * @param errorMessage Filter by external task exception message. (optional)
     * @param activityIdIn Only include historic external task logs which belong to one of the passed activity ids. (optional)
     * @param activityInstanceIdIn Only include historic external task logs which belong to one of the passed activity instance ids. (optional)
     * @param executionIdIn Only include historic external task logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param tenantIdIn Only include historic external task log entries which belong to one of the passed and comma-separated tenant ids. (optional)
     * @param withoutTenantId Only include historic external task log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param priorityLowerThanOrEquals Only include logs for which the associated external task had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param priorityHigherThanOrEquals Only include logs for which the associated external task had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricExternalTaskLogsCountAsync(String logId, String externalTaskId, String topicName, String workerId, String errorMessage, String activityIdIn, String activityInstanceIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String tenantIdIn, Boolean withoutTenantId, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricExternalTaskLogsCountValidateBeforeCall(logId, externalTaskId, topicName, workerId, errorMessage, activityIdIn, activityInstanceIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, tenantIdIn, withoutTenantId, priorityLowerThanOrEquals, priorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricExternalTaskLogs
     * @param historicExternalTaskLogQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricExternalTaskLogsCall(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicExternalTaskLogQueryDto;

        // create path and map variables
        String localVarPath = "/history/external-task-log";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricExternalTaskLogsValidateBeforeCall(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricExternalTaskLogsCall(historicExternalTaskLogQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get External Task Logs (POST)
     * Queries for historic external task logs that fulfill the given parameters. This method is slightly more powerful than the [Get External Task Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query/) method because it allows filtering by historic external task logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param historicExternalTaskLogQueryDto  (optional)
     * @return List&lt;HistoricExternalTaskLogDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricExternalTaskLogDto> queryHistoricExternalTaskLogs(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto) throws ApiException {
        ApiResponse<List<HistoricExternalTaskLogDto>> localVarResp = queryHistoricExternalTaskLogsWithHttpInfo(historicExternalTaskLogQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get External Task Logs (POST)
     * Queries for historic external task logs that fulfill the given parameters. This method is slightly more powerful than the [Get External Task Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query/) method because it allows filtering by historic external task logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param historicExternalTaskLogQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;HistoricExternalTaskLogDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricExternalTaskLogDto>> queryHistoricExternalTaskLogsWithHttpInfo(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricExternalTaskLogsValidateBeforeCall(historicExternalTaskLogQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricExternalTaskLogDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get External Task Logs (POST) (asynchronously)
     * Queries for historic external task logs that fulfill the given parameters. This method is slightly more powerful than the [Get External Task Logs](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query/) method because it allows filtering by historic external task logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param historicExternalTaskLogQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricExternalTaskLogsAsync(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, final ApiCallback<List<HistoricExternalTaskLogDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricExternalTaskLogsValidateBeforeCall(historicExternalTaskLogQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricExternalTaskLogDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricExternalTaskLogsCount
     * @param historicExternalTaskLogQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricExternalTaskLogsCountCall(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicExternalTaskLogQueryDto;

        // create path and map variables
        String localVarPath = "/history/external-task-log/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricExternalTaskLogsCountValidateBeforeCall(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricExternalTaskLogsCountCall(historicExternalTaskLogQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get External Task Log Count (POST)
     * Queries for the number of historic external task logs that fulfill the given parameters. This method takes the same message body as the [Get External Task Logs (POST)](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/post-external-task-log-query/) method and therefore it is slightly more powerful than the [Get External Task Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
     * @param historicExternalTaskLogQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryHistoricExternalTaskLogsCount(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryHistoricExternalTaskLogsCountWithHttpInfo(historicExternalTaskLogQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get External Task Log Count (POST)
     * Queries for the number of historic external task logs that fulfill the given parameters. This method takes the same message body as the [Get External Task Logs (POST)](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/post-external-task-log-query/) method and therefore it is slightly more powerful than the [Get External Task Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
     * @param historicExternalTaskLogQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryHistoricExternalTaskLogsCountWithHttpInfo(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricExternalTaskLogsCountValidateBeforeCall(historicExternalTaskLogQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get External Task Log Count (POST) (asynchronously)
     * Queries for the number of historic external task logs that fulfill the given parameters. This method takes the same message body as the [Get External Task Logs (POST)](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/post-external-task-log-query/) method and therefore it is slightly more powerful than the [Get External Task Log Count](https://docs.camunda.org/manual/7.20/reference/rest/history/external-task-log/get-external-task-log-query-count/) method.
     * @param historicExternalTaskLogQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricExternalTaskLogsCountAsync(HistoricExternalTaskLogQueryDto historicExternalTaskLogQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricExternalTaskLogsCountValidateBeforeCall(historicExternalTaskLogQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
