/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.AnnotationDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.IncidentDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncidentApi {
    private ApiClient localVarApiClient;

    public IncidentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for clearIncidentAnnotation
     * @param id The id of the incident to clear the annotation at. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call clearIncidentAnnotationCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/incident/{id}/annotation"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call clearIncidentAnnotationValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling clearIncidentAnnotation(Async)");
        }
        

        okhttp3.Call localVarCall = clearIncidentAnnotationCall(id, _callback);
        return localVarCall;

    }

    /**
     * Clear Incident Annotation
     * Clears the annotation of an incident with given id.
     * @param id The id of the incident to clear the annotation at. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public void clearIncidentAnnotation(String id) throws ApiException {
        clearIncidentAnnotationWithHttpInfo(id);
    }

    /**
     * Clear Incident Annotation
     * Clears the annotation of an incident with given id.
     * @param id The id of the incident to clear the annotation at. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> clearIncidentAnnotationWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = clearIncidentAnnotationValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Clear Incident Annotation (asynchronously)
     * Clears the annotation of an incident with given id.
     * @param id The id of the incident to clear the annotation at. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call clearIncidentAnnotationAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = clearIncidentAnnotationValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getIncident
     * @param id The id of the incident to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIncidentCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/incident/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getIncidentValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getIncident(Async)");
        }
        

        okhttp3.Call localVarCall = getIncidentCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Incident
     * Retrieves an incident by ID.
     * @param id The id of the incident to be retrieved. (required)
     * @return IncidentDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public IncidentDto getIncident(String id) throws ApiException {
        ApiResponse<IncidentDto> localVarResp = getIncidentWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Incident
     * Retrieves an incident by ID.
     * @param id The id of the incident to be retrieved. (required)
     * @return ApiResponse&lt;IncidentDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<IncidentDto> getIncidentWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getIncidentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<IncidentDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Incident (asynchronously)
     * Retrieves an incident by ID.
     * @param id The id of the incident to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIncidentAsync(String id, final ApiCallback<IncidentDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getIncidentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<IncidentDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getIncidents
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIncidentsCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/incident";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (incidentTimestampBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
        }

        if (incidentTimestampAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (failedActivityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }

        if (causeIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("causeIncidentId", causeIncidentId));
        }

        if (rootCauseIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        }

        if (_configuration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("configuration", _configuration));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (jobDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getIncidentsValidateBeforeCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getIncidentsCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get List
     * Queries for incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.20/reference/rest/incident/get-query-count/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;IncidentDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<IncidentDto> getIncidents(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<IncidentDto>> localVarResp = getIncidentsWithHttpInfo(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get List
     * Queries for incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.20/reference/rest/incident/get-query-count/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;IncidentDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<IncidentDto>> getIncidentsWithHttpInfo(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getIncidentsValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<IncidentDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (asynchronously)
     * Queries for incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.20/reference/rest/incident/get-query-count/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIncidentsAsync(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<IncidentDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getIncidentsValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<IncidentDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getIncidentsCount
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIncidentsCountCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/incident/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (incidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentId", incidentId));
        }

        if (incidentType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentType", incidentType));
        }

        if (incidentMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }

        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (incidentTimestampBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentTimestampBefore", incidentTimestampBefore));
        }

        if (incidentTimestampAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("incidentTimestampAfter", incidentTimestampAfter));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (failedActivityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }

        if (causeIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("causeIncidentId", causeIncidentId));
        }

        if (rootCauseIncidentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rootCauseIncidentId", rootCauseIncidentId));
        }

        if (_configuration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("configuration", _configuration));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (jobDefinitionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionIdIn", jobDefinitionIdIn));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getIncidentsCountValidateBeforeCall(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getIncidentsCountCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, _callback);
        return localVarCall;

    }

    /**
     * Get List Count
     * Queries for the number of incidents that fulfill given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.20/reference/rest/incident/get-query/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getIncidentsCount(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getIncidentsCountWithHttpInfo(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn);
        return localVarResp.getData();
    }

    /**
     * Get List Count
     * Queries for the number of incidents that fulfill given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.20/reference/rest/incident/get-query/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getIncidentsCountWithHttpInfo(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn) throws ApiException {
        okhttp3.Call localVarCall = getIncidentsCountValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (asynchronously)
     * Queries for the number of incidents that fulfill given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.20/reference/rest/incident/get-query/) method.
     * @param incidentId Restricts to incidents that have the given id. (optional)
     * @param incidentType Restricts to incidents that belong to the given incident type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) for a list of incident types. (optional)
     * @param incidentMessage Restricts to incidents that have the given incident message. (optional)
     * @param incidentMessageLike Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character &#39;%&#39; to express like-strategy: starts with (&#x60;string%&#x60;), ends with (&#x60;%string&#x60;) or contains (&#x60;%string%&#x60;). (optional)
     * @param processDefinitionId Restricts to incidents that belong to a process definition with the given id. (optional)
     * @param processDefinitionKeyIn Restricts to incidents that belong to a process definition with the given keys. Must be a comma-separated list. (optional)
     * @param processInstanceId Restricts to incidents that belong to a process instance with the given id. (optional)
     * @param executionId Restricts to incidents that belong to an execution with the given id. (optional)
     * @param incidentTimestampBefore Restricts to incidents that have an incidentTimestamp date before the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param incidentTimestampAfter Restricts to incidents that have an incidentTimestamp date after the given date.  By [default](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param activityId Restricts to incidents that belong to an activity with the given id. (optional)
     * @param failedActivityId Restricts to incidents that were created due to the failure of an activity with the given id. (optional)
     * @param causeIncidentId Restricts to incidents that have the given incident id as cause incident. (optional)
     * @param rootCauseIncidentId Restricts to incidents that have the given incident id as root cause incident. (optional)
     * @param _configuration Restricts to incidents that have the given parameter set as configuration. (optional)
     * @param tenantIdIn Restricts to incidents that have one of the given comma-separated tenant ids. (optional)
     * @param jobDefinitionIdIn Restricts to incidents that have one of the given comma-separated job definition ids. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.20/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIncidentsCountAsync(String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String processDefinitionId, String processDefinitionKeyIn, String processInstanceId, String executionId, Date incidentTimestampBefore, Date incidentTimestampAfter, String activityId, String failedActivityId, String causeIncidentId, String rootCauseIncidentId, String _configuration, String tenantIdIn, String jobDefinitionIdIn, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getIncidentsCountValidateBeforeCall(incidentId, incidentType, incidentMessage, incidentMessageLike, processDefinitionId, processDefinitionKeyIn, processInstanceId, executionId, incidentTimestampBefore, incidentTimestampAfter, activityId, failedActivityId, causeIncidentId, rootCauseIncidentId, _configuration, tenantIdIn, jobDefinitionIdIn, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for resolveIncident
     * @param id The id of the incident to be resolved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if an incident is not related to any execution or an incident is of type &#x60;failedJob&#x60; or &#x60;failedExternalTask&#x60;. To resolve such an incident, please refer to the [Incident Types](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) section. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call resolveIncidentCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/incident/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call resolveIncidentValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling resolveIncident(Async)");
        }
        

        okhttp3.Call localVarCall = resolveIncidentCall(id, _callback);
        return localVarCall;

    }

    /**
     * Resolve Incident
     * Resolves an incident with given id.
     * @param id The id of the incident to be resolved. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if an incident is not related to any execution or an incident is of type &#x60;failedJob&#x60; or &#x60;failedExternalTask&#x60;. To resolve such an incident, please refer to the [Incident Types](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) section. </td><td>  -  </td></tr>
     </table>
     */
    public void resolveIncident(String id) throws ApiException {
        resolveIncidentWithHttpInfo(id);
    }

    /**
     * Resolve Incident
     * Resolves an incident with given id.
     * @param id The id of the incident to be resolved. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if an incident is not related to any execution or an incident is of type &#x60;failedJob&#x60; or &#x60;failedExternalTask&#x60;. To resolve such an incident, please refer to the [Incident Types](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) section. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> resolveIncidentWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = resolveIncidentValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Resolve Incident (asynchronously)
     * Resolves an incident with given id.
     * @param id The id of the incident to be resolved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Returned if an incident with given id does not exist. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if an incident is not related to any execution or an incident is of type &#x60;failedJob&#x60; or &#x60;failedExternalTask&#x60;. To resolve such an incident, please refer to the [Incident Types](https://docs.camunda.org/manual/7.20/user-guide/process-engine/incidents/#incident-types) section. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call resolveIncidentAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = resolveIncidentValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for setIncidentAnnotation
     * @param id The id of the incident to clear the annotation at. (required)
     * @param annotationDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setIncidentAnnotationCall(String id, AnnotationDto annotationDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = annotationDto;

        // create path and map variables
        String localVarPath = "/incident/{id}/annotation"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "basicAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setIncidentAnnotationValidateBeforeCall(String id, AnnotationDto annotationDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setIncidentAnnotation(Async)");
        }
        

        okhttp3.Call localVarCall = setIncidentAnnotationCall(id, annotationDto, _callback);
        return localVarCall;

    }

    /**
     * Set Incident Annotation
     * Sets the annotation of an incident with given id.
     * @param id The id of the incident to clear the annotation at. (required)
     * @param annotationDto  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public void setIncidentAnnotation(String id, AnnotationDto annotationDto) throws ApiException {
        setIncidentAnnotationWithHttpInfo(id, annotationDto);
    }

    /**
     * Set Incident Annotation
     * Sets the annotation of an incident with given id.
     * @param id The id of the incident to clear the annotation at. (required)
     * @param annotationDto  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> setIncidentAnnotationWithHttpInfo(String id, AnnotationDto annotationDto) throws ApiException {
        okhttp3.Call localVarCall = setIncidentAnnotationValidateBeforeCall(id, annotationDto, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Set Incident Annotation (asynchronously)
     * Sets the annotation of an incident with given id.
     * @param id The id of the incident to clear the annotation at. (required)
     * @param annotationDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if no incident can be found for the given id. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setIncidentAnnotationAsync(String id, AnnotationDto annotationDto, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = setIncidentAnnotationValidateBeforeCall(id, annotationDto, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
