/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.camunda.community.rest.client.dto.EventSubscriptionQueryDtoSorting;

/**
 * A event subscription query which retrieves a list of event subscriptions
 */
@ApiModel(description = "A event subscription query which retrieves a list of event subscriptions")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class EventSubscriptionQueryDto {
  public static final String SERIALIZED_NAME_EVENT_SUBSCRIPTION_ID = "eventSubscriptionId";
  @SerializedName(SERIALIZED_NAME_EVENT_SUBSCRIPTION_ID)
  private String eventSubscriptionId;

  public static final String SERIALIZED_NAME_EVENT_NAME = "eventName";
  @SerializedName(SERIALIZED_NAME_EVENT_NAME)
  private String eventName;

  /**
   * The type of the event subscription.
   */
  @JsonAdapter(EventTypeEnum.Adapter.class)
  public enum EventTypeEnum {
    MESSAGE("message"),
    
    SIGNAL("signal"),
    
    COMPENSATE("compensate"),
    
    CONDITIONAL("conditional");

    private String value;

    EventTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EventTypeEnum fromValue(String value) {
      for (EventTypeEnum b : EventTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<EventTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EventTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EventTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return EventTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
  @SerializedName(SERIALIZED_NAME_EVENT_TYPE)
  private EventTypeEnum eventType;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_INCLUDE_EVENT_SUBSCRIPTIONS_WITHOUT_TENANT_ID = "includeEventSubscriptionsWithoutTenantId";
  @SerializedName(SERIALIZED_NAME_INCLUDE_EVENT_SUBSCRIPTIONS_WITHOUT_TENANT_ID)
  private Boolean includeEventSubscriptionsWithoutTenantId;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<EventSubscriptionQueryDtoSorting> sorting = null;


  public EventSubscriptionQueryDto eventSubscriptionId(String eventSubscriptionId) {
    
    this.eventSubscriptionId = eventSubscriptionId;
    return this;
  }

   /**
   * The id of the event subscription.
   * @return eventSubscriptionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the event subscription.")

  public String getEventSubscriptionId() {
    return eventSubscriptionId;
  }


  public void setEventSubscriptionId(String eventSubscriptionId) {
    this.eventSubscriptionId = eventSubscriptionId;
  }


  public EventSubscriptionQueryDto eventName(String eventName) {
    
    this.eventName = eventName;
    return this;
  }

   /**
   * The name of the event this subscription belongs to as defined in the process model.
   * @return eventName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the event this subscription belongs to as defined in the process model.")

  public String getEventName() {
    return eventName;
  }


  public void setEventName(String eventName) {
    this.eventName = eventName;
  }


  public EventSubscriptionQueryDto eventType(EventTypeEnum eventType) {
    
    this.eventType = eventType;
    return this;
  }

   /**
   * The type of the event subscription.
   * @return eventType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the event subscription.")

  public EventTypeEnum getEventType() {
    return eventType;
  }


  public void setEventType(EventTypeEnum eventType) {
    this.eventType = eventType;
  }


  public EventSubscriptionQueryDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * The execution that is subscribed on the referenced event.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution that is subscribed on the referenced event.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public EventSubscriptionQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * The process instance this subscription belongs to.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The process instance this subscription belongs to.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public EventSubscriptionQueryDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the activity that this event subscription belongs to. This could for example be the id of a receive task.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public EventSubscriptionQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public EventSubscriptionQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a comma-separated list of tenant ids. Only select subscriptions that belong to one of the given tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public EventSubscriptionQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only select subscriptions which have no tenant id. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only select subscriptions which have no tenant id. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public EventSubscriptionQueryDto includeEventSubscriptionsWithoutTenantId(Boolean includeEventSubscriptionsWithoutTenantId) {
    
    this.includeEventSubscriptionsWithoutTenantId = includeEventSubscriptionsWithoutTenantId;
    return this;
  }

   /**
   * Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return includeEventSubscriptionsWithoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Select event subscriptions which have no tenant id. Can be used in combination with tenantIdIn parameter. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getIncludeEventSubscriptionsWithoutTenantId() {
    return includeEventSubscriptionsWithoutTenantId;
  }


  public void setIncludeEventSubscriptionsWithoutTenantId(Boolean includeEventSubscriptionsWithoutTenantId) {
    this.includeEventSubscriptionsWithoutTenantId = includeEventSubscriptionsWithoutTenantId;
  }


  public EventSubscriptionQueryDto sorting(List<EventSubscriptionQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public EventSubscriptionQueryDto addSortingItem(EventSubscriptionQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<EventSubscriptionQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Apply sorting of the result")

  public List<EventSubscriptionQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<EventSubscriptionQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EventSubscriptionQueryDto eventSubscriptionQueryDto = (EventSubscriptionQueryDto) o;
    return Objects.equals(this.eventSubscriptionId, eventSubscriptionQueryDto.eventSubscriptionId) &&
        Objects.equals(this.eventName, eventSubscriptionQueryDto.eventName) &&
        Objects.equals(this.eventType, eventSubscriptionQueryDto.eventType) &&
        Objects.equals(this.executionId, eventSubscriptionQueryDto.executionId) &&
        Objects.equals(this.processInstanceId, eventSubscriptionQueryDto.processInstanceId) &&
        Objects.equals(this.activityId, eventSubscriptionQueryDto.activityId) &&
        Objects.equals(this.tenantIdIn, eventSubscriptionQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, eventSubscriptionQueryDto.withoutTenantId) &&
        Objects.equals(this.includeEventSubscriptionsWithoutTenantId, eventSubscriptionQueryDto.includeEventSubscriptionsWithoutTenantId) &&
        Objects.equals(this.sorting, eventSubscriptionQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventSubscriptionId, eventName, eventType, executionId, processInstanceId, activityId, tenantIdIn, withoutTenantId, includeEventSubscriptionsWithoutTenantId, sorting);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EventSubscriptionQueryDto {\n");
    sb.append("    eventSubscriptionId: ").append(toIndentedString(eventSubscriptionId)).append("\n");
    sb.append("    eventName: ").append(toIndentedString(eventName)).append("\n");
    sb.append("    eventType: ").append(toIndentedString(eventType)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    includeEventSubscriptionsWithoutTenantId: ").append(toIndentedString(includeEventSubscriptionsWithoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

