/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * JobDefinitionDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class JobDefinitionDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_JOB_TYPE = "jobType";
  @SerializedName(SERIALIZED_NAME_JOB_TYPE)
  private String jobType;

  public static final String SERIALIZED_NAME_JOB_CONFIGURATION = "jobConfiguration";
  @SerializedName(SERIALIZED_NAME_JOB_CONFIGURATION)
  private String jobConfiguration;

  public static final String SERIALIZED_NAME_OVERRIDING_JOB_PRIORITY = "overridingJobPriority";
  @SerializedName(SERIALIZED_NAME_OVERRIDING_JOB_PRIORITY)
  private Long overridingJobPriority;

  public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
  @SerializedName(SERIALIZED_NAME_SUSPENDED)
  private Boolean suspended;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
  @SerializedName(SERIALIZED_NAME_DEPLOYMENT_ID)
  private String deploymentId;


  public JobDefinitionDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the job definition.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the job definition.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public JobDefinitionDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * The id of the process definition this job definition is associated with.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process definition this job definition is associated with.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public JobDefinitionDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * The key of the process definition this job definition is associated with.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The key of the process definition this job definition is associated with.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public JobDefinitionDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * The id of the activity this job definition is associated with.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the activity this job definition is associated with.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public JobDefinitionDto jobType(String jobType) {
    
    this.jobType = jobType;
    return this;
  }

   /**
   * The type of the job which is running for this job definition. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.
   * @return jobType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the job which is running for this job definition. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/the-job-executor/#job-creation) for more information about job types.")

  public String getJobType() {
    return jobType;
  }


  public void setJobType(String jobType) {
    this.jobType = jobType;
  }


  public JobDefinitionDto jobConfiguration(String jobConfiguration) {
    
    this.jobConfiguration = jobConfiguration;
    return this;
  }

   /**
   * The configuration of a job definition provides details about the jobs which will be created. For example: for timer jobs it is the timer configuration.
   * @return jobConfiguration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The configuration of a job definition provides details about the jobs which will be created. For example: for timer jobs it is the timer configuration.")

  public String getJobConfiguration() {
    return jobConfiguration;
  }


  public void setJobConfiguration(String jobConfiguration) {
    this.jobConfiguration = jobConfiguration;
  }


  public JobDefinitionDto overridingJobPriority(Long overridingJobPriority) {
    
    this.overridingJobPriority = overridingJobPriority;
    return this;
  }

   /**
   * The execution priority defined for jobs that are created based on this definition. May be &#x60;null&#x60; when the priority has not been overridden on the job definition level.
   * @return overridingJobPriority
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution priority defined for jobs that are created based on this definition. May be `null` when the priority has not been overridden on the job definition level.")

  public Long getOverridingJobPriority() {
    return overridingJobPriority;
  }


  public void setOverridingJobPriority(Long overridingJobPriority) {
    this.overridingJobPriority = overridingJobPriority;
  }


  public JobDefinitionDto suspended(Boolean suspended) {
    
    this.suspended = suspended;
    return this;
  }

   /**
   * Indicates whether this job definition is suspended or not.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Indicates whether this job definition is suspended or not.")

  public Boolean getSuspended() {
    return suspended;
  }


  public void setSuspended(Boolean suspended) {
    this.suspended = suspended;
  }


  public JobDefinitionDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The id of the tenant this job definition is associated with.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the tenant this job definition is associated with.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public JobDefinitionDto deploymentId(String deploymentId) {
    
    this.deploymentId = deploymentId;
    return this;
  }

   /**
   * The id of the deployment this job definition is related to. In a deployment-aware setup, this leads to all jobs of the same definition being executed on the same node.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the deployment this job definition is related to. In a deployment-aware setup, this leads to all jobs of the same definition being executed on the same node.")

  public String getDeploymentId() {
    return deploymentId;
  }


  public void setDeploymentId(String deploymentId) {
    this.deploymentId = deploymentId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobDefinitionDto jobDefinitionDto = (JobDefinitionDto) o;
    return Objects.equals(this.id, jobDefinitionDto.id) &&
        Objects.equals(this.processDefinitionId, jobDefinitionDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, jobDefinitionDto.processDefinitionKey) &&
        Objects.equals(this.activityId, jobDefinitionDto.activityId) &&
        Objects.equals(this.jobType, jobDefinitionDto.jobType) &&
        Objects.equals(this.jobConfiguration, jobDefinitionDto.jobConfiguration) &&
        Objects.equals(this.overridingJobPriority, jobDefinitionDto.overridingJobPriority) &&
        Objects.equals(this.suspended, jobDefinitionDto.suspended) &&
        Objects.equals(this.tenantId, jobDefinitionDto.tenantId) &&
        Objects.equals(this.deploymentId, jobDefinitionDto.deploymentId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, processDefinitionId, processDefinitionKey, activityId, jobType, jobConfiguration, overridingJobPriority, suspended, tenantId, deploymentId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobDefinitionDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    jobType: ").append(toIndentedString(jobType)).append("\n");
    sb.append("    jobConfiguration: ").append(toIndentedString(jobConfiguration)).append("\n");
    sb.append("    overridingJobPriority: ").append(toIndentedString(overridingJobPriority)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

