/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.camunda.community.rest.client.dto.TriggerVariableValueDto;

/**
 * ProcessInstanceModificationInstructionDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class ProcessInstanceModificationInstructionDto {
  /**
   * **Mandatory**. One of the following values: &#x60;cancel&#x60;, &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, &#x60;startTransition&#x60;.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    CANCEL("cancel"),
    
    STARTBEFOREACTIVITY("startBeforeActivity"),
    
    STARTAFTERACTIVITY("startAfterActivity"),
    
    STARTTRANSITION("startTransition");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private TriggerVariableValueDto variables = null;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_TRANSITION_ID = "transitionId";
  @SerializedName(SERIALIZED_NAME_TRANSITION_ID)
  private String transitionId;

  public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_INSTANCE_ID)
  private String activityInstanceId;

  public static final String SERIALIZED_NAME_TRANSITION_INSTANCE_ID = "transitionInstanceId";
  @SerializedName(SERIALIZED_NAME_TRANSITION_INSTANCE_ID)
  private String transitionInstanceId;

  public static final String SERIALIZED_NAME_ANCESTOR_ACTIVITY_INSTANCE_ID = "ancestorActivityInstanceId";
  @SerializedName(SERIALIZED_NAME_ANCESTOR_ACTIVITY_INSTANCE_ID)
  private String ancestorActivityInstanceId;

  public static final String SERIALIZED_NAME_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES = "cancelCurrentActiveActivityInstances";
  @SerializedName(SERIALIZED_NAME_CANCEL_CURRENT_ACTIVE_ACTIVITY_INSTANCES)
  private Boolean cancelCurrentActiveActivityInstances;


  public ProcessInstanceModificationInstructionDto type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * **Mandatory**. One of the following values: &#x60;cancel&#x60;, &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, &#x60;startTransition&#x60;.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.
   * @return type
  **/
  @ApiModelProperty(required = true, value = "**Mandatory**. One of the following values: `cancel`, `startBeforeActivity`, `startAfterActivity`, `startTransition`.  * A cancel instruction requests cancellation of a single activity instance or all instances of one activity. * A startBeforeActivity instruction requests to enter a given activity. * A startAfterActivity instruction requests to execute the single outgoing sequence flow of a given activity. * A startTransition instruction requests to execute a specific sequence flow.")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ProcessInstanceModificationInstructionDto variables(TriggerVariableValueDto variables) {
    
    this.variables = variables;
    return this;
  }

   /**
   * Get variables
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TriggerVariableValueDto getVariables() {
    return variables;
  }


  public void setVariables(TriggerVariableValueDto variables) {
    this.variables = variables;
  }


  public ProcessInstanceModificationInstructionDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * Can be used with instructions of types &#x60;startTransition&#x60;. Specifies the sequence flow to start.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public ProcessInstanceModificationInstructionDto transitionId(String transitionId) {
    
    this.transitionId = transitionId;
    return this;
  }

   /**
   * Can be used with instructions of types &#x60;startTransition&#x60;. Specifies the sequence flow to start.
   * @return transitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of types `startTransition`. Specifies the sequence flow to start.")

  public String getTransitionId() {
    return transitionId;
  }


  public void setTransitionId(String transitionId) {
    this.transitionId = transitionId;
  }


  public ProcessInstanceModificationInstructionDto activityInstanceId(String activityInstanceId) {
    
    this.activityInstanceId = activityInstanceId;
    return this;
  }

   /**
   * Can be used with instructions of type &#x60;cancel&#x60;. Specifies the activity instance to cancel. Valid values are the activity instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.20/reference/rest/process-instance/get-activity-instances/).
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of type `cancel`. Specifies the activity instance to cancel. Valid values are the activity instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.20/reference/rest/process-instance/get-activity-instances/).")

  public String getActivityInstanceId() {
    return activityInstanceId;
  }


  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }


  public ProcessInstanceModificationInstructionDto transitionInstanceId(String transitionInstanceId) {
    
    this.transitionInstanceId = transitionInstanceId;
    return this;
  }

   /**
   * Can be used with instructions of type &#x60;cancel&#x60;. Specifies the transition instance to cancel. Valid values are the transition instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.20/reference/rest/process-instance/get-activity-instances/).
   * @return transitionInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of type `cancel`. Specifies the transition instance to cancel. Valid values are the transition instance IDs supplied by the [Get Activity Instance request](https://docs.camunda.org/manual/7.20/reference/rest/process-instance/get-activity-instances/).")

  public String getTransitionInstanceId() {
    return transitionInstanceId;
  }


  public void setTransitionInstanceId(String transitionInstanceId) {
    this.transitionInstanceId = transitionInstanceId;
  }


  public ProcessInstanceModificationInstructionDto ancestorActivityInstanceId(String ancestorActivityInstanceId) {
    
    this.ancestorActivityInstanceId = ancestorActivityInstanceId;
    return this;
  }

   /**
   * Can be used with instructions of type &#x60;startBeforeActivity&#x60;, &#x60;startAfterActivity&#x60;, and &#x60;startTransition&#x60;. Valid values are the activity instance IDs supplied by the Get Activity Instance request. If there are multiple parent activity instances of the targeted activity, this specifies the ancestor scope in which hierarchy the activity/transition is to be instantiated.  Example: When there are two instances of a subprocess and an activity contained in the subprocess is to be started, this parameter allows to specifiy under which subprocess instance the activity should be started.
   * @return ancestorActivityInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of type `startBeforeActivity`, `startAfterActivity`, and `startTransition`. Valid values are the activity instance IDs supplied by the Get Activity Instance request. If there are multiple parent activity instances of the targeted activity, this specifies the ancestor scope in which hierarchy the activity/transition is to be instantiated.  Example: When there are two instances of a subprocess and an activity contained in the subprocess is to be started, this parameter allows to specifiy under which subprocess instance the activity should be started.")

  public String getAncestorActivityInstanceId() {
    return ancestorActivityInstanceId;
  }


  public void setAncestorActivityInstanceId(String ancestorActivityInstanceId) {
    this.ancestorActivityInstanceId = ancestorActivityInstanceId;
  }


  public ProcessInstanceModificationInstructionDto cancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
    
    this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
    return this;
  }

   /**
   * Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.
   * @return cancelCurrentActiveActivityInstances
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Can be used with instructions of type cancel. Prevents the deletion of new created activity instances.")

  public Boolean getCancelCurrentActiveActivityInstances() {
    return cancelCurrentActiveActivityInstances;
  }


  public void setCancelCurrentActiveActivityInstances(Boolean cancelCurrentActiveActivityInstances) {
    this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceModificationInstructionDto processInstanceModificationInstructionDto = (ProcessInstanceModificationInstructionDto) o;
    return Objects.equals(this.type, processInstanceModificationInstructionDto.type) &&
        Objects.equals(this.variables, processInstanceModificationInstructionDto.variables) &&
        Objects.equals(this.activityId, processInstanceModificationInstructionDto.activityId) &&
        Objects.equals(this.transitionId, processInstanceModificationInstructionDto.transitionId) &&
        Objects.equals(this.activityInstanceId, processInstanceModificationInstructionDto.activityInstanceId) &&
        Objects.equals(this.transitionInstanceId, processInstanceModificationInstructionDto.transitionInstanceId) &&
        Objects.equals(this.ancestorActivityInstanceId, processInstanceModificationInstructionDto.ancestorActivityInstanceId) &&
        Objects.equals(this.cancelCurrentActiveActivityInstances, processInstanceModificationInstructionDto.cancelCurrentActiveActivityInstances);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, variables, activityId, transitionId, activityInstanceId, transitionInstanceId, ancestorActivityInstanceId, cancelCurrentActiveActivityInstances);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceModificationInstructionDto {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    transitionId: ").append(toIndentedString(transitionId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    transitionInstanceId: ").append(toIndentedString(transitionInstanceId)).append("\n");
    sb.append("    ancestorActivityInstanceId: ").append(toIndentedString(ancestorActivityInstanceId)).append("\n");
    sb.append("    cancelCurrentActiveActivityInstances: ").append(toIndentedString(cancelCurrentActiveActivityInstances)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

