/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.community.rest.client.dto.AbstractVendorVersionInformationDto;
import org.camunda.community.rest.client.dto.TelemetryCountDto;
import org.camunda.community.rest.client.dto.TelemetryLicenseKeyDto;

/**
 * TelemetryInternalsDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class TelemetryInternalsDto {
  public static final String SERIALIZED_NAME_DATABASE = "database";
  @SerializedName(SERIALIZED_NAME_DATABASE)
  private AbstractVendorVersionInformationDto database;

  public static final String SERIALIZED_NAME_APPLICATION_SERVER = "application-server";
  @SerializedName(SERIALIZED_NAME_APPLICATION_SERVER)
  private AbstractVendorVersionInformationDto applicationServer;

  public static final String SERIALIZED_NAME_LICENSE_KEY = "license-key";
  @SerializedName(SERIALIZED_NAME_LICENSE_KEY)
  private TelemetryLicenseKeyDto licenseKey;

  public static final String SERIALIZED_NAME_CAMUNDA_INTEGRATION = "camunda-integration";
  @SerializedName(SERIALIZED_NAME_CAMUNDA_INTEGRATION)
  private List<String> camundaIntegration = null;

  public static final String SERIALIZED_NAME_COMMANDS = "commands";
  @SerializedName(SERIALIZED_NAME_COMMANDS)
  private Map<String, TelemetryCountDto> commands = null;

  public static final String SERIALIZED_NAME_METRICS = "metrics";
  @SerializedName(SERIALIZED_NAME_METRICS)
  private Map<String, TelemetryCountDto> metrics = null;

  public static final String SERIALIZED_NAME_WEBAPPS = "webapps";
  @SerializedName(SERIALIZED_NAME_WEBAPPS)
  private List<String> webapps = null;

  public static final String SERIALIZED_NAME_JDK = "jdk";
  @SerializedName(SERIALIZED_NAME_JDK)
  private AbstractVendorVersionInformationDto jdk;

  public static final String SERIALIZED_NAME_DATA_COLLECTION_START_DATE = "data-collection-start-date";
  @SerializedName(SERIALIZED_NAME_DATA_COLLECTION_START_DATE)
  private Date dataCollectionStartDate;


  public TelemetryInternalsDto database(AbstractVendorVersionInformationDto database) {
    
    this.database = database;
    return this;
  }

   /**
   * Get database
   * @return database
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public AbstractVendorVersionInformationDto getDatabase() {
    return database;
  }


  public void setDatabase(AbstractVendorVersionInformationDto database) {
    this.database = database;
  }


  public TelemetryInternalsDto applicationServer(AbstractVendorVersionInformationDto applicationServer) {
    
    this.applicationServer = applicationServer;
    return this;
  }

   /**
   * Get applicationServer
   * @return applicationServer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public AbstractVendorVersionInformationDto getApplicationServer() {
    return applicationServer;
  }


  public void setApplicationServer(AbstractVendorVersionInformationDto applicationServer) {
    this.applicationServer = applicationServer;
  }


  public TelemetryInternalsDto licenseKey(TelemetryLicenseKeyDto licenseKey) {
    
    this.licenseKey = licenseKey;
    return this;
  }

   /**
   * Get licenseKey
   * @return licenseKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TelemetryLicenseKeyDto getLicenseKey() {
    return licenseKey;
  }


  public void setLicenseKey(TelemetryLicenseKeyDto licenseKey) {
    this.licenseKey = licenseKey;
  }


  public TelemetryInternalsDto camundaIntegration(List<String> camundaIntegration) {
    
    this.camundaIntegration = camundaIntegration;
    return this;
  }

  public TelemetryInternalsDto addCamundaIntegrationItem(String camundaIntegrationItem) {
    if (this.camundaIntegration == null) {
      this.camundaIntegration = new ArrayList<String>();
    }
    this.camundaIntegration.add(camundaIntegrationItem);
    return this;
  }

   /**
   * List of Camunda integrations used (e.g., Camunda Spring Boot Starter, Camunda Run, WildFly/JBoss subsystem, Camunda EJB).
   * @return camundaIntegration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of Camunda integrations used (e.g., Camunda Spring Boot Starter, Camunda Run, WildFly/JBoss subsystem, Camunda EJB).")

  public List<String> getCamundaIntegration() {
    return camundaIntegration;
  }


  public void setCamundaIntegration(List<String> camundaIntegration) {
    this.camundaIntegration = camundaIntegration;
  }


  public TelemetryInternalsDto commands(Map<String, TelemetryCountDto> commands) {
    
    this.commands = commands;
    return this;
  }

  public TelemetryInternalsDto putCommandsItem(String key, TelemetryCountDto commandsItem) {
    if (this.commands == null) {
      this.commands = new HashMap<String, TelemetryCountDto>();
    }
    this.commands.put(key, commandsItem);
    return this;
  }

   /**
   * The count of executed commands after the last retrieved data.
   * @return commands
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The count of executed commands after the last retrieved data.")

  public Map<String, TelemetryCountDto> getCommands() {
    return commands;
  }


  public void setCommands(Map<String, TelemetryCountDto> commands) {
    this.commands = commands;
  }


  public TelemetryInternalsDto metrics(Map<String, TelemetryCountDto> metrics) {
    
    this.metrics = metrics;
    return this;
  }

  public TelemetryInternalsDto putMetricsItem(String key, TelemetryCountDto metricsItem) {
    if (this.metrics == null) {
      this.metrics = new HashMap<String, TelemetryCountDto>();
    }
    this.metrics.put(key, metricsItem);
    return this;
  }

   /**
   * The collected metrics are the number of root process instance executions started, the number of activity instances started or also known as flow node instances, and the number of executed decision instances and elements.
   * @return metrics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The collected metrics are the number of root process instance executions started, the number of activity instances started or also known as flow node instances, and the number of executed decision instances and elements.")

  public Map<String, TelemetryCountDto> getMetrics() {
    return metrics;
  }


  public void setMetrics(Map<String, TelemetryCountDto> metrics) {
    this.metrics = metrics;
  }


  public TelemetryInternalsDto webapps(List<String> webapps) {
    
    this.webapps = webapps;
    return this;
  }

  public TelemetryInternalsDto addWebappsItem(String webappsItem) {
    if (this.webapps == null) {
      this.webapps = new ArrayList<String>();
    }
    this.webapps.add(webappsItem);
    return this;
  }

   /**
   * The webapps enabled in this installation of Camunda.
   * @return webapps
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The webapps enabled in this installation of Camunda.")

  public List<String> getWebapps() {
    return webapps;
  }


  public void setWebapps(List<String> webapps) {
    this.webapps = webapps;
  }


  public TelemetryInternalsDto jdk(AbstractVendorVersionInformationDto jdk) {
    
    this.jdk = jdk;
    return this;
  }

   /**
   * Get jdk
   * @return jdk
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public AbstractVendorVersionInformationDto getJdk() {
    return jdk;
  }


  public void setJdk(AbstractVendorVersionInformationDto jdk) {
    this.jdk = jdk;
  }


  public TelemetryInternalsDto dataCollectionStartDate(Date dataCollectionStartDate) {
    
    this.dataCollectionStartDate = dataCollectionStartDate;
    return this;
  }

   /**
   * The date when the engine started to collect dynamic data, such as command executions and metrics. If telemetry sending is enabled, dynamic data resets on sending the data to Camunda. Dynamic data and the date returned by this method are reset in three cases: engine startup, after engine start when sending telemetry data to Camunda is enabled via API, after sending telemetry data to Camunda (only when this was enabled) The date is in the format &lt;code&gt;YYYY-MM-DD&#39;T&#39;HH:mm:ss.SSSZ&lt;/code&gt;.
   * @return dataCollectionStartDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The date when the engine started to collect dynamic data, such as command executions and metrics. If telemetry sending is enabled, dynamic data resets on sending the data to Camunda. Dynamic data and the date returned by this method are reset in three cases: engine startup, after engine start when sending telemetry data to Camunda is enabled via API, after sending telemetry data to Camunda (only when this was enabled) The date is in the format <code>YYYY-MM-DD'T'HH:mm:ss.SSSZ</code>.")

  public Date getDataCollectionStartDate() {
    return dataCollectionStartDate;
  }


  public void setDataCollectionStartDate(Date dataCollectionStartDate) {
    this.dataCollectionStartDate = dataCollectionStartDate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TelemetryInternalsDto telemetryInternalsDto = (TelemetryInternalsDto) o;
    return Objects.equals(this.database, telemetryInternalsDto.database) &&
        Objects.equals(this.applicationServer, telemetryInternalsDto.applicationServer) &&
        Objects.equals(this.licenseKey, telemetryInternalsDto.licenseKey) &&
        Objects.equals(this.camundaIntegration, telemetryInternalsDto.camundaIntegration) &&
        Objects.equals(this.commands, telemetryInternalsDto.commands) &&
        Objects.equals(this.metrics, telemetryInternalsDto.metrics) &&
        Objects.equals(this.webapps, telemetryInternalsDto.webapps) &&
        Objects.equals(this.jdk, telemetryInternalsDto.jdk) &&
        Objects.equals(this.dataCollectionStartDate, telemetryInternalsDto.dataCollectionStartDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(database, applicationServer, licenseKey, camundaIntegration, commands, metrics, webapps, jdk, dataCollectionStartDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TelemetryInternalsDto {\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    applicationServer: ").append(toIndentedString(applicationServer)).append("\n");
    sb.append("    licenseKey: ").append(toIndentedString(licenseKey)).append("\n");
    sb.append("    camundaIntegration: ").append(toIndentedString(camundaIntegration)).append("\n");
    sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("    webapps: ").append(toIndentedString(webapps)).append("\n");
    sb.append("    jdk: ").append(toIndentedString(jdk)).append("\n");
    sb.append("    dataCollectionStartDate: ").append(toIndentedString(dataCollectionStartDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

