/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.GroupDto;
import org.camunda.community.rest.client.dto.GroupQueryDto;
import org.camunda.community.rest.client.dto.ResourceOptionsDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class GroupApi {
    private ApiClient localVarApiClient;

    public GroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call availableGroupInstanceOperationsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/group/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableGroupInstanceOperationsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableGroupInstanceOperations(Async)");
        }
        Call localVarCall = this.availableGroupInstanceOperationsCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableGroupInstanceOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableGroupInstanceOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableGroupInstanceOperationsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.availableGroupInstanceOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableGroupInstanceOperationsAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableGroupInstanceOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call availableGroupMembersOperationsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/group/{id}/members".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableGroupMembersOperationsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling availableGroupMembersOperations(Async)");
        }
        Call localVarCall = this.availableGroupMembersOperationsCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableGroupMembersOperations(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableGroupMembersOperationsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableGroupMembersOperationsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.availableGroupMembersOperationsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableGroupMembersOperationsAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableGroupMembersOperationsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call availableGroupOperationsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/group";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call availableGroupOperationsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.availableGroupOperationsCall(_callback);
        return localVarCall;
    }

    public ResourceOptionsDto availableGroupOperations() throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.availableGroupOperationsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> availableGroupOperationsWithHttpInfo() throws ApiException {
        Call localVarCall = this.availableGroupOperationsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call availableGroupOperationsAsync(ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.availableGroupOperationsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createGroupCall(GroupDto groupDto, ApiCallback _callback) throws ApiException {
        GroupDto localVarPostBody = groupDto;
        String localVarPath = "/group/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupValidateBeforeCall(GroupDto groupDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createGroupCall(groupDto, _callback);
        return localVarCall;
    }

    public void createGroup(GroupDto groupDto) throws ApiException {
        this.createGroupWithHttpInfo(groupDto);
    }

    public ApiResponse<Void> createGroupWithHttpInfo(GroupDto groupDto) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createGroupAsync(GroupDto groupDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(groupDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call createGroupMemberCall(String id, String userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/group/{id}/members/{userId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{userId\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupMemberValidateBeforeCall(String id, String userId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createGroupMember(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createGroupMember(Async)");
        }
        Call localVarCall = this.createGroupMemberCall(id, userId, _callback);
        return localVarCall;
    }

    public void createGroupMember(String id, String userId) throws ApiException {
        this.createGroupMemberWithHttpInfo(id, userId);
    }

    public ApiResponse<Void> createGroupMemberWithHttpInfo(String id, String userId) throws ApiException {
        Call localVarCall = this.createGroupMemberValidateBeforeCall(id, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createGroupMemberAsync(String id, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createGroupMemberValidateBeforeCall(id, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteGroupCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/group/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteGroup(Async)");
        }
        Call localVarCall = this.deleteGroupCall(id, _callback);
        return localVarCall;
    }

    public void deleteGroup(String id) throws ApiException {
        this.deleteGroupWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteGroupMemberCall(String id, String userId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/group/{id}/members/{userId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{userId\\}", this.localVarApiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupMemberValidateBeforeCall(String id, String userId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteGroupMember(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling deleteGroupMember(Async)");
        }
        Call localVarCall = this.deleteGroupMemberCall(id, userId, _callback);
        return localVarCall;
    }

    public void deleteGroupMember(String id, String userId) throws ApiException {
        this.deleteGroupMemberWithHttpInfo(id, userId);
    }

    public ApiResponse<Void> deleteGroupMemberWithHttpInfo(String id, String userId) throws ApiException {
        Call localVarCall = this.deleteGroupMemberValidateBeforeCall(id, userId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupMemberAsync(String id, String userId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupMemberValidateBeforeCall(id, userId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getGroupCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/group/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getGroup(Async)");
        }
        Call localVarCall = this.getGroupCall(id, _callback);
        return localVarCall;
    }

    public GroupDto getGroup(String id) throws ApiException {
        ApiResponse<GroupDto> localVarResp = this.getGroupWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<GroupDto> getGroupWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<GroupDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupAsync(String id, ApiCallback<GroupDto> _callback) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<GroupDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupCountCall(String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/group/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (idIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("idIn", idIn));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (member != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("member", member));
        }
        if (memberOfTenant != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memberOfTenant", memberOfTenant));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupCountValidateBeforeCall(String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getGroupCountCall(id, idIn, name, nameLike, type, member, memberOfTenant, _callback);
        return localVarCall;
    }

    public CountResultDto getGroupCount(String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getGroupCountWithHttpInfo(id, idIn, name, nameLike, type, member, memberOfTenant);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getGroupCountWithHttpInfo(String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant) throws ApiException {
        Call localVarCall = this.getGroupCountValidateBeforeCall(id, idIn, name, nameLike, type, member, memberOfTenant, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupCountAsync(String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getGroupCountValidateBeforeCall(id, idIn, name, nameLike, type, member, memberOfTenant, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getQueryGroupsCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/group";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (idIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("idIn", idIn));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (member != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("member", member));
        }
        if (memberOfTenant != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("memberOfTenant", memberOfTenant));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getQueryGroupsValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getQueryGroupsCall(sortBy, sortOrder, firstResult, maxResults, id, idIn, name, nameLike, type, member, memberOfTenant, _callback);
        return localVarCall;
    }

    public List<GroupDto> getQueryGroups(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant) throws ApiException {
        ApiResponse<List<GroupDto>> localVarResp = this.getQueryGroupsWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, id, idIn, name, nameLike, type, member, memberOfTenant);
        return localVarResp.getData();
    }

    public ApiResponse<List<GroupDto>> getQueryGroupsWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant) throws ApiException {
        Call localVarCall = this.getQueryGroupsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, id, idIn, name, nameLike, type, member, memberOfTenant, null);
        Type localVarReturnType = new TypeToken<List<GroupDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getQueryGroupsAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String id, String idIn, String name, String nameLike, String type, String member, String memberOfTenant, ApiCallback<List<GroupDto>> _callback) throws ApiException {
        Call localVarCall = this.getQueryGroupsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, id, idIn, name, nameLike, type, member, memberOfTenant, _callback);
        Type localVarReturnType = new TypeToken<List<GroupDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postQueryGroupsCall(Integer firstResult, Integer maxResults, GroupQueryDto groupQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        GroupQueryDto localVarPostBody = groupQueryDto;
        String localVarPath = "/group";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postQueryGroupsValidateBeforeCall(Integer firstResult, Integer maxResults, GroupQueryDto groupQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.postQueryGroupsCall(firstResult, maxResults, groupQueryDto, _callback);
        return localVarCall;
    }

    public List<GroupDto> postQueryGroups(Integer firstResult, Integer maxResults, GroupQueryDto groupQueryDto) throws ApiException {
        ApiResponse<List<GroupDto>> localVarResp = this.postQueryGroupsWithHttpInfo(firstResult, maxResults, groupQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<GroupDto>> postQueryGroupsWithHttpInfo(Integer firstResult, Integer maxResults, GroupQueryDto groupQueryDto) throws ApiException {
        Call localVarCall = this.postQueryGroupsValidateBeforeCall(firstResult, maxResults, groupQueryDto, null);
        Type localVarReturnType = new TypeToken<List<GroupDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postQueryGroupsAsync(Integer firstResult, Integer maxResults, GroupQueryDto groupQueryDto, ApiCallback<List<GroupDto>> _callback) throws ApiException {
        Call localVarCall = this.postQueryGroupsValidateBeforeCall(firstResult, maxResults, groupQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<GroupDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryGroupCountCall(GroupQueryDto groupQueryDto, ApiCallback _callback) throws ApiException {
        GroupQueryDto localVarPostBody = groupQueryDto;
        String localVarPath = "/group/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryGroupCountValidateBeforeCall(GroupQueryDto groupQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryGroupCountCall(groupQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryGroupCount(GroupQueryDto groupQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryGroupCountWithHttpInfo(groupQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryGroupCountWithHttpInfo(GroupQueryDto groupQueryDto) throws ApiException {
        Call localVarCall = this.queryGroupCountValidateBeforeCall(groupQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryGroupCountAsync(GroupQueryDto groupQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryGroupCountValidateBeforeCall(groupQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateGroupCall(String id, GroupDto groupDto, ApiCallback _callback) throws ApiException {
        GroupDto localVarPostBody = groupDto;
        String localVarPath = "/group/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateGroupValidateBeforeCall(String id, GroupDto groupDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateGroup(Async)");
        }
        Call localVarCall = this.updateGroupCall(id, groupDto, _callback);
        return localVarCall;
    }

    public void updateGroup(String id, GroupDto groupDto) throws ApiException {
        this.updateGroupWithHttpInfo(id, groupDto);
    }

    public ApiResponse<Void> updateGroupWithHttpInfo(String id, GroupDto groupDto) throws ApiException {
        Call localVarCall = this.updateGroupValidateBeforeCall(id, groupDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateGroupAsync(String id, GroupDto groupDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateGroupValidateBeforeCall(id, groupDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

