/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.JobDto;
import org.camunda.community.rest.client.dto.JobDuedateDto;
import org.camunda.community.rest.client.dto.JobQueryDto;
import org.camunda.community.rest.client.dto.JobRetriesDto;
import org.camunda.community.rest.client.dto.JobSuspensionStateDto;
import org.camunda.community.rest.client.dto.PriorityDto;
import org.camunda.community.rest.client.dto.SetJobRetriesDto;
import org.camunda.community.rest.client.dto.SuspensionStateDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class JobApi {
    private ApiClient localVarApiClient;

    public JobApi() {
        this(Configuration.getDefaultApiClient());
    }

    public JobApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteJobCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteJobValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteJob(Async)");
        }
        Call localVarCall = this.deleteJobCall(id, _callback);
        return localVarCall;
    }

    public void deleteJob(String id) throws ApiException {
        this.deleteJobWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteJobWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteJobValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteJobAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteJobValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call executeJobCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job/{id}/execute".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call executeJobValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeJob(Async)");
        }
        Call localVarCall = this.executeJobCall(id, _callback);
        return localVarCall;
    }

    public void executeJob(String id) throws ApiException {
        this.executeJobWithHttpInfo(id);
    }

    public ApiResponse<Void> executeJobWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.executeJobValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call executeJobAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.executeJobValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getJobCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getJob(Async)");
        }
        Call localVarCall = this.getJobCall(id, _callback);
        return localVarCall;
    }

    public JobDto getJob(String id) throws ApiException {
        ApiResponse<JobDto> localVarResp = this.getJobWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<JobDto> getJobWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getJobValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<JobDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJobAsync(String id, ApiCallback<JobDto> _callback) throws ApiException {
        Call localVarCall = this.getJobValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<JobDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getJobsCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/job";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jobId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobId", jobId));
        }
        if (jobIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobIds", jobIds));
        }
        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (withRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        }
        if (executable != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executable", executable));
        }
        if (timers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timers", timers));
        }
        if (messages != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("messages", messages));
        }
        if (dueDates != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueDates", dueDates));
        }
        if (createTimes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createTimes", createTimes));
        }
        if (withException != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withException", withException));
        }
        if (exceptionMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exceptionMessage", exceptionMessage));
        }
        if (failedActivityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }
        if (noRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }
        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeJobsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobsValidateBeforeCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getJobsCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<JobDto> getJobs(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<JobDto>> localVarResp = this.getJobsWithHttpInfo(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<JobDto>> getJobsWithHttpInfo(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getJobsValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJobsAsync(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<JobDto>> _callback) throws ApiException {
        Call localVarCall = this.getJobsValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getJobsCountCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/job/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (jobId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobId", jobId));
        }
        if (jobIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobIds", jobIds));
        }
        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }
        if (processInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }
        if (processInstanceIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }
        if (executionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executionId", executionId));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (activityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityId", activityId));
        }
        if (withRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withRetriesLeft", withRetriesLeft));
        }
        if (executable != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("executable", executable));
        }
        if (timers != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timers", timers));
        }
        if (messages != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("messages", messages));
        }
        if (dueDates != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dueDates", dueDates));
        }
        if (createTimes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("createTimes", createTimes));
        }
        if (withException != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withException", withException));
        }
        if (exceptionMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("exceptionMessage", exceptionMessage));
        }
        if (failedActivityId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failedActivityId", failedActivityId));
        }
        if (noRetriesLeft != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noRetriesLeft", noRetriesLeft));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (priorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityLowerThanOrEquals", priorityLowerThanOrEquals));
        }
        if (priorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("priorityHigherThanOrEquals", priorityHigherThanOrEquals));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeJobsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeJobsWithoutTenantId", includeJobsWithoutTenantId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJobsCountValidateBeforeCall(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getJobsCountCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, _callback);
        return localVarCall;
    }

    public CountResultDto getJobsCount(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getJobsCountWithHttpInfo(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getJobsCountWithHttpInfo(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId) throws ApiException {
        Call localVarCall = this.getJobsCountValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJobsCountAsync(String jobId, String jobIds, String jobDefinitionId, String processInstanceId, String processInstanceIds, String executionId, String processDefinitionId, String processDefinitionKey, String activityId, Boolean withRetriesLeft, Boolean executable, Boolean timers, Boolean messages, String dueDates, String createTimes, Boolean withException, String exceptionMessage, String failedActivityId, Boolean noRetriesLeft, Boolean active, Boolean suspended, Long priorityLowerThanOrEquals, Long priorityHigherThanOrEquals, String tenantIdIn, Boolean withoutTenantId, Boolean includeJobsWithoutTenantId, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getJobsCountValidateBeforeCall(jobId, jobIds, jobDefinitionId, processInstanceId, processInstanceIds, executionId, processDefinitionId, processDefinitionKey, activityId, withRetriesLeft, executable, timers, messages, dueDates, createTimes, withException, exceptionMessage, failedActivityId, noRetriesLeft, active, suspended, priorityLowerThanOrEquals, priorityHigherThanOrEquals, tenantIdIn, withoutTenantId, includeJobsWithoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getStacktraceCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/job/{id}/stacktrace".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getStacktraceValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStacktrace(Async)");
        }
        Call localVarCall = this.getStacktraceCall(id, _callback);
        return localVarCall;
    }

    public Object getStacktrace(String id) throws ApiException {
        ApiResponse<Object> localVarResp = this.getStacktraceWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Object> getStacktraceWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getStacktraceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getStacktraceAsync(String id, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.getStacktraceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryJobsCall(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        JobQueryDto localVarPostBody = jobQueryDto;
        String localVarPath = "/job";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryJobsValidateBeforeCall(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryJobsCall(firstResult, maxResults, jobQueryDto, _callback);
        return localVarCall;
    }

    public List<JobDto> queryJobs(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto) throws ApiException {
        ApiResponse<List<JobDto>> localVarResp = this.queryJobsWithHttpInfo(firstResult, maxResults, jobQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<JobDto>> queryJobsWithHttpInfo(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto) throws ApiException {
        Call localVarCall = this.queryJobsValidateBeforeCall(firstResult, maxResults, jobQueryDto, null);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryJobsAsync(Integer firstResult, Integer maxResults, JobQueryDto jobQueryDto, ApiCallback<List<JobDto>> _callback) throws ApiException {
        Call localVarCall = this.queryJobsValidateBeforeCall(firstResult, maxResults, jobQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<JobDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryJobsCountCall(JobQueryDto jobQueryDto, ApiCallback _callback) throws ApiException {
        JobQueryDto localVarPostBody = jobQueryDto;
        String localVarPath = "/job/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryJobsCountValidateBeforeCall(JobQueryDto jobQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryJobsCountCall(jobQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryJobsCount(JobQueryDto jobQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryJobsCountWithHttpInfo(jobQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryJobsCountWithHttpInfo(JobQueryDto jobQueryDto) throws ApiException {
        Call localVarCall = this.queryJobsCountValidateBeforeCall(jobQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryJobsCountAsync(JobQueryDto jobQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryJobsCountValidateBeforeCall(jobQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call recalculateDuedateCall(String id, Boolean creationDateBased, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/job/{id}/duedate/recalculate".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (creationDateBased != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("creationDateBased", creationDateBased));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call recalculateDuedateValidateBeforeCall(String id, Boolean creationDateBased, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling recalculateDuedate(Async)");
        }
        Call localVarCall = this.recalculateDuedateCall(id, creationDateBased, _callback);
        return localVarCall;
    }

    public void recalculateDuedate(String id, Boolean creationDateBased) throws ApiException {
        this.recalculateDuedateWithHttpInfo(id, creationDateBased);
    }

    public ApiResponse<Void> recalculateDuedateWithHttpInfo(String id, Boolean creationDateBased) throws ApiException {
        Call localVarCall = this.recalculateDuedateValidateBeforeCall(id, creationDateBased, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call recalculateDuedateAsync(String id, Boolean creationDateBased, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.recalculateDuedateValidateBeforeCall(id, creationDateBased, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setJobDuedateCall(String id, JobDuedateDto jobDuedateDto, ApiCallback _callback) throws ApiException {
        JobDuedateDto localVarPostBody = jobDuedateDto;
        String localVarPath = "/job/{id}/duedate".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setJobDuedateValidateBeforeCall(String id, JobDuedateDto jobDuedateDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobDuedate(Async)");
        }
        Call localVarCall = this.setJobDuedateCall(id, jobDuedateDto, _callback);
        return localVarCall;
    }

    public void setJobDuedate(String id, JobDuedateDto jobDuedateDto) throws ApiException {
        this.setJobDuedateWithHttpInfo(id, jobDuedateDto);
    }

    public ApiResponse<Void> setJobDuedateWithHttpInfo(String id, JobDuedateDto jobDuedateDto) throws ApiException {
        Call localVarCall = this.setJobDuedateValidateBeforeCall(id, jobDuedateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setJobDuedateAsync(String id, JobDuedateDto jobDuedateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setJobDuedateValidateBeforeCall(id, jobDuedateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setJobPriorityCall(String id, PriorityDto priorityDto, ApiCallback _callback) throws ApiException {
        PriorityDto localVarPostBody = priorityDto;
        String localVarPath = "/job/{id}/priority".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setJobPriorityValidateBeforeCall(String id, PriorityDto priorityDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobPriority(Async)");
        }
        Call localVarCall = this.setJobPriorityCall(id, priorityDto, _callback);
        return localVarCall;
    }

    public void setJobPriority(String id, PriorityDto priorityDto) throws ApiException {
        this.setJobPriorityWithHttpInfo(id, priorityDto);
    }

    public ApiResponse<Void> setJobPriorityWithHttpInfo(String id, PriorityDto priorityDto) throws ApiException {
        Call localVarCall = this.setJobPriorityValidateBeforeCall(id, priorityDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setJobPriorityAsync(String id, PriorityDto priorityDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setJobPriorityValidateBeforeCall(id, priorityDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setJobRetriesCall(String id, JobRetriesDto jobRetriesDto, ApiCallback _callback) throws ApiException {
        JobRetriesDto localVarPostBody = jobRetriesDto;
        String localVarPath = "/job/{id}/retries".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setJobRetriesValidateBeforeCall(String id, JobRetriesDto jobRetriesDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setJobRetries(Async)");
        }
        Call localVarCall = this.setJobRetriesCall(id, jobRetriesDto, _callback);
        return localVarCall;
    }

    public void setJobRetries(String id, JobRetriesDto jobRetriesDto) throws ApiException {
        this.setJobRetriesWithHttpInfo(id, jobRetriesDto);
    }

    public ApiResponse<Void> setJobRetriesWithHttpInfo(String id, JobRetriesDto jobRetriesDto) throws ApiException {
        Call localVarCall = this.setJobRetriesValidateBeforeCall(id, jobRetriesDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setJobRetriesAsync(String id, JobRetriesDto jobRetriesDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setJobRetriesValidateBeforeCall(id, jobRetriesDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setJobRetriesAsyncOperationCall(SetJobRetriesDto setJobRetriesDto, ApiCallback _callback) throws ApiException {
        SetJobRetriesDto localVarPostBody = setJobRetriesDto;
        String localVarPath = "/job/retries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setJobRetriesAsyncOperationValidateBeforeCall(SetJobRetriesDto setJobRetriesDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setJobRetriesAsyncOperationCall(setJobRetriesDto, _callback);
        return localVarCall;
    }

    public BatchDto setJobRetriesAsyncOperation(SetJobRetriesDto setJobRetriesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.setJobRetriesAsyncOperationWithHttpInfo(setJobRetriesDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> setJobRetriesAsyncOperationWithHttpInfo(SetJobRetriesDto setJobRetriesDto) throws ApiException {
        Call localVarCall = this.setJobRetriesAsyncOperationValidateBeforeCall(setJobRetriesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setJobRetriesAsyncOperationAsync(SetJobRetriesDto setJobRetriesDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.setJobRetriesAsyncOperationValidateBeforeCall(setJobRetriesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateJobSuspensionStateCall(String id, SuspensionStateDto suspensionStateDto, ApiCallback _callback) throws ApiException {
        SuspensionStateDto localVarPostBody = suspensionStateDto;
        String localVarPath = "/job/{id}/suspended".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateJobSuspensionStateValidateBeforeCall(String id, SuspensionStateDto suspensionStateDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateJobSuspensionState(Async)");
        }
        Call localVarCall = this.updateJobSuspensionStateCall(id, suspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateJobSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        this.updateJobSuspensionStateWithHttpInfo(id, suspensionStateDto);
    }

    public ApiResponse<Void> updateJobSuspensionStateWithHttpInfo(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        Call localVarCall = this.updateJobSuspensionStateValidateBeforeCall(id, suspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateJobSuspensionStateAsync(String id, SuspensionStateDto suspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateJobSuspensionStateValidateBeforeCall(id, suspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateSuspensionStateByCall(JobSuspensionStateDto jobSuspensionStateDto, ApiCallback _callback) throws ApiException {
        JobSuspensionStateDto localVarPostBody = jobSuspensionStateDto;
        String localVarPath = "/job/suspended";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuspensionStateByValidateBeforeCall(JobSuspensionStateDto jobSuspensionStateDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateByCall(jobSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateSuspensionStateBy(JobSuspensionStateDto jobSuspensionStateDto) throws ApiException {
        this.updateSuspensionStateByWithHttpInfo(jobSuspensionStateDto);
    }

    public ApiResponse<Void> updateSuspensionStateByWithHttpInfo(JobSuspensionStateDto jobSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateSuspensionStateByValidateBeforeCall(jobSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateSuspensionStateByAsync(JobSuspensionStateDto jobSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateByValidateBeforeCall(jobSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

