/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.PatchVariablesDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class TaskVariableApi {
    private ApiClient localVarApiClient;

    public TaskVariableApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskVariableApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteTaskVariableCall(String id, String varName, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/variables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTaskVariableValidateBeforeCall(String id, String varName, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteTaskVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling deleteTaskVariable(Async)");
        }
        Call localVarCall = this.deleteTaskVariableCall(id, varName, _callback);
        return localVarCall;
    }

    public void deleteTaskVariable(String id, String varName) throws ApiException {
        this.deleteTaskVariableWithHttpInfo(id, varName);
    }

    public ApiResponse<Void> deleteTaskVariableWithHttpInfo(String id, String varName) throws ApiException {
        Call localVarCall = this.deleteTaskVariableValidateBeforeCall(id, varName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTaskVariableAsync(String id, String varName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTaskVariableValidateBeforeCall(id, varName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getTaskVariableCall(String id, String varName, Boolean deserializeValue, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/variables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (deserializeValue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValue", deserializeValue));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaskVariableValidateBeforeCall(String id, String varName, Boolean deserializeValue, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTaskVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getTaskVariable(Async)");
        }
        Call localVarCall = this.getTaskVariableCall(id, varName, deserializeValue, _callback);
        return localVarCall;
    }

    public VariableValueDto getTaskVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
        ApiResponse<VariableValueDto> localVarResp = this.getTaskVariableWithHttpInfo(id, varName, deserializeValue);
        return localVarResp.getData();
    }

    public ApiResponse<VariableValueDto> getTaskVariableWithHttpInfo(String id, String varName, Boolean deserializeValue) throws ApiException {
        Call localVarCall = this.getTaskVariableValidateBeforeCall(id, varName, deserializeValue, null);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTaskVariableAsync(String id, String varName, Boolean deserializeValue, ApiCallback<VariableValueDto> _callback) throws ApiException {
        Call localVarCall = this.getTaskVariableValidateBeforeCall(id, varName, deserializeValue, _callback);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTaskVariableBinaryCall(String id, String varName, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/variables/{varName}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaskVariableBinaryValidateBeforeCall(String id, String varName, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTaskVariableBinary(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getTaskVariableBinary(Async)");
        }
        Call localVarCall = this.getTaskVariableBinaryCall(id, varName, _callback);
        return localVarCall;
    }

    public File getTaskVariableBinary(String id, String varName) throws ApiException {
        ApiResponse<File> localVarResp = this.getTaskVariableBinaryWithHttpInfo(id, varName);
        return localVarResp.getData();
    }

    public ApiResponse<File> getTaskVariableBinaryWithHttpInfo(String id, String varName) throws ApiException {
        Call localVarCall = this.getTaskVariableBinaryValidateBeforeCall(id, varName, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTaskVariableBinaryAsync(String id, String varName, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getTaskVariableBinaryValidateBeforeCall(id, varName, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTaskVariablesCall(String id, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/variables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (deserializeValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTaskVariablesValidateBeforeCall(String id, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTaskVariables(Async)");
        }
        Call localVarCall = this.getTaskVariablesCall(id, deserializeValues, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> getTaskVariables(String id, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.getTaskVariablesWithHttpInfo(id, deserializeValues);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> getTaskVariablesWithHttpInfo(String id, Boolean deserializeValues) throws ApiException {
        Call localVarCall = this.getTaskVariablesValidateBeforeCall(id, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTaskVariablesAsync(String id, Boolean deserializeValues, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.getTaskVariablesValidateBeforeCall(id, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyTaskVariablesCall(String id, PatchVariablesDto patchVariablesDto, ApiCallback _callback) throws ApiException {
        PatchVariablesDto localVarPostBody = patchVariablesDto;
        String localVarPath = "/task/{id}/variables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyTaskVariablesValidateBeforeCall(String id, PatchVariablesDto patchVariablesDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyTaskVariables(Async)");
        }
        Call localVarCall = this.modifyTaskVariablesCall(id, patchVariablesDto, _callback);
        return localVarCall;
    }

    public void modifyTaskVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        this.modifyTaskVariablesWithHttpInfo(id, patchVariablesDto);
    }

    public ApiResponse<Void> modifyTaskVariablesWithHttpInfo(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        Call localVarCall = this.modifyTaskVariablesValidateBeforeCall(id, patchVariablesDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call modifyTaskVariablesAsync(String id, PatchVariablesDto patchVariablesDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.modifyTaskVariablesValidateBeforeCall(id, patchVariablesDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call putTaskVariableCall(String id, String varName, VariableValueDto variableValueDto, ApiCallback _callback) throws ApiException {
        VariableValueDto localVarPostBody = variableValueDto;
        String localVarPath = "/task/{id}/variables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putTaskVariableValidateBeforeCall(String id, String varName, VariableValueDto variableValueDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling putTaskVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling putTaskVariable(Async)");
        }
        Call localVarCall = this.putTaskVariableCall(id, varName, variableValueDto, _callback);
        return localVarCall;
    }

    public void putTaskVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        this.putTaskVariableWithHttpInfo(id, varName, variableValueDto);
    }

    public ApiResponse<Void> putTaskVariableWithHttpInfo(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        Call localVarCall = this.putTaskVariableValidateBeforeCall(id, varName, variableValueDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call putTaskVariableAsync(String id, String varName, VariableValueDto variableValueDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putTaskVariableValidateBeforeCall(id, varName, variableValueDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setBinaryTaskVariableCall(String id, String varName, File data, String valueType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/variables/{varName}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (valueType != null) {
            localVarFormParams.put("valueType", valueType);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setBinaryTaskVariableValidateBeforeCall(String id, String varName, File data, String valueType, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setBinaryTaskVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling setBinaryTaskVariable(Async)");
        }
        Call localVarCall = this.setBinaryTaskVariableCall(id, varName, data, valueType, _callback);
        return localVarCall;
    }

    public void setBinaryTaskVariable(String id, String varName, File data, String valueType) throws ApiException {
        this.setBinaryTaskVariableWithHttpInfo(id, varName, data, valueType);
    }

    public ApiResponse<Void> setBinaryTaskVariableWithHttpInfo(String id, String varName, File data, String valueType) throws ApiException {
        Call localVarCall = this.setBinaryTaskVariableValidateBeforeCall(id, varName, data, valueType, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setBinaryTaskVariableAsync(String id, String varName, File data, String valueType, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setBinaryTaskVariableValidateBeforeCall(id, varName, data, valueType, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

