/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class DecisionDefinitionDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private String category;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    private String resource;
    public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
    @SerializedName(value="deploymentId")
    private String deploymentId;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_ID = "decisionRequirementsDefinitionId";
    @SerializedName(value="decisionRequirementsDefinitionId")
    private String decisionRequirementsDefinitionId;
    public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_KEY = "decisionRequirementsDefinitionKey";
    @SerializedName(value="decisionRequirementsDefinitionKey")
    private String decisionRequirementsDefinitionKey;
    public static final String SERIALIZED_NAME_HISTORY_TIME_TO_LIVE = "historyTimeToLive";
    @SerializedName(value="historyTimeToLive")
    private Integer historyTimeToLive;
    public static final String SERIALIZED_NAME_VERSION_TAG = "versionTag";
    @SerializedName(value="versionTag")
    private String versionTag;

    public DecisionDefinitionDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the decision definition")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DecisionDefinitionDto key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the decision definition, i.e., the id of the DMN 1.0 XML decision definition.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public DecisionDefinitionDto category(String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The category of the decision definition.")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public DecisionDefinitionDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the decision definition.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DecisionDefinitionDto version(Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version of the decision definition that the engine assigned to it.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DecisionDefinitionDto resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The file name of the decision definition.")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public DecisionDefinitionDto deploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The deployment id of the decision definition.")
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public DecisionDefinitionDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the decision definition.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public DecisionDefinitionDto decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the decision requirements definition this decision definition belongs to.")
    public String getDecisionRequirementsDefinitionId() {
        return this.decisionRequirementsDefinitionId;
    }

    public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    }

    public DecisionDefinitionDto decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the decision requirements definition this decision definition belongs to.")
    public String getDecisionRequirementsDefinitionKey() {
        return this.decisionRequirementsDefinitionKey;
    }

    public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
    }

    public DecisionDefinitionDto historyTimeToLive(Integer historyTimeToLive) {
        this.historyTimeToLive = historyTimeToLive;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="History time to live value of the decision definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).")
    public Integer getHistoryTimeToLive() {
        return this.historyTimeToLive;
    }

    public void setHistoryTimeToLive(Integer historyTimeToLive) {
        this.historyTimeToLive = historyTimeToLive;
    }

    public DecisionDefinitionDto versionTag(String versionTag) {
        this.versionTag = versionTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version tag of the decision definition.")
    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionDefinitionDto decisionDefinitionDto = (DecisionDefinitionDto)o;
        return Objects.equals(this.id, decisionDefinitionDto.id) && Objects.equals(this.key, decisionDefinitionDto.key) && Objects.equals(this.category, decisionDefinitionDto.category) && Objects.equals(this.name, decisionDefinitionDto.name) && Objects.equals(this.version, decisionDefinitionDto.version) && Objects.equals(this.resource, decisionDefinitionDto.resource) && Objects.equals(this.deploymentId, decisionDefinitionDto.deploymentId) && Objects.equals(this.tenantId, decisionDefinitionDto.tenantId) && Objects.equals(this.decisionRequirementsDefinitionId, decisionDefinitionDto.decisionRequirementsDefinitionId) && Objects.equals(this.decisionRequirementsDefinitionKey, decisionDefinitionDto.decisionRequirementsDefinitionKey) && Objects.equals(this.historyTimeToLive, decisionDefinitionDto.historyTimeToLive) && Objects.equals(this.versionTag, decisionDefinitionDto.versionTag);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.key, this.category, this.name, this.version, this.resource, this.deploymentId, this.tenantId, this.decisionRequirementsDefinitionId, this.decisionRequirementsDefinitionKey, this.historyTimeToLive, this.versionTag);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionDefinitionDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    deploymentId: ").append(this.toIndentedString(this.deploymentId)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    decisionRequirementsDefinitionId: ").append(this.toIndentedString(this.decisionRequirementsDefinitionId)).append("\n");
        sb.append("    decisionRequirementsDefinitionKey: ").append(this.toIndentedString(this.decisionRequirementsDefinitionKey)).append("\n");
        sb.append("    historyTimeToLive: ").append(this.toIndentedString(this.historyTimeToLive)).append("\n");
        sb.append("    versionTag: ").append(this.toIndentedString(this.versionTag)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

