/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class EvaluationConditionDto {
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;

    public EvaluationConditionDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public EvaluationConditionDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A map of variables which are used for evaluation of the conditions and are injected into the process instances which have been triggered. Each key is a variable name and each value a JSON variable value object with the following properties.")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public EvaluationConditionDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used for the process instances that have been triggered after the evaluation.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public EvaluationConditionDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to evaluate a condition for a tenant with the given id. Will only evaluate conditions of process definitions which belong to the tenant.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public EvaluationConditionDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A Boolean value that indicates whether the conditions should only be evaluated of process definitions which belong to no tenant or not. Value may only be true, as false is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public EvaluationConditionDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to evaluate conditions of the process definition with the given id.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationConditionDto evaluationConditionDto = (EvaluationConditionDto)o;
        return Objects.equals(this.variables, evaluationConditionDto.variables) && Objects.equals(this.businessKey, evaluationConditionDto.businessKey) && Objects.equals(this.tenantId, evaluationConditionDto.tenantId) && Objects.equals(this.withoutTenantId, evaluationConditionDto.withoutTenantId) && Objects.equals(this.processDefinitionId, evaluationConditionDto.processDefinitionId);
    }

    public int hashCode() {
        return Objects.hash(this.variables, this.businessKey, this.tenantId, this.withoutTenantId, this.processDefinitionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluationConditionDto {\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

