/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricDetailDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
    @SerializedName(value="caseDefinitionKey")
    private String caseDefinitionKey;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
    @SerializedName(value="caseDefinitionId")
    private String caseDefinitionId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
    @SerializedName(value="caseExecutionId")
    private String caseExecutionId;
    public static final String SERIALIZED_NAME_TASK_ID = "taskId";
    @SerializedName(value="taskId")
    private String taskId;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_USER_OPERATION_ID = "userOperationId";
    @SerializedName(value="userOperationId")
    private String userOperationId;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private Date time;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;
    public static final String SERIALIZED_NAME_FIELD_ID = "fieldId";
    @SerializedName(value="fieldId")
    private String fieldId;
    public static final String SERIALIZED_NAME_FIELD_VALUE = "fieldValue";
    @SerializedName(value="fieldValue")
    private Object fieldValue;
    public static final String SERIALIZED_NAME_VARIABLE_NAME = "variableName";
    @SerializedName(value="variableName")
    private String variableName;
    public static final String SERIALIZED_NAME_VARIABLE_INSTANCE_ID = "variableInstanceId";
    @SerializedName(value="variableInstanceId")
    private String variableInstanceId;
    public static final String SERIALIZED_NAME_VARIABLE_TYPE = "variableType";
    @SerializedName(value="variableType")
    private String variableType;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Object value;
    public static final String SERIALIZED_NAME_VALUE_INFO = "valueInfo";
    @SerializedName(value="valueInfo")
    private Map<String, Object> valueInfo = null;
    public static final String SERIALIZED_NAME_INITIAL = "initial";
    @SerializedName(value="initial")
    private Boolean initial;
    public static final String SERIALIZED_NAME_REVISION = "revision";
    @SerializedName(value="revision")
    private Integer revision;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;

    public HistoricDetailDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the historic detail.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricDetailDto type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the historic detail. Either `formField` for a submitted form field value or `variableUpdate` for variable updates.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public HistoricDetailDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition that this historic detail belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricDetailDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition that this historic detail belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricDetailDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance the historic detail belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricDetailDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity instance the historic detail belongs to.")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public HistoricDetailDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the execution the historic detail belongs to.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricDetailDto caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the case definition that this historic detail belongs to.")
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public HistoricDetailDto caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case definition that this historic detail belongs to.")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public HistoricDetailDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case instance the historic detail belongs to.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricDetailDto caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case execution the historic detail belongs to.")
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public HistoricDetailDto taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the task the historic detail belongs to.")
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public HistoricDetailDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant that this historic detail belongs to.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricDetailDto userOperationId(String userOperationId) {
        this.userOperationId = userOperationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of user operation which links historic detail with [user operation log](https://docs.camunda.org/manual/7.20/reference/rest/history/user-operation-log/) entries.")
    public String getUserOperationId() {
        return this.userOperationId;
    }

    public void setUserOperationId(String userOperationId) {
        this.userOperationId = userOperationId;
    }

    public HistoricDetailDto time(Date time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when this historic detail occurred. Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public HistoricDetailDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the historic detail should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public HistoricDetailDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the process containing this historic detail.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public HistoricDetailDto fieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the form field.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `formField`.")
    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public HistoricDetailDto fieldValue(Object fieldValue) {
        this.fieldValue = fieldValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The submitted form field value. The value differs depending on the form field's type and on the `deserializeValue` parameter.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `formField`.")
    public Object getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(Object fieldValue) {
        this.fieldValue = fieldValue;
    }

    public HistoricDetailDto variableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the variable which has been updated.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public HistoricDetailDto variableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the associated variable instance.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public String getVariableInstanceId() {
        return this.variableInstanceId;
    }

    public void setVariableInstanceId(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    public HistoricDetailDto variableType(String variableType) {
        this.variableType = variableType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The value type of the variable.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public String getVariableType() {
        return this.variableType;
    }

    public void setVariableType(String variableType) {
        this.variableType = variableType;
    }

    public HistoricDetailDto value(Object value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The variable's value. Value differs depending on the variable's type and on the deserializeValues parameter.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public HistoricDetailDto valueInfo(Map<String, Object> valueInfo) {
        this.valueInfo = valueInfo;
        return this;
    }

    public HistoricDetailDto putValueInfoItem(String key, Object valueInfoItem) {
        if (this.valueInfo == null) {
            this.valueInfo = new HashMap<String, Object>();
        }
        this.valueInfo.put(key, valueInfoItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing additional, value-type-dependent properties. For variables of type `Object`, the following properties are returned:  * `objectTypeName`: A string representation of the object's type name. * `serializationDataFormat`: The serialization format used to store the variable.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public Map<String, Object> getValueInfo() {
        return this.valueInfo;
    }

    public void setValueInfo(Map<String, Object> valueInfo) {
        this.valueInfo = valueInfo;
    }

    public HistoricDetailDto initial(Boolean initial) {
        this.initial = initial;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Returns `true` for variable updates that contains the initial values of the variables.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public Boolean getInitial() {
        return this.initial;
    }

    public void setInitial(Boolean initial) {
        this.initial = initial;
    }

    public HistoricDetailDto revision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The revision of the historic variable update.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public HistoricDetailDto errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An error message in case a Java Serialized Object could not be de-serialized.  **Note:** This property is only set for a `HistoricVariableUpdate` historic details. In these cases, the value of the `type` property is `variableUpdate`.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricDetailDto historicDetailDto = (HistoricDetailDto)o;
        return Objects.equals(this.id, historicDetailDto.id) && Objects.equals(this.type, historicDetailDto.type) && Objects.equals(this.processDefinitionKey, historicDetailDto.processDefinitionKey) && Objects.equals(this.processDefinitionId, historicDetailDto.processDefinitionId) && Objects.equals(this.processInstanceId, historicDetailDto.processInstanceId) && Objects.equals(this.activityInstanceId, historicDetailDto.activityInstanceId) && Objects.equals(this.executionId, historicDetailDto.executionId) && Objects.equals(this.caseDefinitionKey, historicDetailDto.caseDefinitionKey) && Objects.equals(this.caseDefinitionId, historicDetailDto.caseDefinitionId) && Objects.equals(this.caseInstanceId, historicDetailDto.caseInstanceId) && Objects.equals(this.caseExecutionId, historicDetailDto.caseExecutionId) && Objects.equals(this.taskId, historicDetailDto.taskId) && Objects.equals(this.tenantId, historicDetailDto.tenantId) && Objects.equals(this.userOperationId, historicDetailDto.userOperationId) && Objects.equals(this.time, historicDetailDto.time) && Objects.equals(this.removalTime, historicDetailDto.removalTime) && Objects.equals(this.rootProcessInstanceId, historicDetailDto.rootProcessInstanceId) && Objects.equals(this.fieldId, historicDetailDto.fieldId) && Objects.equals(this.fieldValue, historicDetailDto.fieldValue) && Objects.equals(this.variableName, historicDetailDto.variableName) && Objects.equals(this.variableInstanceId, historicDetailDto.variableInstanceId) && Objects.equals(this.variableType, historicDetailDto.variableType) && Objects.equals(this.value, historicDetailDto.value) && Objects.equals(this.valueInfo, historicDetailDto.valueInfo) && Objects.equals(this.initial, historicDetailDto.initial) && Objects.equals(this.revision, historicDetailDto.revision) && Objects.equals(this.errorMessage, historicDetailDto.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.processDefinitionKey, this.processDefinitionId, this.processInstanceId, this.activityInstanceId, this.executionId, this.caseDefinitionKey, this.caseDefinitionId, this.caseInstanceId, this.caseExecutionId, this.taskId, this.tenantId, this.userOperationId, this.time, this.removalTime, this.rootProcessInstanceId, this.fieldId, this.fieldValue, this.variableName, this.variableInstanceId, this.variableType, this.value, this.valueInfo, this.initial, this.revision, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricDetailDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    caseDefinitionKey: ").append(this.toIndentedString(this.caseDefinitionKey)).append("\n");
        sb.append("    caseDefinitionId: ").append(this.toIndentedString(this.caseDefinitionId)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    caseExecutionId: ").append(this.toIndentedString(this.caseExecutionId)).append("\n");
        sb.append("    taskId: ").append(this.toIndentedString(this.taskId)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    userOperationId: ").append(this.toIndentedString(this.userOperationId)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("    fieldId: ").append(this.toIndentedString(this.fieldId)).append("\n");
        sb.append("    fieldValue: ").append(this.toIndentedString(this.fieldValue)).append("\n");
        sb.append("    variableName: ").append(this.toIndentedString(this.variableName)).append("\n");
        sb.append("    variableInstanceId: ").append(this.toIndentedString(this.variableInstanceId)).append("\n");
        sb.append("    variableType: ").append(this.toIndentedString(this.variableType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueInfo: ").append(this.toIndentedString(this.valueInfo)).append("\n");
        sb.append("    initial: ").append(this.toIndentedString(this.initial)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

