/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.MultipleProcessInstanceModificationInstructionDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;

public class ModificationDto {
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
    @SerializedName(value="skipCustomListeners")
    private Boolean skipCustomListeners;
    public static final String SERIALIZED_NAME_SKIP_IO_MAPPINGS = "skipIoMappings";
    @SerializedName(value="skipIoMappings")
    private Boolean skipIoMappings;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
    @SerializedName(value="processInstanceQuery")
    private ProcessInstanceQueryDto processInstanceQuery;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    private List<MultipleProcessInstanceModificationInstructionDto> instructions = null;
    public static final String SERIALIZED_NAME_ANNOTATION = "annotation";
    @SerializedName(value="annotation")
    private String annotation;

    public ModificationDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition for the modification")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ModificationDto skipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution listener invocation for activities that are started or ended as part of this request.")
    public Boolean getSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public void setSkipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public ModificationDto skipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started or ended as part of this request.")
    public Boolean getSkipIoMappings() {
        return this.skipIoMappings;
    }

    public void setSkipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
    }

    public ModificationDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public ModificationDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of process instance ids to modify.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public ModificationDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public ModificationDto instructions(List<MultipleProcessInstanceModificationInstructionDto> instructions) {
        this.instructions = instructions;
        return this;
    }

    public ModificationDto addInstructionsItem(MultipleProcessInstanceModificationInstructionDto instructionsItem) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<MultipleProcessInstanceModificationInstructionDto>();
        }
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of modification instructions. The instructions are executed in the order they are in. ")
    public List<MultipleProcessInstanceModificationInstructionDto> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<MultipleProcessInstanceModificationInstructionDto> instructions) {
        this.instructions = instructions;
    }

    public ModificationDto annotation(String annotation) {
        this.annotation = annotation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary text annotation set by a user for auditing reasons.")
    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModificationDto modificationDto = (ModificationDto)o;
        return Objects.equals(this.processDefinitionId, modificationDto.processDefinitionId) && Objects.equals(this.skipCustomListeners, modificationDto.skipCustomListeners) && Objects.equals(this.skipIoMappings, modificationDto.skipIoMappings) && Objects.equals(this.processInstanceIds, modificationDto.processInstanceIds) && Objects.equals(this.processInstanceQuery, modificationDto.processInstanceQuery) && Objects.equals(this.instructions, modificationDto.instructions) && Objects.equals(this.annotation, modificationDto.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionId, this.skipCustomListeners, this.skipIoMappings, this.processInstanceIds, this.processInstanceQuery, this.instructions, this.annotation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModificationDto {\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    skipCustomListeners: ").append(this.toIndentedString(this.skipCustomListeners)).append("\n");
        sb.append("    skipIoMappings: ").append(this.toIndentedString(this.skipIoMappings)).append("\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    processInstanceQuery: ").append(this.toIndentedString(this.processInstanceQuery)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    annotation: ").append(this.toIndentedString(this.annotation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

