/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.AtomLink;

public class ProcessInstanceDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_DEFINITION_ID = "definitionId";
    @SerializedName(value="definitionId")
    private String definitionId;
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_ENDED = "ended";
    @SerializedName(value="ended")
    private Boolean ended;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private List<AtomLink> links = null;

    public ProcessInstanceDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ProcessInstanceDto definitionId(String definitionId) {
        this.definitionId = definitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition that this process instance belongs to.")
    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public ProcessInstanceDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The business key of the process instance.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public ProcessInstanceDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case instance associated with the process instance.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public ProcessInstanceDto ended(Boolean ended) {
        this.ended = ended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether the process instance has ended or not. Deprecated: will always be false!")
    public Boolean getEnded() {
        return this.ended;
    }

    public void setEnded(Boolean ended) {
        this.ended = ended;
    }

    public ProcessInstanceDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A flag indicating whether the process instance is suspended or not.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public ProcessInstanceDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the process instance.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public ProcessInstanceDto links(List<AtomLink> links) {
        this.links = links;
        return this;
    }

    public ProcessInstanceDto addLinksItem(AtomLink linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<AtomLink>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The links associated to this resource, with `method`, `href` and `rel`.")
    public List<AtomLink> getLinks() {
        return this.links;
    }

    public void setLinks(List<AtomLink> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceDto processInstanceDto = (ProcessInstanceDto)o;
        return Objects.equals(this.id, processInstanceDto.id) && Objects.equals(this.definitionId, processInstanceDto.definitionId) && Objects.equals(this.businessKey, processInstanceDto.businessKey) && Objects.equals(this.caseInstanceId, processInstanceDto.caseInstanceId) && Objects.equals(this.ended, processInstanceDto.ended) && Objects.equals(this.suspended, processInstanceDto.suspended) && Objects.equals(this.tenantId, processInstanceDto.tenantId) && Objects.equals(this.links, processInstanceDto.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.definitionId, this.businessKey, this.caseInstanceId, this.ended, this.suspended, this.tenantId, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessInstanceDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    definitionId: ").append(this.toIndentedString(this.definitionId)).append("\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    ended: ").append(this.toIndentedString(this.ended)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

