/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A JSON object with the following properties:")
public class RedeploymentDto {
    public static final String SERIALIZED_NAME_RESOURCE_IDS = "resourceIds";
    @SerializedName(value="resourceIds")
    private List<String> resourceIds = null;
    public static final String SERIALIZED_NAME_RESOURCE_NAMES = "resourceNames";
    @SerializedName(value="resourceNames")
    private List<String> resourceNames = null;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;

    public RedeploymentDto resourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public RedeploymentDto addResourceIdsItem(String resourceIdsItem) {
        if (this.resourceIds == null) {
            this.resourceIds = new ArrayList<String>();
        }
        this.resourceIds.add(resourceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of deployment resource ids to re-deploy.")
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public RedeploymentDto resourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
    }

    public RedeploymentDto addResourceNamesItem(String resourceNamesItem) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(resourceNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of deployment resource names to re-deploy.")
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public RedeploymentDto source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sets the source of the deployment.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedeploymentDto redeploymentDto = (RedeploymentDto)o;
        return Objects.equals(this.resourceIds, redeploymentDto.resourceIds) && Objects.equals(this.resourceNames, redeploymentDto.resourceNames) && Objects.equals(this.source, redeploymentDto.source);
    }

    public int hashCode() {
        return Objects.hash(this.resourceIds, this.resourceNames, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RedeploymentDto {\n");
        sb.append("    resourceIds: ").append(this.toIndentedString(this.resourceIds)).append("\n");
        sb.append("    resourceNames: ").append(this.toIndentedString(this.resourceNames)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

