/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.RestartProcessInstanceModificationInstructionDto;

public class RestartProcessInstanceDto {
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
    @SerializedName(value="processInstanceIds")
    private List<String> processInstanceIds = null;
    public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
    @SerializedName(value="historicProcessInstanceQuery")
    private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;
    public static final String SERIALIZED_NAME_SKIP_CUSTOM_LISTENERS = "skipCustomListeners";
    @SerializedName(value="skipCustomListeners")
    private Boolean skipCustomListeners;
    public static final String SERIALIZED_NAME_SKIP_IO_MAPPINGS = "skipIoMappings";
    @SerializedName(value="skipIoMappings")
    private Boolean skipIoMappings;
    public static final String SERIALIZED_NAME_INITIAL_VARIABLES = "initialVariables";
    @SerializedName(value="initialVariables")
    private Boolean initialVariables;
    public static final String SERIALIZED_NAME_WITHOUT_BUSINESS_KEY = "withoutBusinessKey";
    @SerializedName(value="withoutBusinessKey")
    private Boolean withoutBusinessKey;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    private List<RestartProcessInstanceModificationInstructionDto> instructions = null;

    public RestartProcessInstanceDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    public RestartProcessInstanceDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        this.processInstanceIds.add(processInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of process instance ids to restart.")
    public List<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public RestartProcessInstanceDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public RestartProcessInstanceDto skipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution listener invocation for activities that are started as part of this request.")
    public Boolean getSkipCustomListeners() {
        return this.skipCustomListeners;
    }

    public void setSkipCustomListeners(Boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public RestartProcessInstanceDto skipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip execution of [input/output variable mappings](https://docs.camunda.org/manual/7.20/user-guide/process-engine/variables/#input-output-variable-mapping) for activities that are started as part of this request.")
    public Boolean getSkipIoMappings() {
        return this.skipIoMappings;
    }

    public void setSkipIoMappings(Boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
    }

    public RestartProcessInstanceDto initialVariables(Boolean initialVariables) {
        this.initialVariables = initialVariables;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set the initial set of variables during restart. By default, the last set of variables is used.")
    public Boolean getInitialVariables() {
        return this.initialVariables;
    }

    public void setInitialVariables(Boolean initialVariables) {
        this.initialVariables = initialVariables;
    }

    public RestartProcessInstanceDto withoutBusinessKey(Boolean withoutBusinessKey) {
        this.withoutBusinessKey = withoutBusinessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Do not take over the business key of the historic process instance.")
    public Boolean getWithoutBusinessKey() {
        return this.withoutBusinessKey;
    }

    public void setWithoutBusinessKey(Boolean withoutBusinessKey) {
        this.withoutBusinessKey = withoutBusinessKey;
    }

    public RestartProcessInstanceDto instructions(List<RestartProcessInstanceModificationInstructionDto> instructions) {
        this.instructions = instructions;
        return this;
    }

    public RestartProcessInstanceDto addInstructionsItem(RestartProcessInstanceModificationInstructionDto instructionsItem) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<RestartProcessInstanceModificationInstructionDto>();
        }
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Optional**. A JSON array of instructions that specify which activities to start the process instance at. If this property is omitted, the process instance starts at its default blank start event.")
    public List<RestartProcessInstanceModificationInstructionDto> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<RestartProcessInstanceModificationInstructionDto> instructions) {
        this.instructions = instructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestartProcessInstanceDto restartProcessInstanceDto = (RestartProcessInstanceDto)o;
        return Objects.equals(this.processInstanceIds, restartProcessInstanceDto.processInstanceIds) && Objects.equals(this.historicProcessInstanceQuery, restartProcessInstanceDto.historicProcessInstanceQuery) && Objects.equals(this.skipCustomListeners, restartProcessInstanceDto.skipCustomListeners) && Objects.equals(this.skipIoMappings, restartProcessInstanceDto.skipIoMappings) && Objects.equals(this.initialVariables, restartProcessInstanceDto.initialVariables) && Objects.equals(this.withoutBusinessKey, restartProcessInstanceDto.withoutBusinessKey) && Objects.equals(this.instructions, restartProcessInstanceDto.instructions);
    }

    public int hashCode() {
        return Objects.hash(this.processInstanceIds, this.historicProcessInstanceQuery, this.skipCustomListeners, this.skipIoMappings, this.initialVariables, this.withoutBusinessKey, this.instructions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestartProcessInstanceDto {\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    historicProcessInstanceQuery: ").append(this.toIndentedString(this.historicProcessInstanceQuery)).append("\n");
        sb.append("    skipCustomListeners: ").append(this.toIndentedString(this.skipCustomListeners)).append("\n");
        sb.append("    skipIoMappings: ").append(this.toIndentedString(this.skipIoMappings)).append("\n");
        sb.append("    initialVariables: ").append(this.toIndentedString(this.initialVariables)).append("\n");
        sb.append("    withoutBusinessKey: ").append(this.toIndentedString(this.withoutBusinessKey)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

