/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;

public class SetRemovalTimeToHistoricProcessInstancesDto {
    public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_IDS = "historicProcessInstanceIds";
    @SerializedName(value="historicProcessInstanceIds")
    private List<String> historicProcessInstanceIds = null;
    public static final String SERIALIZED_NAME_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
    @SerializedName(value="historicProcessInstanceQuery")
    private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;
    public static final String SERIALIZED_NAME_HIERARCHICAL = "hierarchical";
    @SerializedName(value="hierarchical")
    private Boolean hierarchical;
    public static final String SERIALIZED_NAME_UPDATE_IN_CHUNKS = "updateInChunks";
    @SerializedName(value="updateInChunks")
    private Boolean updateInChunks;
    public static final String SERIALIZED_NAME_UPDATE_CHUNK_SIZE = "updateChunkSize";
    @SerializedName(value="updateChunkSize")
    private Integer updateChunkSize;
    public static final String SERIALIZED_NAME_ABSOLUTE_REMOVAL_TIME = "absoluteRemovalTime";
    @SerializedName(value="absoluteRemovalTime")
    private Date absoluteRemovalTime;
    public static final String SERIALIZED_NAME_CLEARED_REMOVAL_TIME = "clearedRemovalTime";
    @SerializedName(value="clearedRemovalTime")
    private Boolean clearedRemovalTime;
    public static final String SERIALIZED_NAME_CALCULATED_REMOVAL_TIME = "calculatedRemovalTime";
    @SerializedName(value="calculatedRemovalTime")
    private Boolean calculatedRemovalTime;

    public SetRemovalTimeToHistoricProcessInstancesDto historicProcessInstanceIds(List<String> historicProcessInstanceIds) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
        return this;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto addHistoricProcessInstanceIdsItem(String historicProcessInstanceIdsItem) {
        if (this.historicProcessInstanceIds == null) {
            this.historicProcessInstanceIds = new ArrayList<String>();
        }
        this.historicProcessInstanceIds.add(historicProcessInstanceIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance.")
    public List<String> getHistoricProcessInstanceIds() {
        return this.historicProcessInstanceIds;
    }

    public void setHistoricProcessInstanceIds(List<String> historicProcessInstanceIds) {
        this.historicProcessInstanceIds = historicProcessInstanceIds;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto hierarchical(Boolean hierarchical) {
        this.hierarchical = hierarchical;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sets the removal time to all historic process instances in the hierarchy. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getHierarchical() {
        return this.hierarchical;
    }

    public void setHierarchical(Boolean hierarchical) {
        this.hierarchical = hierarchical;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto updateInChunks(Boolean updateInChunks) {
        this.updateInChunks = updateInChunks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Handles removal time updates in chunks, taking into account the defined size in `removalTimeUpdateChunkSize` in the process engine configuration. The size of the  chunks can also be overridden per call with the `updateChunkSize` parameter. Enabling this option can lead to multiple executions of the resulting jobs, preventing the database transaction from timing out by limiting the number of rows to update. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getUpdateInChunks() {
        return this.updateInChunks;
    }

    public void setUpdateInChunks(Boolean updateInChunks) {
        this.updateInChunks = updateInChunks;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto updateChunkSize(Integer updateChunkSize) {
        this.updateChunkSize = updateChunkSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defines the size of the chunks in which removal time updates are processed. The value must be a positive integer between `1` and `500`. This only has an  effect if `updateInChunks` is set to `true`. If undefined, the operation uses the  `removalTimeUpdateChunkSize` defined in the process engine configuration.")
    public Integer getUpdateChunkSize() {
        return this.updateChunkSize;
    }

    public void setUpdateChunkSize(Integer updateChunkSize) {
        this.updateChunkSize = updateChunkSize;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto absoluteRemovalTime(Date absoluteRemovalTime) {
        this.absoluteRemovalTime = absoluteRemovalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date for which the instances shall be removed. Value may not be `null`.  **Note:** Cannot be set in conjunction with `clearedRemovalTime` or `calculatedRemovalTime`.")
    public Date getAbsoluteRemovalTime() {
        return this.absoluteRemovalTime;
    }

    public void setAbsoluteRemovalTime(Date absoluteRemovalTime) {
        this.absoluteRemovalTime = absoluteRemovalTime;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto clearedRemovalTime(Boolean clearedRemovalTime) {
        this.clearedRemovalTime = clearedRemovalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sets the removal time to `null`. Value may only be `true`, as `false` is the default behavior.  **Note:** Cannot be set in conjunction with `absoluteRemovalTime` or `calculatedRemovalTime`.")
    public Boolean getClearedRemovalTime() {
        return this.clearedRemovalTime;
    }

    public void setClearedRemovalTime(Boolean clearedRemovalTime) {
        this.clearedRemovalTime = clearedRemovalTime;
    }

    public SetRemovalTimeToHistoricProcessInstancesDto calculatedRemovalTime(Boolean calculatedRemovalTime) {
        this.calculatedRemovalTime = calculatedRemovalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The removal time is calculated based on the engine's configuration settings. Value may only be `true`, as `false` is the default behavior.  **Note:** Cannot be set in conjunction with `absoluteRemovalTime` or `clearedRemovalTime`.")
    public Boolean getCalculatedRemovalTime() {
        return this.calculatedRemovalTime;
    }

    public void setCalculatedRemovalTime(Boolean calculatedRemovalTime) {
        this.calculatedRemovalTime = calculatedRemovalTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetRemovalTimeToHistoricProcessInstancesDto setRemovalTimeToHistoricProcessInstancesDto = (SetRemovalTimeToHistoricProcessInstancesDto)o;
        return Objects.equals(this.historicProcessInstanceIds, setRemovalTimeToHistoricProcessInstancesDto.historicProcessInstanceIds) && Objects.equals(this.historicProcessInstanceQuery, setRemovalTimeToHistoricProcessInstancesDto.historicProcessInstanceQuery) && Objects.equals(this.hierarchical, setRemovalTimeToHistoricProcessInstancesDto.hierarchical) && Objects.equals(this.updateInChunks, setRemovalTimeToHistoricProcessInstancesDto.updateInChunks) && Objects.equals(this.updateChunkSize, setRemovalTimeToHistoricProcessInstancesDto.updateChunkSize) && Objects.equals(this.absoluteRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.absoluteRemovalTime) && Objects.equals(this.clearedRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.clearedRemovalTime) && Objects.equals(this.calculatedRemovalTime, setRemovalTimeToHistoricProcessInstancesDto.calculatedRemovalTime);
    }

    public int hashCode() {
        return Objects.hash(this.historicProcessInstanceIds, this.historicProcessInstanceQuery, this.hierarchical, this.updateInChunks, this.updateChunkSize, this.absoluteRemovalTime, this.clearedRemovalTime, this.calculatedRemovalTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetRemovalTimeToHistoricProcessInstancesDto {\n");
        sb.append("    historicProcessInstanceIds: ").append(this.toIndentedString(this.historicProcessInstanceIds)).append("\n");
        sb.append("    historicProcessInstanceQuery: ").append(this.toIndentedString(this.historicProcessInstanceQuery)).append("\n");
        sb.append("    hierarchical: ").append(this.toIndentedString(this.hierarchical)).append("\n");
        sb.append("    updateInChunks: ").append(this.toIndentedString(this.updateInChunks)).append("\n");
        sb.append("    updateChunkSize: ").append(this.toIndentedString(this.updateChunkSize)).append("\n");
        sb.append("    absoluteRemovalTime: ").append(this.toIndentedString(this.absoluteRemovalTime)).append("\n");
        sb.append("    clearedRemovalTime: ").append(this.toIndentedString(this.clearedRemovalTime)).append("\n");
        sb.append("    calculatedRemovalTime: ").append(this.toIndentedString(this.calculatedRemovalTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

