/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.BatchStatisticsDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.SuspensionStateDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class BatchApi {
    private ApiClient apiClient;

    public BatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BatchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteBatch(String id, Boolean cascade) throws ApiException {
        this.deleteBatch(id, cascade, Collections.emptyMap());
    }

    public void deleteBatch(String id, Boolean cascade, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteBatch");
        }
        String localVarPath = "/batch/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("cascade", cascade));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public BatchDto getBatch(String id) throws ApiException {
        return this.getBatch(id, Collections.emptyMap());
    }

    public BatchDto getBatch(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getBatch");
        }
        String localVarPath = "/batch/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<BatchDto> localVarReturnType = new TypeReference<BatchDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<BatchStatisticsDto> getBatchStatistics(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        return this.getBatchStatistics(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
    }

    public List<BatchStatisticsDto> getBatchStatistics(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/batch/statistics";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("batchId", batchId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBy", createdBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withFailures", withFailures));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutFailures", withoutFailures));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<BatchStatisticsDto>> localVarReturnType = new TypeReference<List<BatchStatisticsDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getBatchStatisticsCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        return this.getBatchStatisticsCount(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
    }

    public CountResultDto getBatchStatisticsCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/batch/statistics/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("batchId", batchId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBy", createdBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withFailures", withFailures));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutFailures", withoutFailures));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<BatchDto> getBatches(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        return this.getBatches(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
    }

    public List<BatchDto> getBatches(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/batch";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("batchId", batchId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBy", createdBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withFailures", withFailures));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutFailures", withoutFailures));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<BatchDto>> localVarReturnType = new TypeReference<List<BatchDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getBatchesCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures) throws ApiException {
        return this.getBatchesCount(batchId, type, tenantIdIn, withoutTenantId, suspended, createdBy, startedBefore, startedAfter, withFailures, withoutFailures, Collections.emptyMap());
    }

    public CountResultDto getBatchesCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, String createdBy, OffsetDateTime startedBefore, OffsetDateTime startedAfter, Boolean withFailures, Boolean withoutFailures, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/batch/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("batchId", batchId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("suspended", suspended));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBy", createdBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withFailures", withFailures));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutFailures", withoutFailures));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateBatchSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        this.updateBatchSuspensionState(id, suspensionStateDto, Collections.emptyMap());
    }

    public void updateBatchSuspensionState(String id, SuspensionStateDto suspensionStateDto, Map<String, String> additionalHeaders) throws ApiException {
        SuspensionStateDto localVarPostBody = suspensionStateDto;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateBatchSuspensionState");
        }
        String localVarPath = "/batch/{id}/suspended".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }
}

