/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CleanableHistoricProcessInstanceReportResultDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.HistoricActivityStatisticsDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class HistoricProcessDefinitionApi {
    private ApiClient apiClient;

    public HistoricProcessDefinitionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricProcessDefinitionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        return this.getCleanableHistoricProcessInstanceReport(processDefinitionIdIn, processDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, sortBy, sortOrder, firstResult, maxResults, Collections.emptyMap());
    }

    public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/process-definition/cleanable-process-instance-report";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("compact", compact));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<CleanableHistoricProcessInstanceReportResultDto>> localVarReturnType = new TypeReference<List<CleanableHistoricProcessInstanceReportResultDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getCleanableHistoricProcessInstanceReportCount(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact) throws ApiException {
        return this.getCleanableHistoricProcessInstanceReportCount(processDefinitionIdIn, processDefinitionKeyIn, tenantIdIn, withoutTenantId, compact, Collections.emptyMap());
    }

    public CountResultDto getCleanableHistoricProcessInstanceReportCount(String processDefinitionIdIn, String processDefinitionKeyIn, String tenantIdIn, Boolean withoutTenantId, Boolean compact, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/process-definition/cleanable-process-instance-report/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionIdIn", processDefinitionIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("compact", compact));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(String id, Boolean canceled, Boolean finished, Boolean completeScope, Boolean incidents, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String processInstanceIdIn, String sortBy, String sortOrder) throws ApiException {
        return this.getHistoricActivityStatistics(id, canceled, finished, completeScope, incidents, startedBefore, startedAfter, finishedBefore, finishedAfter, processInstanceIdIn, sortBy, sortOrder, Collections.emptyMap());
    }

    public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(String id, Boolean canceled, Boolean finished, Boolean completeScope, Boolean incidents, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String processInstanceIdIn, String sortBy, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricActivityStatistics");
        }
        String localVarPath = "/history/process-definition/{id}/statistics".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("canceled", canceled));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finished", finished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("completeScope", completeScope));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("incidents", incidents));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedBefore", finishedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedAfter", finishedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<HistoricActivityStatisticsDto>> localVarReturnType = new TypeReference<List<HistoricActivityStatisticsDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

