/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.SchemaLogQueryDtoSortingInner;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"version", "sorting"})
public class SchemaLogQueryDto {
    public static final String JSON_PROPERTY_VERSION = "version";
    private JsonNullable<String> version = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SORTING = "sorting";
    private JsonNullable<List<SchemaLogQueryDtoSortingInner>> sorting = JsonNullable.undefined();

    public SchemaLogQueryDto version(String version) {
        this.version = JsonNullable.of((Object)version);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getVersion() {
        return (String)this.version.orElse(null);
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getVersion_JsonNullable() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion_JsonNullable(JsonNullable<String> version) {
        this.version = version;
    }

    public void setVersion(String version) {
        this.version = JsonNullable.of((Object)version);
    }

    public SchemaLogQueryDto sorting(List<SchemaLogQueryDtoSortingInner> sorting) {
        this.sorting = JsonNullable.of(sorting);
        return this;
    }

    public SchemaLogQueryDto addSortingItem(SchemaLogQueryDtoSortingInner sortingItem) {
        if (this.sorting == null || !this.sorting.isPresent()) {
            this.sorting = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.sorting.get()).add(sortingItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<SchemaLogQueryDtoSortingInner> getSorting() {
        return (List)this.sorting.orElse(null);
    }

    @JsonProperty(value="sorting")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<SchemaLogQueryDtoSortingInner>> getSorting_JsonNullable() {
        return this.sorting;
    }

    @JsonProperty(value="sorting")
    public void setSorting_JsonNullable(JsonNullable<List<SchemaLogQueryDtoSortingInner>> sorting) {
        this.sorting = sorting;
    }

    public void setSorting(List<SchemaLogQueryDtoSortingInner> sorting) {
        this.sorting = JsonNullable.of(sorting);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaLogQueryDto schemaLogQueryDto = (SchemaLogQueryDto)o;
        return SchemaLogQueryDto.equalsNullable(this.version, schemaLogQueryDto.version) && SchemaLogQueryDto.equalsNullable(this.sorting, schemaLogQueryDto.sorting);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(SchemaLogQueryDto.hashCodeNullable(this.version), SchemaLogQueryDto.hashCodeNullable(this.sorting));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaLogQueryDto {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getVersion() != null) {
            try {
                joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getVersion()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSorting() != null) {
            for (int i = 0; i < this.getSorting().size(); ++i) {
                if (this.getSorting().get(i) == null) continue;
                joiner.add(this.getSorting().get(i).toUrlQueryString(String.format("%ssorting%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

