/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ExternalTaskQueryDto;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"retries", "externalTaskIds", "processInstanceIds", "externalTaskQuery", "processInstanceQuery", "historicProcessInstanceQuery"})
public class SetRetriesForExternalTasksDto {
    public static final String JSON_PROPERTY_RETRIES = "retries";
    private JsonNullable<Integer> retries = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTERNAL_TASK_IDS = "externalTaskIds";
    private JsonNullable<List<String>> externalTaskIds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_IDS = "processInstanceIds";
    private JsonNullable<List<String>> processInstanceIds = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXTERNAL_TASK_QUERY = "externalTaskQuery";
    private ExternalTaskQueryDto externalTaskQuery;
    public static final String JSON_PROPERTY_PROCESS_INSTANCE_QUERY = "processInstanceQuery";
    private ProcessInstanceQueryDto processInstanceQuery;
    public static final String JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY = "historicProcessInstanceQuery";
    private HistoricProcessInstanceQueryDto historicProcessInstanceQuery;

    public SetRetriesForExternalTasksDto retries(Integer retries) {
        this.retries = JsonNullable.of((Object)retries);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Integer getRetries() {
        return (Integer)this.retries.orElse(null);
    }

    @JsonProperty(value="retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Integer> getRetries_JsonNullable() {
        return this.retries;
    }

    @JsonProperty(value="retries")
    public void setRetries_JsonNullable(JsonNullable<Integer> retries) {
        this.retries = retries;
    }

    public void setRetries(Integer retries) {
        this.retries = JsonNullable.of((Object)retries);
    }

    public SetRetriesForExternalTasksDto externalTaskIds(List<String> externalTaskIds) {
        this.externalTaskIds = JsonNullable.of(externalTaskIds);
        return this;
    }

    public SetRetriesForExternalTasksDto addExternalTaskIdsItem(String externalTaskIdsItem) {
        if (this.externalTaskIds == null || !this.externalTaskIds.isPresent()) {
            this.externalTaskIds = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.externalTaskIds.get()).add(externalTaskIdsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getExternalTaskIds() {
        return (List)this.externalTaskIds.orElse(null);
    }

    @JsonProperty(value="externalTaskIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getExternalTaskIds_JsonNullable() {
        return this.externalTaskIds;
    }

    @JsonProperty(value="externalTaskIds")
    public void setExternalTaskIds_JsonNullable(JsonNullable<List<String>> externalTaskIds) {
        this.externalTaskIds = externalTaskIds;
    }

    public void setExternalTaskIds(List<String> externalTaskIds) {
        this.externalTaskIds = JsonNullable.of(externalTaskIds);
    }

    public SetRetriesForExternalTasksDto processInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = JsonNullable.of(processInstanceIds);
        return this;
    }

    public SetRetriesForExternalTasksDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
        if (this.processInstanceIds == null || !this.processInstanceIds.isPresent()) {
            this.processInstanceIds = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.processInstanceIds.get()).add(processInstanceIdsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getProcessInstanceIds() {
        return (List)this.processInstanceIds.orElse(null);
    }

    @JsonProperty(value="processInstanceIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getProcessInstanceIds_JsonNullable() {
        return this.processInstanceIds;
    }

    @JsonProperty(value="processInstanceIds")
    public void setProcessInstanceIds_JsonNullable(JsonNullable<List<String>> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = JsonNullable.of(processInstanceIds);
    }

    public SetRetriesForExternalTasksDto externalTaskQuery(ExternalTaskQueryDto externalTaskQuery) {
        this.externalTaskQuery = externalTaskQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="externalTaskQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExternalTaskQueryDto getExternalTaskQuery() {
        return this.externalTaskQuery;
    }

    @JsonProperty(value="externalTaskQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalTaskQuery(ExternalTaskQueryDto externalTaskQuery) {
        this.externalTaskQuery = externalTaskQuery;
    }

    public SetRetriesForExternalTasksDto processInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="processInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessInstanceQueryDto getProcessInstanceQuery() {
        return this.processInstanceQuery;
    }

    @JsonProperty(value="processInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessInstanceQuery(ProcessInstanceQueryDto processInstanceQuery) {
        this.processInstanceQuery = processInstanceQuery;
    }

    public SetRetriesForExternalTasksDto historicProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="historicProcessInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HistoricProcessInstanceQueryDto getHistoricProcessInstanceQuery() {
        return this.historicProcessInstanceQuery;
    }

    @JsonProperty(value="historicProcessInstanceQuery")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHistoricProcessInstanceQuery(HistoricProcessInstanceQueryDto historicProcessInstanceQuery) {
        this.historicProcessInstanceQuery = historicProcessInstanceQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetRetriesForExternalTasksDto setRetriesForExternalTasksDto = (SetRetriesForExternalTasksDto)o;
        return SetRetriesForExternalTasksDto.equalsNullable(this.retries, setRetriesForExternalTasksDto.retries) && SetRetriesForExternalTasksDto.equalsNullable(this.externalTaskIds, setRetriesForExternalTasksDto.externalTaskIds) && SetRetriesForExternalTasksDto.equalsNullable(this.processInstanceIds, setRetriesForExternalTasksDto.processInstanceIds) && Objects.equals(this.externalTaskQuery, setRetriesForExternalTasksDto.externalTaskQuery) && Objects.equals(this.processInstanceQuery, setRetriesForExternalTasksDto.processInstanceQuery) && Objects.equals(this.historicProcessInstanceQuery, setRetriesForExternalTasksDto.historicProcessInstanceQuery);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(SetRetriesForExternalTasksDto.hashCodeNullable(this.retries), SetRetriesForExternalTasksDto.hashCodeNullable(this.externalTaskIds), SetRetriesForExternalTasksDto.hashCodeNullable(this.processInstanceIds), this.externalTaskQuery, this.processInstanceQuery, this.historicProcessInstanceQuery);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetRetriesForExternalTasksDto {\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    externalTaskIds: ").append(this.toIndentedString(this.externalTaskIds)).append("\n");
        sb.append("    processInstanceIds: ").append(this.toIndentedString(this.processInstanceIds)).append("\n");
        sb.append("    externalTaskQuery: ").append(this.toIndentedString(this.externalTaskQuery)).append("\n");
        sb.append("    processInstanceQuery: ").append(this.toIndentedString(this.processInstanceQuery)).append("\n");
        sb.append("    historicProcessInstanceQuery: ").append(this.toIndentedString(this.historicProcessInstanceQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRetries() != null) {
            try {
                joiner.add(String.format("%sretries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRetries()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getExternalTaskIds() != null) {
            for (i = 0; i < this.getExternalTaskIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sexternalTaskIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getExternalTaskIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getProcessInstanceIds() != null) {
            for (i = 0; i < this.getProcessInstanceIds().size(); ++i) {
                try {
                    joiner.add(String.format("%sprocessInstanceIds%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getProcessInstanceIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getExternalTaskQuery() != null) {
            joiner.add(this.getExternalTaskQuery().toUrlQueryString(prefix + JSON_PROPERTY_EXTERNAL_TASK_QUERY + suffix));
        }
        if (this.getProcessInstanceQuery() != null) {
            joiner.add(this.getProcessInstanceQuery().toUrlQueryString(prefix + JSON_PROPERTY_PROCESS_INSTANCE_QUERY + suffix));
        }
        if (this.getHistoricProcessInstanceQuery() != null) {
            joiner.add(this.getHistoricProcessInstanceQuery().toUrlQueryString(prefix + JSON_PROPERTY_HISTORIC_PROCESS_INSTANCE_QUERY + suffix));
        }
        return joiner.toString();
    }
}

