package org.checkerframework.checker.index.qual;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import org.checkerframework.framework.qual.*;

/**
 * The annotated expressios evaluates to a value that is a sequence, and that sequence has the same
 * length as the given sequences. For example, if {@code b}'s type is annotated with
 * {@code @SameLen("a")}, then {@code a} and {@code b} have the same length.
 *
 * @checker_framework.manual #index-checker Index Checker
 */
@SubtypeOf(SameLenUnknown.class)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
public @interface SameLen {
    /** A list of other sequences with the same length. */
    String[] value();
}
