/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.Chromattic;
import org.chromattic.api.format.DefaultObjectFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChromatticBuilder {
    public static final Option<Boolean> USE_SYSTEM_PROPERTIES = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.use_system_properties", "use system properties");
    public static final Option<String> INSTRUMENTOR_CLASSNAME = new Option(Option.Type.STRING, "org.chromattic.api.Option.instrumentor.classname", "intrumentor");
    public static final Option<String> SESSION_LIFECYCLE_CLASSNAME = new Option(Option.Type.STRING, "org.chromattic.api.Option.session_lifecycle.classname", "session life cycle");
    public static final Option<String> OBJECT_FORMATTER_CLASSNAME = new Option(Option.Type.STRING, "org.chromattic.api.Option.object_formatter.classname", "object formatter");
    public static final Option<Boolean> CACHE_STATE_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.cache.state.enabled", "cache state enabled");
    public static final Option<Boolean> JCR_OPTIMIZE_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.optimize.jcr.enabled", "jcr optmisation enabled");
    public static final Option<Boolean> JCR_OPTIMIZE_HAS_PROPERTY_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.optimize.jcr.has_property.enabled", "jcr has property optimization enabled");
    public static final Option<Boolean> JCR_OPTIMIZE_HAS_NODE_ENABLED = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.optimize.jcr.has_node.enabled", "jcr has node optimization enabled");
    public static final Option<String> ROOT_NODE_PATH = new Option(Option.Type.STRING, "org.chromattic.api.Option.root_node.path", "the root node path value");
    public static final Option<Boolean> CREATE_ROOT_NODE = new Option(Option.Type.BOOLEAN, "org.chromattic.api.Option.root_node.create", "creates the chromattic root node when it does not exist");
    private static final Set<Option> systemOptions = Collections.unmodifiableSet(new HashSet<Option>(Arrays.asList(CACHE_STATE_ENABLED, JCR_OPTIMIZE_ENABLED, JCR_OPTIMIZE_HAS_PROPERTY_ENABLED, JCR_OPTIMIZE_HAS_NODE_ENABLED)));
    private final Set<Class<?>> classes = new HashSet();
    private final Options options = new Options();

    public static Set<Option> getSystemOptions() {
        return systemOptions;
    }

    public static ChromatticBuilder create() {
        String builderClassName = "org.chromattic.core.api.ChromatticBuilderImpl";
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(builderClassName);
            if (ChromatticBuilder.class.isAssignableFrom(clazz)) {
                Class<ChromatticBuilder> builderClass = clazz.asSubclass(ChromatticBuilder.class);
                return builderClass.newInstance();
            }
            throw new BuilderException("Instrumentor class " + builderClassName + " does not extends the " + ChromatticBuilder.class.getName() + " class");
        }
        catch (InstantiationException e) {
            throw new BuilderException("Could not instanciate builder " + builderClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new BuilderException("Could not instanciate builder " + builderClassName, e);
        }
        catch (ClassNotFoundException e) {
            throw new BuilderException("Could not load builder class " + builderClassName, e);
        }
    }

    public Option.Instance<?> getOptionInstance(String name) throws NullPointerException {
        return this.options.getInstance(name);
    }

    public <D> Option.Instance<D> getOptionInstance(Option<D> option) throws NullPointerException {
        return this.options.getInstance(option);
    }

    public <D> void setOptionStringValue(Option<D> option, String value) throws NullPointerException {
        this.options.setStringValue(option, value, true);
    }

    public <D> void setOptionValue(Option<D> option, D value) throws NullPointerException {
        this.options.setValue(option, value, true);
    }

    public <D> D getOptionValue(Option<D> option) throws NullPointerException {
        return this.options.getValue(option);
    }

    public void add(Class<?> clazz) throws NullPointerException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.classes.add(clazz);
    }

    public Chromattic build() throws Exception {
        Options options = new Options(this.options);
        if (!Boolean.FALSE.equals(options.getValue(USE_SYSTEM_PROPERTIES))) {
            for (Option option : ChromatticBuilder.getSystemOptions()) {
                String value = System.getProperty(option.getName());
                if (value == null) continue;
                options.setStringValue(option, value, false);
            }
        }
        options.setValue(INSTRUMENTOR_CLASSNAME, "org.chromattic.apt.InstrumentorImpl", false);
        options.setValue(SESSION_LIFECYCLE_CLASSNAME, "org.chromattic.exo.ExoSessionLifeCycle", false);
        options.setValue(OBJECT_FORMATTER_CLASSNAME, DefaultObjectFormatter.class.getName(), false);
        options.setValue(CACHE_STATE_ENABLED, false, false);
        options.setValue(JCR_OPTIMIZE_HAS_PROPERTY_ENABLED, false, false);
        options.setValue(JCR_OPTIMIZE_HAS_NODE_ENABLED, false, false);
        options.setValue(ROOT_NODE_PATH, "/", false);
        options.setValue(CREATE_ROOT_NODE, false, false);
        return this.boot(options, new HashSet<Class>(this.classes));
    }

    protected abstract Chromattic boot(Options var1, Set<Class> var2) throws BuilderException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Options {
        protected final Map<String, Option.Instance<?>> entries = new HashMap();

        private Options() {
        }

        private Options(Options that) {
            this.entries.putAll(that.entries);
        }

        public Option.Instance<?> getInstance(String name) throws NullPointerException {
            if (name == null) {
                throw new NullPointerException();
            }
            return this.entries.get(name);
        }

        public <D> Option.Instance<D> getInstance(Option<D> option) throws NullPointerException {
            if (option == null) {
                throw new NullPointerException();
            }
            Option.Instance<?> instance = this.entries.get(option.getName());
            return instance;
        }

        public <D> void setStringValue(Option<D> option, String value, boolean overwrite) throws NullPointerException {
            if (option == null) {
                throw new NullPointerException("Cannot set null option");
            }
            if (value == null) {
                throw new NullPointerException("Cannot set null value");
            }
            this.setValue(option, option.getType().parse(value), overwrite);
        }

        public <D> D getValue(Option<D> option) throws NullPointerException {
            Option.Instance<D> instance = this.getInstance(option);
            return (D)(instance != null ? ((Option.Instance)instance).value : null);
        }

        public <D> void setValue(Option<D> option, D value, boolean overwrite) throws NullPointerException {
            if (option == null) {
                throw new NullPointerException("No null option");
            }
            if (value == null) {
                throw new NullPointerException("No null value");
            }
            if (overwrite || this.entries.get(option.getName()) == null) {
                Option.Instance instance = new Option.Instance(option, value);
                this.entries.put(option.getName(), instance);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Option<D> {
        private final String name;
        private final String displayName;
        private final Type<D> type;

        private Option(Type<D> type, String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
        }

        public Type<D> getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Instance<D> getInstance(String value) {
            D t = this.type.parse(value);
            return t != null ? new Instance(this, t) : null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Instance<D> {
            private final Option<D> option;
            private final D value;

            private Instance(Option<D> option, D value) {
                if (option == null) {
                    throw new NullPointerException("No null option accepted");
                }
                if (value == null) {
                    throw new NullPointerException("No null option value accepted");
                }
                this.option = option;
                this.value = value;
            }

            public Option<D> getOption() {
                return this.option;
            }

            public D getValue() {
                return this.value;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Instance) {
                    Instance that = (Instance)obj;
                    return ((Option)this.option).name.equals(((Option)that.option).name);
                }
                return false;
            }

            public int hashCode() {
                return ((Option)this.option).name.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Type<D> {
            public static final Type<String> STRING = new Type<String>(String.class){

                @Override
                public String doParse(String value) {
                    return value;
                }
            };
            public static final Type<Boolean> BOOLEAN = new Type<Boolean>(Boolean.class){

                @Override
                public Boolean doParse(String value) {
                    return Boolean.valueOf(value);
                }
            };
            private final Class<D> javaType;

            private Type(Class<D> javaType) {
                this.javaType = javaType;
            }

            public final D parse(String value) {
                if (value == null) {
                    throw new NullPointerException("Cannot parse null value");
                }
                return this.doParse(value);
            }

            protected abstract D doParse(String var1);
        }
    }
}

