/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common;

public class PathParser {
    public static boolean parseJCRPath(String jcrPath, Visitor visitor) throws IllegalArgumentException {
        if (jcrPath == null) {
            throw new NullPointerException();
        }
        int length = jcrPath.length();
        if (length == 0) {
            return false;
        }
        boolean absolute = jcrPath.charAt(0) == '/';
        visitor.onStart(absolute);
        if (absolute && length == 1) {
            return true;
        }
        return PathParser.parseJCRRelPath(jcrPath, absolute ? 1 : 0, jcrPath.length(), visitor, true);
    }

    private static boolean parseJCRRelPath(String jcrpath, int start, int end, Visitor visitor, boolean top) {
        int len = end - start;
        if (len <= 0) {
            return false;
        }
        if (len <= 2) {
            if (!PathParser.parseJCRPathElement(jcrpath, start, end, visitor, top)) {
                return false;
            }
        } else {
            int slashPos = jcrpath.lastIndexOf(47, end - 1);
            if (slashPos < start) {
                if (!PathParser.parseJCRPathElement(jcrpath, start, end, visitor, top)) {
                    return false;
                }
            } else {
                if (!PathParser.parseJCRRelPath(jcrpath, start, slashPos, visitor, false)) {
                    return false;
                }
                if (!PathParser.parseJCRPathElement(jcrpath, slashPos + 1, end, visitor, top)) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parseJCRPathElement(String jcrpath, int start, int end, Visitor visitor, boolean last) {
        int len = end - start;
        if (len <= 0) {
            return false;
        }
        if (len == 1) {
            char c = jcrpath.charAt(start);
            if (c == '.') {
                visitor.onDotElement(last);
                return true;
            } else {
                if (!PathParser.isJCROneCharSimpleName(c)) return false;
                visitor.onAtomElement(jcrpath, start, 0, start, 1, last);
            }
            return true;
        } else if (len == 2) {
            char c1 = jcrpath.charAt(start);
            char c2 = jcrpath.charAt(start + 1);
            if (c1 == '.') {
                if (c2 == '.') {
                    visitor.onDotDotElement(last);
                    return true;
                } else {
                    if (!PathParser.isJCROneCharSimpleName(c2)) return false;
                    visitor.onAtomElement(jcrpath, start, 0, start, 2, last);
                }
                return true;
            } else {
                if (!PathParser.isJCROneCharSimpleName(c1)) return false;
                if (c2 != '.' && !PathParser.isJCROneCharSimpleName(c2)) return false;
                visitor.onAtomElement(jcrpath, start, 0, start, 2, last);
            }
            return true;
        } else {
            char c1;
            int prefixPos = start;
            int prefixLen = 0;
            int colonPos = jcrpath.indexOf(58, start + 1);
            if (colonPos != -1) {
                prefixLen = colonPos - prefixPos;
                start = colonPos + 1;
                len = end - start;
            }
            if (!PathParser.isJCRNonSpace(c1 = jcrpath.charAt(start))) {
                return false;
            }
            char c2 = jcrpath.charAt(end - 1);
            if (!PathParser.isJCRNonSpace(c2)) {
                return false;
            }
            for (int i = start; i < end - 2; ++i) {
                char c = jcrpath.charAt(i);
                if (PathParser.isJCRNonSpace(c) || c == ' ') continue;
                return false;
            }
            visitor.onAtomElement(jcrpath, prefixPos, prefixLen, start, len, last);
        }
        return true;
    }

    private static boolean isJCROneCharSimpleName(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '*': 
            case '.': 
            case '/': 
            case ':': 
            case '[': 
            case ']': 
            case '|': {
                return false;
            }
        }
        return !Character.isWhitespace(c);
    }

    private static boolean isJCRNonSpace(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '*': 
            case '/': 
            case ':': 
            case '[': 
            case ']': 
            case '|': {
                return false;
            }
        }
        return !Character.isWhitespace(c);
    }

    public static interface Visitor {
        public void onStart(boolean var1);

        public void onAtomElement(String var1, int var2, int var3, int var4, int var5, boolean var6);

        public void onDotElement(boolean var1);

        public void onDotDotElement(boolean var1);
    }
}

