/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCR {
    public static Iterator<Property> adapt(PropertyIterator iterator) {
        return iterator;
    }

    public static Iterator<Node> adapt(NodeIterator iterator) {
        return iterator;
    }

    public static boolean equals(Node a, Node b) throws RepositoryException {
        boolean equals;
        if (a == b) {
            equals = true;
        } else {
            if (a == null || b == null) {
                return false;
            }
            if (a.getSession() == b.getSession()) {
                try {
                    String aId = a.getUUID();
                    String bId = b.getUUID();
                    equals = aId.equals(bId);
                }
                catch (UnsupportedRepositoryOperationException e) {
                    String aPath = a.getPath();
                    String bPath = b.getPath();
                    equals = aPath.equals(bPath);
                }
            } else {
                equals = false;
            }
        }
        return equals;
    }

    public static boolean hasMixin(Node node, String mixinTypeName) throws RepositoryException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (mixinTypeName == null) {
            throw new NullPointerException();
        }
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            if (!nodeType.getName().equals(mixinTypeName)) continue;
            return true;
        }
        return false;
    }

    public static PropertyDefinition getPropertyDefinition(NodeType nodeType, String propertyName) throws RepositoryException {
        for (PropertyDefinition def : nodeType.getPropertyDefinitions()) {
            if (!def.getName().equals(propertyName)) continue;
            return def;
        }
        return null;
    }

    public static PropertyDefinition getPropertyDefinition(Node node, String propertyName) throws RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDefinition();
        }
        NodeType primaryNodeType = node.getPrimaryNodeType();
        PropertyDefinition def = JCR.getPropertyDefinition(primaryNodeType, propertyName);
        if (def == null) {
            NodeType mixinNodeType;
            NodeType[] arr$ = node.getMixinNodeTypes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (def = JCR.getPropertyDefinition(mixinNodeType = arr$[i$], propertyName)) == null; ++i$) {
            }
        }
        return def;
    }
}

