/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.jcr;

import org.chromattic.common.jcr.PathException;
import org.chromattic.common.jcr.PathVisitor;

class Parser {
    Parser() {
    }

    static void parsePath(PathVisitor visitor, String path, int start, int end) throws PathException {
        int length = end - start;
        if (length > 0) {
            char c = path.charAt(start);
            if (c == '/') {
                if (start + 1 < end) {
                    Parser.parseRelativePath(visitor, path, start + 1, end);
                }
            } else {
                if (c == '[') {
                    throw new UnsupportedOperationException("todo");
                }
                Parser.parseRelativePath(visitor, path, start, end);
            }
        } else {
            Parser.parseRelativePath(visitor, path, start, end);
        }
    }

    static void parseAbsolutePath(PathVisitor visitor, String path, int start, int end) throws PathException {
        int length = end - start;
        if (length == 0) {
            throw new PathException("Invalid absolute empty path");
        }
        char c = path.charAt(start);
        if (c == '/') {
            if (start + 1 < end) {
                Parser.parseRelativePath(visitor, path, start + 1, end);
            }
        } else {
            throw new PathException("Invalid absolute path" + path.substring(start, end));
        }
    }

    static void parseRelativePath(PathVisitor visitor, String s, int start, int end) throws PathException {
        if (start == end) {
            Parser.parsePathSegment(visitor, s, start, end);
        } else {
            int pos = Parser.lastIndexOf(s, '/', start, end);
            if (pos == start) {
                throw new PathException("Cannot parse absolute path" + s.substring(start, end));
            }
            if (pos == end - 1) {
                Parser.parseRelativePath(visitor, s, start, end - 1);
            } else if (pos == -1) {
                if (s.charAt(end - 1) == '/') {
                    Parser.parsePathSegment(visitor, s, start, end - 1);
                } else {
                    Parser.parsePathSegment(visitor, s, start, end);
                }
            } else {
                Parser.parseRelativePath(visitor, s, start, pos);
                if (s.charAt(end - 1) == '/') {
                    Parser.parsePathSegment(visitor, s, pos + 1, end - 1);
                } else {
                    Parser.parsePathSegment(visitor, s, pos + 1, end);
                }
            }
        }
    }

    static void parsePathSegment(PathVisitor visitor, String s, int start, int end) throws PathException {
        int pos;
        int length = end - start;
        if (length == 1) {
            if (s.charAt(start) == '.') {
                visitor.onSelf();
                return;
            }
        } else if (length == 2 && s.charAt(start) == '.' && s.charAt(start + 1) == '.') {
            visitor.onParent();
            return;
        }
        if ((pos = Parser.indexOf(s, '[', start, end)) != -1) {
            Integer numberValue;
            if (pos == end - 1) {
                throw new PathException("Malformed expression " + s.substring(start, end));
            }
            if (s.charAt(end - 1) != ']') {
                throw new PathException("Missing ending ] in expression " + s.substring(start, end));
            }
            String number = s.substring(pos + 1, end - 1);
            try {
                numberValue = Integer.parseInt(number);
                if (numberValue < 0) {
                    throw new PathException("No negative index allowed in expression " + s.substring(start, end));
                }
            }
            catch (NumberFormatException e) {
                throw new PathException("Invalid index in expression " + s.substring(start, end));
            }
            Parser.parseName(visitor, s, start, pos, numberValue);
        } else {
            Parser.parseName(visitor, s, start, end, null);
        }
    }

    private static void parseName(PathVisitor visitor, String s, int start, int end, Integer number) throws PathException {
        int length = end - start;
        if (length > 0 && s.charAt(start) == '{') {
            int curlyBraceIndex = Parser.indexOf(s, '}', start + 1, end);
            if (curlyBraceIndex == -1) {
                throw new PathException("Uri not closed in name value " + s.substring(start, end));
            }
            Parser.validateLocalName(s, curlyBraceIndex + 1, end);
            visitor.onURIPathSegment(s, start + 1, curlyBraceIndex, curlyBraceIndex + 1, end, number);
        } else {
            int colonIndex = Parser.indexOf(s, ':', start, end);
            if (colonIndex != -1) {
                String prefix = s.substring(start, colonIndex);
                Parser.validateLocalName(s, colonIndex + 1, end);
                visitor.onPrefixPathSegment(s, start, colonIndex, colonIndex + 1, end, number);
            } else {
                Parser.validateLocalName(s, start, end);
                visitor.onPathSegment(s, start, end, number);
            }
        }
    }

    private static void validateLocalName(String s, int start, int end) throws PathException {
        int length = end - start;
        if (length - start == 1) {
            if (s.charAt(start) == '.') {
                throw new PathException("'.' is not a valid name");
            }
        } else if (length - start == 2 && s.charAt(start) == '.' && s.charAt(start + 1) == '.') {
            throw new PathException("'..' is not a valid name");
        }
        while (start < end) {
            char c = s.charAt(start);
            if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                if (c == '/' || c == ':' || c == '[' || c == ']' || c == '|' || c == '*') {
                    throw new PathException("Illegal path value " + s.substring(start, end) + "  (char " + c + " at position " + start + " not accepted)");
                }
                ++start;
                continue;
            }
            throw new PathException("Illegal path value " + s.substring(start, end) + "  (char " + c + " at position " + start + " not accepted)");
        }
    }

    private static int indexOf(String s, char c, int start, int end) {
        while (start < end) {
            if (s.charAt(start) == c) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private static int lastIndexOf(String s, char c, int start, int end) {
        while (start < end) {
            int next = end - 1;
            if (s.charAt(next) == c) {
                return next;
            }
            end = next;
        }
        return -1;
    }
}

