/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.PropertyDefinition;
import org.chromattic.api.NoSuchPropertyException;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.JCR;
import org.chromattic.core.ContextState;
import org.chromattic.core.DomainSession;
import org.chromattic.core.ListType;
import org.chromattic.core.bean.SimpleType;
import org.chromattic.core.bean.SimpleValueInfo;
import org.chromattic.core.mapper.TypeMapper;
import org.chromattic.core.mapper.ValueMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentContextState
extends ContextState {
    private final TypeMapper mapper;
    private final String name;
    private final String path;
    private final String id;
    private final Node node;
    private final DomainSession session;

    PersistentContextState(TypeMapper mapper, Node node, DomainSession session) throws RepositoryException {
        super(node.getPrimaryNodeType());
        this.mapper = mapper;
        this.id = node.getUUID();
        this.path = node.getPath();
        this.node = node;
        this.name = node.getName();
        this.session = session;
    }

    @Override
    String getId() {
        return this.id;
    }

    @Override
    String getPath() {
        return this.path;
    }

    @Override
    String getName() {
        return this.name;
    }

    @Override
    void setName(String name) {
        throw new IllegalStateException("Node name are read only");
    }

    @Override
    Node getNode() {
        return this.node;
    }

    @Override
    DomainSession getSession() {
        return this.session;
    }

    @Override
    Status getStatus() {
        return Status.PERSISTENT;
    }

    @Override
    Object getPropertyValue(String propertyName, SimpleValueInfo type) {
        try {
            Value[] values;
            Property property;
            PropertyDefinition def;
            Object value = this.node.hasProperty(propertyName) ? ((def = (property = this.node.getProperty(propertyName)).getDefinition()).isMultiple() ? ((values = property.getValues()).length == 0 ? null : values[0]) : property.getValue()) : null;
            if (value != null) {
                SimpleType st = type != null ? type.getSimpleType() : null;
                return ValueMapper.instance.get((Value)value, st);
            }
            if (type != null && type.isPrimitive()) {
                throw new IllegalStateException("Cannot convert null to primitive type " + (Object)((Object)type.getSimpleType()));
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException((Throwable)e);
        }
    }

    @Override
    <T> T getPropertyValues(String propertyName, SimpleValueInfo simpleType, ListType<T> listType) {
        try {
            Property property;
            PropertyDefinition def;
            Value[] values = this.node.hasProperty(propertyName) ? ((def = (property = this.node.getProperty(propertyName)).getDefinition()).isMultiple() ? property.getValues() : new Value[]{property.getValue()}) : new Value[]{};
            if (listType == ListType.LIST) {
                ArrayList<Object> list = new ArrayList<Object>(values.length);
                for (Value value : values) {
                    Object o = ValueMapper.instance.get(value, simpleType.getSimpleType());
                    list.add(o);
                }
                return (T)list;
            }
            Object array = Array.newInstance((Class)simpleType.getTypeInfo().getType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                Object o = ValueMapper.instance.get(value, simpleType.getSimpleType());
                Array.set(array, i, o);
            }
            return (T)array;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException((Throwable)e);
        }
    }

    @Override
    void setPropertyValue(String propertyName, SimpleValueInfo type, Object o) {
        try {
            int neededType;
            Value value;
            if (o != null) {
                ValueFactory valueFactory = this.session.getJCRSession().getValueFactory();
                SimpleType st = type != null ? type.getSimpleType() : null;
                value = ValueMapper.instance.get(valueFactory, o, st);
            } else {
                value = null;
            }
            PropertyDefinition def = JCR.findPropertyDefinition((Node)this.node, (String)propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            if (value != null && (neededType = def.getRequiredType()) != 0 && neededType != value.getType()) {
                throw new ClassCastException("Cannot cast type " + value.getType() + " to type " + neededType + " when setting property " + propertyName);
            }
            if (def.isMultiple()) {
                if (value == null) {
                    this.node.setProperty(propertyName, new Value[0]);
                } else {
                    this.node.setProperty(propertyName, new Value[]{value});
                }
            } else {
                this.node.setProperty(propertyName, value);
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException((Throwable)e);
        }
    }

    @Override
    <T> void setPropertyValues(String propertyName, SimpleValueInfo type, ListType<T> listType, T objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        try {
            PropertyDefinition def;
            Value[] values;
            SimpleType st;
            ValueFactory valueFactory = this.session.getJCRSession().getValueFactory();
            SimpleType simpleType = st = type != null ? type.getSimpleType() : null;
            if (listType == ListType.LIST) {
                List list = (List)objects;
                values = new Value[list.size()];
                int i = 0;
                for (Object object : list) {
                    values[i++] = ValueMapper.instance.get(valueFactory, object, st);
                }
            } else {
                values = new Value[Array.getLength(objects)];
                for (int i = 0; i < values.length; ++i) {
                    Object o = Array.get(objects, i);
                    values[i] = ValueMapper.instance.get(valueFactory, o, st);
                }
            }
            if ((def = JCR.getPropertyDefinition((Node)this.node, (String)propertyName)).isMultiple()) {
                this.node.setProperty(propertyName, values);
            } else {
                if (values.length > 1) {
                    throw new IllegalArgumentException("Cannot update with an array of length greater than 1");
                }
                if (values.length == 1) {
                    this.node.setProperty(propertyName, values[0]);
                } else {
                    this.node.setProperty(propertyName, (Value)null);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException((Throwable)e);
        }
    }

    public String toString() {
        return "ObjectStatus[id=" + this.id + ",status=" + Status.PERSISTENT + "]";
    }
}

