/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.bean;

import java.lang.annotation.Annotation;
import org.chromattic.core.bean.AccessMode;
import org.reflext.api.AnnotationIntrospector;
import org.reflext.api.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyInfo {
    private final String name;
    private final MethodInfo getter;
    private final MethodInfo setter;

    public PropertyInfo(String name, MethodInfo getter, MethodInfo setter) {
        this.name = name;
        this.getter = getter;
        this.setter = setter;
    }

    public String getName() {
        return this.name;
    }

    public AccessMode getAccessMode() {
        if (this.getter == null) {
            if (this.setter == null) {
                throw new AssertionError((Object)"wtf");
            }
            return AccessMode.WRITE_ONLY;
        }
        if (this.setter == null) {
            return AccessMode.READ_ONLY;
        }
        return AccessMode.READ_WRITE;
    }

    public MethodInfo getGetter() {
        return this.getter;
    }

    public MethodInfo getSetter() {
        return this.setter;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Annotation setterAnnotation;
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        Annotation annotation = null;
        if (this.getter != null) {
            annotation = new AnnotationIntrospector(annotationClass).resolve(this.getter);
        }
        if (this.setter != null && (setterAnnotation = new AnnotationIntrospector(annotationClass).resolve(this.setter)) != null) {
            if (annotation != null) {
                throw new IllegalStateException();
            }
            annotation = setterAnnotation;
        }
        return (A)annotation;
    }

    public String toString() {
        return "Property[name=" + this.name + "]";
    }
}

