/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.util.Set;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.jcr.NodeDef;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.instrument.MethodHandler;
import org.chromattic.spi.instrument.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapper {
    private final Class<?> objectClass;
    private final NodeDef nodeDef;
    final Set<MethodMapper> methodMappers;
    final Set<PropertyMapper> propertyMappers;
    private final ProxyFactory factory;

    public TypeMapper(Class<?> objectClass, Set<PropertyMapper> propertyMappers, Set<MethodMapper> methodMappers, NodeDef nodeDef, Instrumentor instrumentor) {
        this.objectClass = objectClass;
        this.methodMappers = methodMappers;
        this.nodeDef = nodeDef;
        this.propertyMappers = propertyMappers;
        this.factory = instrumentor.getProxyClass(objectClass);
    }

    public Object createObject(ObjectContext context) {
        return this.factory.createProxy((MethodHandler)context);
    }

    public Set<MethodMapper> getMethodMappers() {
        return this.methodMappers;
    }

    public Set<PropertyMapper> getPropertyMappers() {
        return this.propertyMappers;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public NodeDef getNodeDef() {
        return this.nodeDef;
    }

    public String toString() {
        return "TypeMapper[class=" + this.objectClass + ",nodeType=" + this.nodeDef + "]";
    }
}

