/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.PropertyDefinition;
import org.chromattic.api.ChromatticIOException;
import org.chromattic.api.NoSuchPropertyException;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.ListType;
import org.chromattic.core.bean.SimpleType;
import org.chromattic.core.bean.SimpleValueInfo;
import org.chromattic.core.jcr.info.NodeInfo;
import org.chromattic.core.jcr.info.PropertyDefinitionInfo;
import org.chromattic.core.mapper.TypeMapper;
import org.chromattic.core.mapper.ValueMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentEntityContextState
extends EntityContextState {
    private final Node node;
    private final DomainSession session;
    private final Map<String, Object> propertyCache;
    private final NodeInfo nodeInfo;

    PersistentEntityContextState(Node node, DomainSession session) throws RepositoryException {
        this.node = node;
        this.session = session;
        this.propertyCache = session.domain.stateCacheEnabled ? new HashMap() : null;
        this.nodeInfo = session.domain.nodeInfoManager.getNodeInfo(node);
    }

    @Override
    String getId() {
        try {
            return this.node.getUUID();
        }
        catch (UnsupportedRepositoryOperationException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    String getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    String getName() {
        try {
            String external;
            ObjectFormatter formatter = null;
            Node parentNode = this.node.getParent();
            String nodeTypeName = parentNode.getPrimaryNodeType().getName();
            TypeMapper parentMapper = this.session.domain.getTypeMapper(nodeTypeName);
            if (parentMapper != null) {
                formatter = parentMapper.getFormatter();
            }
            if (formatter == null) {
                formatter = this.session.domain.objectFormatter;
            }
            String internalName = this.node.getName();
            try {
                external = formatter.decodeNodeName(null, internalName);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new UndeclaredThrowableException(e);
            }
            if (external == null) {
                throw new IllegalStateException("Null name returned by decoder");
            }
            return external;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    void setName(String name) {
        throw new IllegalStateException("Node name are read only");
    }

    @Override
    Node getNode() {
        return this.node;
    }

    @Override
    DomainSession getSession() {
        return this.session;
    }

    @Override
    Status getStatus() {
        return Status.PERSISTENT;
    }

    @Override
    <V> V getPropertyValue(String propertyName, SimpleValueInfo<V> svi) {
        try {
            Object value = null;
            if (this.propertyCache != null) {
                value = this.propertyCache.get(propertyName);
            }
            if (value == null) {
                Value[] values;
                PropertyDefinition def;
                Property property = this.session.getSessionWrapper().getProperty(this.node, propertyName);
                Object jcrValue = property != null ? ((def = property.getDefinition()).isMultiple() ? ((values = property.getValues()).length == 0 ? null : values[0]) : property.getValue()) : null;
                if (jcrValue != null) {
                    SimpleType<V> st = svi != null ? svi.getSimpleType() : null;
                    value = ValueMapper.instance.get((Value)jcrValue, st);
                    if (this.propertyCache != null && value instanceof InputStream) {
                        try {
                            value = new CloneableInputStream((InputStream)value);
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
            if (value == null) {
                if (svi != null) {
                    List<V> defaultValue = svi.getDefaultValue();
                    if (defaultValue != null && defaultValue.size() > 0) {
                        value = defaultValue.get(0);
                    }
                    if (value == null && svi.getSimpleType().isPrimitive()) {
                        throw new IllegalStateException("Cannot convert null to primitive type " + svi.getSimpleType());
                    }
                }
            } else if (this.propertyCache != null) {
                if (value instanceof InputStream) {
                    value = ((CloneableInputStream)value).clone();
                } else if (value instanceof Date) {
                    value = ((Date)value).clone();
                }
            }
            return (V)value;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> List<V> getPropertyValues(String propertyName, SimpleValueInfo<V> svi, ListType listType) {
        try {
            PropertyDefinition def;
            Property property = this.session.getSessionWrapper().getProperty(this.node, propertyName);
            Value[] values = property != null ? ((def = property.getDefinition()).isMultiple() ? property.getValues() : new Value[]{property.getValue()}) : new Value[]{};
            List<V> list = listType.create(svi.getSimpleType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                V v = ValueMapper.instance.get(value, svi.getSimpleType());
                list.set(i, v);
            }
            return list;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> void setPropertyValue(String propertyName, SimpleValueInfo<V> svi, V propertyValue) {
        try {
            int neededType;
            Value jcrValue;
            if (this.propertyCache != null && propertyValue instanceof InputStream && propertyValue instanceof CloneableInputStream) {
                try {
                    propertyValue = new CloneableInputStream((InputStream)propertyValue);
                }
                catch (IOException e) {
                    throw new ChromatticIOException("Could not read stream", e);
                }
            }
            if (propertyValue != null) {
                ValueFactory valueFactory = this.session.getJCRSession().getValueFactory();
                SimpleType<V> st = svi != null ? svi.getSimpleType() : null;
                jcrValue = ValueMapper.instance.get(valueFactory, propertyValue, st);
            } else {
                jcrValue = null;
            }
            PropertyDefinitionInfo def = this.nodeInfo.findPropertyDefinition(propertyName);
            if (def == null) {
                throw new NoSuchPropertyException("Property " + propertyName + " cannot be set on node " + this.node.getPath() + "  with type " + this.node.getPrimaryNodeType().getName());
            }
            if (jcrValue != null && (neededType = def.getType()) != 0 && neededType != jcrValue.getType()) {
                throw new ClassCastException("Cannot cast type " + jcrValue.getType() + " to type " + neededType + " when setting property " + propertyName);
            }
            if (def.isMultiple()) {
                if (jcrValue == null) {
                    this.node.setProperty(propertyName, new Value[0]);
                } else {
                    this.node.setProperty(propertyName, new Value[]{jcrValue});
                }
            } else {
                this.node.setProperty(propertyName, jcrValue);
            }
            if (this.propertyCache != null) {
                if (propertyValue != null) {
                    if (propertyValue instanceof InputStream) {
                        CloneableInputStream stream = (CloneableInputStream)propertyValue;
                        propertyValue = stream.clone();
                    } else if (propertyValue instanceof Date) {
                        propertyValue = ((Date)propertyValue).clone();
                    }
                    this.propertyCache.put(propertyName, propertyValue);
                } else {
                    this.propertyCache.remove(propertyName);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    @Override
    <V> void setPropertyValues(String propertyName, SimpleValueInfo<V> svi, ListType listType, List<V> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        try {
            ValueFactory valueFactory = this.session.getJCRSession().getValueFactory();
            SimpleType<V> st = svi != null ? svi.getSimpleType() : null;
            int size = objects.size();
            Value[] values = new Value[size];
            for (int i = 0; i < size; ++i) {
                V element = objects.get(i);
                values[i] = ValueMapper.instance.get(valueFactory, element, st);
            }
            PropertyDefinitionInfo def = this.nodeInfo.getPropertyDefinitionInfo(propertyName);
            if (def.isMultiple()) {
                this.node.setProperty(propertyName, values);
            } else {
                if (values.length > 1) {
                    throw new IllegalArgumentException("Cannot update with an array of length greater than 1");
                }
                if (values.length == 1) {
                    this.node.setProperty(propertyName, values[0]);
                } else {
                    this.node.setProperty(propertyName, (Value)null);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public String toString() {
        return "ObjectStatus[path=" + this.getPath() + ",status=" + Status.PERSISTENT + "]";
    }
}

