/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.jcr.info;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.chromattic.core.jcr.info.MixinTypeInfo;
import org.chromattic.core.jcr.info.NodeInfo;
import org.chromattic.core.jcr.info.NodeTypeInfo;
import org.chromattic.core.jcr.info.TypeInfo;

public class NodeInfoManager {
    private final Object primaryNodeInfosLock = new Object();
    private volatile Map<String, NodeInfo> primaryNodeInfos = new HashMap<String, NodeInfo>();
    private final Object nodeTypeInfosLock = new Object();
    private volatile Map<String, TypeInfo> nodeTypeInfos = new HashMap<String, TypeInfo>();

    public boolean isReferenceable(Node node) throws RepositoryException {
        for (NodeType nt : node.getMixinNodeTypes()) {
            if (!nt.getName().equals("mix:referenceable")) continue;
            return true;
        }
        NodeTypeInfo ntInfo = (NodeTypeInfo)this.getTypeInfo(node.getPrimaryNodeType());
        return ntInfo.getMixinNames().contains("mix:referenceable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeInfo getNodeInfo(Node node) throws RepositoryException {
        NodeType primaryNodeType = node.getPrimaryNodeType();
        String primaryNodeTypeName = primaryNodeType.getName();
        NodeType[] mixinNodeTypes = node.getMixinNodeTypes();
        if (mixinNodeTypes.length == 0 || mixinNodeTypes.length == 1 && mixinNodeTypes[0].getName().equals("mix:referenceable")) {
            NodeInfo nodeInfo = this.primaryNodeInfos.get(primaryNodeTypeName);
            if (nodeInfo == null) {
                Object object = this.primaryNodeInfosLock;
                synchronized (object) {
                    NodeTypeInfo primaryNodeTypeInfo = (NodeTypeInfo)this.getTypeInfo(primaryNodeType);
                    nodeInfo = new NodeInfo(primaryNodeTypeInfo);
                    HashMap<String, NodeInfo> copy = new HashMap<String, NodeInfo>(this.primaryNodeInfos);
                    copy.put(primaryNodeTypeName, nodeInfo);
                    this.primaryNodeInfos = copy;
                }
            }
            return nodeInfo;
        }
        throw new UnsupportedOperationException("todo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeInfo getTypeInfo(NodeType nodeType) {
        String nodeTypeName = nodeType.getName();
        TypeInfo nodeTypeInfo = this.nodeTypeInfos.get(nodeTypeName);
        if (nodeTypeInfo == null) {
            Object object = this.nodeTypeInfosLock;
            synchronized (object) {
                nodeTypeInfo = nodeType.isMixin() ? new MixinTypeInfo(nodeType) : new NodeTypeInfo(nodeType);
                HashMap<String, TypeInfo> copy = new HashMap<String, TypeInfo>(this.nodeTypeInfos);
                copy.put(nodeTypeName, nodeTypeInfo);
                this.nodeTypeInfos = copy;
            }
        }
        return nodeTypeInfo;
    }
}

