/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.common.AbstractFilterIterator;
import org.chromattic.core.DomainSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChildCollectionIterator<T>
extends AbstractFilterIterator<T, Node> {
    private final Class<T> relatedClass;
    private final DomainSession session;
    private Object current;

    public ChildCollectionIterator(DomainSession session, Iterator<Node> iterator, Class<T> relatedClass) throws RepositoryException {
        super(iterator);
        this.session = session;
        this.relatedClass = relatedClass;
    }

    protected T adapt(Node node) {
        Object o = this.session.findByNode(Object.class, node);
        if (this.relatedClass.isInstance(o)) {
            this.current = o;
            return this.relatedClass.cast(o);
        }
        return null;
    }

    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException("No object to remove");
        }
        Object tmp = this.current;
        this.current = null;
        this.session.remove(tmp);
    }
}

