/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.core.jcr.info.NodeInfoManager;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.core.mapper.TypeMapperBuilder;
import org.chromattic.core.mapping.NodeTypeMapping;
import org.chromattic.core.query.QueryManager;
import org.chromattic.spi.instrument.Instrumentor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    private final Map<String, ObjectMapper> typeMapperByNodeType;
    private final Map<Class<?>, ObjectMapper> typeMapperByClass;
    private final Instrumentor instrumentor;
    final ObjectFormatter objectFormatter;
    final boolean stateCacheEnabled;
    final boolean hasPropertyOptimized;
    final boolean hasNodeOptimized;
    final String rootNodePath;
    final NodeInfoManager nodeInfoManager;
    final QueryManager queryManager;

    public Domain(Set<NodeTypeMapping> typeMappings, Instrumentor instrumentor, ObjectFormatter objectFormatter, boolean stateCacheEnabled, boolean hasPropertyOptimized, boolean hasNodeOptimized, String rootNodePath) {
        TypeMapperBuilder builder = new TypeMapperBuilder(typeMappings, instrumentor);
        HashMap<String, ObjectMapper> typeMapperByNodeType = new HashMap<String, ObjectMapper>();
        HashMap typeMapperByClass = new HashMap();
        for (ObjectMapper typeMapper : builder.build()) {
            if (typeMapperByNodeType.containsKey(typeMapper.getNodeTypeName())) {
                throw new IllegalStateException("Duplicate node type name " + typeMapper);
            }
            typeMapperByNodeType.put(typeMapper.getNodeTypeName(), typeMapper);
            typeMapperByClass.put(typeMapper.getObjectClass(), typeMapper);
        }
        this.typeMapperByClass = typeMapperByClass;
        this.typeMapperByNodeType = typeMapperByNodeType;
        this.instrumentor = instrumentor;
        this.objectFormatter = objectFormatter;
        this.stateCacheEnabled = stateCacheEnabled;
        this.hasPropertyOptimized = hasPropertyOptimized;
        this.hasNodeOptimized = hasNodeOptimized;
        this.rootNodePath = rootNodePath;
        this.nodeInfoManager = new NodeInfoManager();
        this.queryManager = new QueryManager();
    }

    public boolean isHasPropertyOptimized() {
        return this.hasPropertyOptimized;
    }

    public boolean isHasNodeOptimized() {
        return this.hasNodeOptimized;
    }

    public Instrumentor getInstrumentor() {
        return this.instrumentor;
    }

    public ObjectMapper getTypeMapper(String nodeTypeName) {
        return this.typeMapperByNodeType.get(nodeTypeName);
    }

    public ObjectMapper getTypeMapper(Class<?> clazz) {
        return this.typeMapperByClass.get(clazz);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }
}

