/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.api;

import javax.jcr.Node;
import javax.jcr.Session;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.core.Domain;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromatticSessionImpl
implements ChromatticSession {
    final DomainSession domainSession;

    public ChromatticSessionImpl(DomainSession domainSession) {
        this.domainSession = domainSession;
    }

    public final Domain getDomain() {
        return this.domainSession.getDomain();
    }

    public final Session getJCRSession() {
        return this.domainSession.getJCRSession();
    }

    public final String getId(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getId();
    }

    public final String getName(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return this.domainSession.getName(ctx);
    }

    public final String getPath(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getPath();
    }

    public final <O> O create(Class<O> clazz) throws NullPointerException, IllegalArgumentException {
        return this.create(clazz, null);
    }

    public final <O> O create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException {
        return this.domainSession.create(clazz, name);
    }

    public final <O> O insert(Object parent, Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
        O child = this.create(clazz);
        EntityContext childtx = this.domainSession.unwrapEntity(child);
        this.domainSession.persist(parentCtx, childtx, name);
        return child;
    }

    public final <O> O insert(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, UndeclaredRepositoryException {
        O child = this.create(clazz);
        this.persist(child, name);
        return child;
    }

    public final String persist(Object parent, Object child, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
        EntityContext childCtx = this.domainSession.unwrapEntity(child);
        return this.domainSession.persist(parentCtx, childCtx, name).getId();
    }

    public final String persist(Object parent, Object child) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext parentCtx = this.domainSession.unwrapEntity(parent);
        EntityContext childCtx = this.domainSession.unwrapEntity(child);
        String name = childCtx.getName();
        if (name == null) {
            String msg = "Attempt to persist non named object " + childCtx;
            throw new IllegalArgumentException(msg);
        }
        return this.domainSession.persist(parentCtx, childCtx, name).getId();
    }

    public final String persist(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        String name = ctx.getName();
        if (name == null) {
            String msg = "Attempt to persist non named object " + ctx;
            throw new IllegalArgumentException(msg);
        }
        return this.domainSession.persist(ctx, name).getId();
    }

    public final String persist(Object o, String relPath) throws NullPointerException, IllegalArgumentException, ChromatticException {
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return this.domainSession.persist(ctx, relPath).getId();
    }

    public final <O> O findByNode(Class<O> clazz, Node node) throws UndeclaredRepositoryException {
        return this.domainSession.findByNode(clazz, node);
    }

    public final <O> O findById(Class<O> clazz, String id) throws UndeclaredRepositoryException {
        return this.domainSession.findById(clazz, id);
    }

    public final <O> O findByPath(Object origin, Class<O> clazz, String relPath) throws ChromatticException {
        if (origin == null) {
            throw new NullPointerException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(origin);
        return this.domainSession.findByPath(ctx, clazz, relPath);
    }

    public final <O> O findByPath(Class<O> clazz, String relPath) throws ChromatticException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        return this.domainSession.findByPath(null, clazz, relPath);
    }

    public final void save() throws UndeclaredRepositoryException {
        this.domainSession.save();
    }

    public final Status getStatus(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getStatus();
    }

    public final void remove(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext context = this.domainSession.unwrapEntity(o);
        this.domainSession.remove(context);
    }

    public void close() {
        this.domainSession.close();
    }

    public QueryBuilder<?> createQueryBuilder() throws ChromatticException {
        return this.domainSession.createQueryBuilder();
    }

    public void addEventListener(EventListener listener) {
        this.domainSession.addEventListener(listener);
    }

    public Node getRoot() {
        return this.domainSession.getRoot();
    }

    public Node getNode(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        EntityContext ctx = this.domainSession.unwrapEntity(o);
        return ctx.getNode();
    }
}

