/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.chromattic.core.bean.BaseSimpleTypes;
import org.chromattic.core.bean.SimpleType;
import org.chromattic.core.bean.SimpleTypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMapper {
    public static final ValueMapper instance = new ValueMapper();

    private ValueMapper() {
    }

    public final <E> E get(Value value, SimpleType<E> wantedType) throws RepositoryException {
        int propertyType = value.getType();
        if (wantedType != null) {
            SimpleTypeKind<E, ?> typeKind = wantedType.getKind();
            if (typeKind instanceof SimpleTypeKind.STREAM) {
                SimpleTypeKind.STREAM streamKind = (SimpleTypeKind.STREAM)typeKind;
                if (propertyType == 2) {
                    return streamKind.toExternal(value.getStream());
                }
                throw new ClassCastException();
            }
            if (typeKind instanceof SimpleTypeKind.STRING) {
                SimpleTypeKind.STRING stringKind = (SimpleTypeKind.STRING)typeKind;
                if (propertyType == 1 || propertyType == 7 || propertyType == 8) {
                    return stringKind.toExternal(value.getString());
                }
                throw new ClassCastException();
            }
            if (typeKind instanceof SimpleTypeKind.PATH) {
                SimpleTypeKind.PATH pathKind = (SimpleTypeKind.PATH)typeKind;
                if (propertyType == 8) {
                    return pathKind.toExternal(value.getString());
                }
                throw new ClassCastException();
            }
            if (typeKind instanceof SimpleTypeKind.LONG) {
                SimpleTypeKind.LONG longKind = (SimpleTypeKind.LONG)typeKind;
                if (propertyType == 3) {
                    return longKind.toExternal(value.getLong());
                }
                throw new ClassCastException();
            }
            if (typeKind instanceof SimpleTypeKind.DOUBLE) {
                SimpleTypeKind.DOUBLE doubleKind = (SimpleTypeKind.DOUBLE)typeKind;
                if (propertyType == 4) {
                    return doubleKind.toExternal(value.getDouble());
                }
                throw new ClassCastException();
            }
            if (typeKind instanceof SimpleTypeKind.BOOLEAN) {
                SimpleTypeKind.BOOLEAN booleanKind = (SimpleTypeKind.BOOLEAN)typeKind;
                if (propertyType == 6) {
                    return booleanKind.toExternal(value.getBoolean());
                }
                throw new ClassCastException();
            }
            if (typeKind instanceof SimpleTypeKind.DATE) {
                SimpleTypeKind.DATE dateKind = (SimpleTypeKind.DATE)typeKind;
                if (propertyType == 5) {
                    return dateKind.toExternal(value.getDate().getTime());
                }
                throw new ClassCastException();
            }
            throw new AssertionError((Object)("Property type " + propertyType + " not handled"));
        }
        switch (propertyType) {
            case 6: {
                return (E)Boolean.valueOf(value.getBoolean());
            }
            case 3: {
                return (E)Integer.valueOf((int)value.getLong());
            }
            case 4: {
                return (E)Double.valueOf(value.getDouble());
            }
            case 1: 
            case 7: 
            case 8: {
                return (E)value.getString();
            }
            case 2: {
                return (E)value.getStream();
            }
            case 5: {
                return (E)value.getDate().getTime();
            }
        }
        throw new AssertionError((Object)("Property type " + propertyType + " not handled"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <E> Value get(ValueFactory valueFactory, E o, SimpleType<E> type) throws ValueFormatException {
        SimpleTypeKind<E, ?> typeKind;
        if (type == null) {
            if (o instanceof String) {
                typeKind = BaseSimpleTypes.STRING;
            } else if (o instanceof Integer) {
                typeKind = BaseSimpleTypes.INT;
            } else if (o instanceof Long) {
                typeKind = BaseSimpleTypes.LONG;
            } else if (o instanceof Date) {
                typeKind = BaseSimpleTypes.DATE;
            } else if (o instanceof Double) {
                typeKind = BaseSimpleTypes.DOUBLE;
            } else if (o instanceof Float) {
                typeKind = BaseSimpleTypes.FLOAT;
            } else if (o instanceof InputStream) {
                typeKind = BaseSimpleTypes.STREAM;
            } else {
                if (!(o instanceof Boolean)) throw new UnsupportedOperationException("Type " + o.getClass().getName() + " is not accepted");
                typeKind = BaseSimpleTypes.BOOLEAN;
            }
        } else {
            typeKind = type.getKind();
        }
        if (typeKind instanceof SimpleTypeKind.STRING) {
            SimpleTypeKind.STRING stringKind = (SimpleTypeKind.STRING)typeKind;
            String s = (String)stringKind.toInternal(o);
            return valueFactory.createValue(s);
        }
        if (typeKind instanceof SimpleTypeKind.PATH) {
            SimpleTypeKind.PATH pathKind = (SimpleTypeKind.PATH)typeKind;
            String s = (String)pathKind.toInternal(o);
            return valueFactory.createValue(s, 8);
        }
        if (typeKind instanceof SimpleTypeKind.LONG) {
            SimpleTypeKind.LONG longKind = (SimpleTypeKind.LONG)typeKind;
            Long l = (Long)longKind.toInternal(o);
            return valueFactory.createValue(l.longValue());
        }
        if (typeKind instanceof SimpleTypeKind.DATE) {
            SimpleTypeKind.DATE dateKind = (SimpleTypeKind.DATE)typeKind;
            Date time = (Date)dateKind.toInternal(o);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            return valueFactory.createValue(calendar);
        }
        if (typeKind instanceof SimpleTypeKind.STREAM) {
            SimpleTypeKind.STREAM streamKind = (SimpleTypeKind.STREAM)typeKind;
            InputStream in = (InputStream)streamKind.toInternal(o);
            return valueFactory.createValue(in);
        }
        if (typeKind instanceof SimpleTypeKind.DOUBLE) {
            SimpleTypeKind.DOUBLE doubleKind = (SimpleTypeKind.DOUBLE)typeKind;
            Double d = (Double)doubleKind.toInternal(o);
            return valueFactory.createValue(d.doubleValue());
        }
        if (!(typeKind instanceof SimpleTypeKind.BOOLEAN)) throw new UnsupportedOperationException("Simple type " + type + " not accepted");
        SimpleTypeKind.BOOLEAN booleanKind = (SimpleTypeKind.BOOLEAN)typeKind;
        Boolean b = (Boolean)booleanKind.toInternal(o);
        return valueFactory.createValue(b.booleanValue());
    }
}

