/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapping;

import java.util.HashSet;
import java.util.List;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.Destroy;
import org.chromattic.api.annotations.FindById;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.Id;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.NamingPolicy;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Path;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Properties;
import org.chromattic.api.annotations.Property;
import org.chromattic.api.annotations.RelatedMappedBy;
import org.chromattic.api.annotations.WorkspaceName;
import org.chromattic.core.NodeAttributeType;
import org.chromattic.core.bean.BaseSimpleTypes;
import org.chromattic.core.bean.BeanInfo;
import org.chromattic.core.bean.BeanInfoFactory;
import org.chromattic.core.bean.BeanValueInfo;
import org.chromattic.core.bean.MapPropertyInfo;
import org.chromattic.core.bean.MultiValuedPropertyInfo;
import org.chromattic.core.bean.PropertyInfo;
import org.chromattic.core.bean.SimpleType;
import org.chromattic.core.bean.SimpleValueInfo;
import org.chromattic.core.bean.SingleValuedPropertyInfo;
import org.chromattic.core.mapping.CreateMapping;
import org.chromattic.core.mapping.DestroyMapping;
import org.chromattic.core.mapping.FindByIdMapping;
import org.chromattic.core.mapping.MethodMapping;
import org.chromattic.core.mapping.MixinTypeMapping;
import org.chromattic.core.mapping.NodeTypeMapping;
import org.chromattic.core.mapping.PrimaryTypeMapping;
import org.chromattic.core.mapping.PropertyMapping;
import org.chromattic.core.mapping.jcr.JCRNodeAttributeMapping;
import org.chromattic.core.mapping.jcr.JCRPropertyMapping;
import org.chromattic.core.mapping.value.ManyToOneMapping;
import org.chromattic.core.mapping.value.NamedManyToOneMapping;
import org.chromattic.core.mapping.value.NamedOneToManyMapping;
import org.chromattic.core.mapping.value.NamedOneToOneMapping;
import org.chromattic.core.mapping.value.OneToManyMapping;
import org.chromattic.core.mapping.value.OneToOneMapping;
import org.chromattic.core.mapping.value.PropertyMapMapping;
import org.chromattic.core.mapping.value.SimpleMapping;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.api.introspection.AnnotationIntrospector;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;

public class TypeMappingBuilder {
    private final BeanInfoFactory beanInfoBuilder;

    public TypeMappingBuilder(BeanInfoFactory beanInfoBuilder) {
        this.beanInfoBuilder = beanInfoBuilder;
    }

    public NodeTypeMapping build(ClassTypeInfo javaClass) {
        return this._build(javaClass);
    }

    private NodeTypeMapping _build(ClassTypeInfo javaClass) {
        PrimaryType primaryType;
        ClassTypeInfo argCTI;
        TypeInfo argTI;
        List parameterTypes;
        RelationshipType type;
        BeanValueInfo bvi;
        Object vi;
        SingleValuedPropertyInfo svpi;
        SimpleValueInfo svi;
        Property propertyAnnotation;
        HashSet<PropertyMapping> propertyMappings = new HashSet<PropertyMapping>();
        HashSet<MethodMapping> methodMappings = new HashSet<MethodMapping>();
        BeanInfo info = this.beanInfoBuilder.build(javaClass);
        for (PropertyInfo propertyInfo : info.getProperties(Property.class)) {
            Object value;
            propertyAnnotation = propertyInfo.getAnnotation(Property.class);
            if (propertyInfo instanceof SingleValuedPropertyInfo) {
                SingleValuedPropertyInfo svp = (SingleValuedPropertyInfo)propertyInfo;
                value = svp.getValue();
            } else if (propertyInfo instanceof MultiValuedPropertyInfo) {
                MultiValuedPropertyInfo mvp = (MultiValuedPropertyInfo)propertyInfo;
                value = mvp.getElementValue();
            } else {
                throw new IllegalStateException();
            }
            if (value instanceof SimpleValueInfo) {
                JCRPropertyMapping memberMapping = new JCRPropertyMapping(propertyAnnotation.name());
                SimpleMapping<JCRPropertyMapping> simpleMapping = new SimpleMapping<JCRPropertyMapping>(memberMapping);
                PropertyMapping<SimpleMapping<JCRPropertyMapping>> propertyMapping = new PropertyMapping<SimpleMapping<JCRPropertyMapping>>(propertyInfo, simpleMapping);
                propertyMappings.add(propertyMapping);
                continue;
            }
            throw new IllegalStateException("Cannot map property type " + value);
        }
        for (PropertyInfo propertyInfo : info.getProperties(Properties.class)) {
            propertyAnnotation = propertyInfo.getAnnotation(Properties.class);
            if (propertyInfo instanceof MapPropertyInfo) {
                MapPropertyInfo mapPropertyInfo = (MapPropertyInfo)propertyInfo;
                PropertyMapMapping simpleMapping = new PropertyMapMapping();
                PropertyMapping<PropertyMapMapping> propertyMapping = new PropertyMapping<PropertyMapMapping>(mapPropertyInfo, simpleMapping);
                propertyMappings.add(propertyMapping);
                continue;
            }
            throw new IllegalStateException();
        }
        for (PropertyInfo propertyInfo : info.getProperties()) {
            NodeAttributeType nat = null;
            if (propertyInfo.getAnnotation(Name.class) != null) {
                nat = NodeAttributeType.NAME;
            } else if (propertyInfo.getAnnotation(Id.class) != null) {
                nat = NodeAttributeType.ID;
            } else if (propertyInfo.getAnnotation(Path.class) != null) {
                if (propertyInfo.getAnnotation(Property.class) == null) {
                    nat = NodeAttributeType.PATH;
                }
            } else if (propertyInfo.getAnnotation(WorkspaceName.class) != null) {
                nat = NodeAttributeType.WORKSPACE_NAME;
            }
            if (nat == null) continue;
            if (propertyInfo instanceof SingleValuedPropertyInfo) {
                SingleValuedPropertyInfo svpi2 = (SingleValuedPropertyInfo)propertyInfo;
                Object vi2 = svpi2.getValue();
                if (vi2 instanceof SimpleValueInfo) {
                    svi = (SimpleValueInfo)vi2;
                    JCRNodeAttributeMapping memberMapping = new JCRNodeAttributeMapping(nat);
                    SimpleType simpleType = svi.getSimpleType();
                    if (nat == NodeAttributeType.PATH) {
                        if (simpleType.getKind() != BaseSimpleTypes.PATH) {
                            throw new IllegalStateException("Type " + simpleType + " is not accepted for path attribute mapping");
                        }
                    } else if (simpleType.getKind() != BaseSimpleTypes.STRING) {
                        throw new IllegalStateException("Type " + simpleType + " is not accepted for attribute mapping");
                    }
                    SimpleMapping<JCRNodeAttributeMapping> simpleMapping = new SimpleMapping<JCRNodeAttributeMapping>(memberMapping);
                    PropertyMapping<SimpleMapping<JCRNodeAttributeMapping>> propertyMapping = new PropertyMapping<SimpleMapping<JCRNodeAttributeMapping>>(propertyInfo, simpleMapping);
                    propertyMappings.add(propertyMapping);
                    continue;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        for (PropertyInfo propertyInfo : info.getProperties(OneToOne.class)) {
            if (propertyInfo instanceof SingleValuedPropertyInfo) {
                svpi = (SingleValuedPropertyInfo)propertyInfo;
                vi = svpi.getValue();
                if (vi instanceof BeanValueInfo) {
                    bvi = (BeanValueInfo)vi;
                    ClassTypeInfo typeInfo = bvi.getTypeInfo();
                    OneToOne oneToOneAnn = propertyInfo.getAnnotation(OneToOne.class);
                    type = oneToOneAnn.type();
                    if (type == RelationshipType.HIERARCHIC) {
                        NamedOneToOneMapping hierarchyMapping;
                        MappedBy mappedBy = propertyInfo.getAnnotation(MappedBy.class);
                        if (mappedBy != null) {
                            hierarchyMapping = new NamedOneToOneMapping(typeInfo, mappedBy.value(), RelationshipType.HIERARCHIC, true);
                        } else {
                            RelatedMappedBy relatedMappedBy = propertyInfo.getAnnotation(RelatedMappedBy.class);
                            if (relatedMappedBy != null) {
                                hierarchyMapping = new NamedOneToOneMapping(typeInfo, relatedMappedBy.value(), RelationshipType.HIERARCHIC, false);
                            } else {
                                throw new IllegalStateException("No related by mapping found for property " + propertyInfo + " when introspecting " + info);
                            }
                        }
                        PropertyMapping<NamedOneToOneMapping> oneToOneMapping = new PropertyMapping<NamedOneToOneMapping>(propertyInfo, hierarchyMapping);
                        propertyMappings.add(oneToOneMapping);
                        continue;
                    }
                    if (type == RelationshipType.EMBEDDED) {
                        OneToOneMapping embeddedMapping = new OneToOneMapping(typeInfo, RelationshipType.EMBEDDED);
                        PropertyMapping<OneToOneMapping> a = new PropertyMapping<OneToOneMapping>(propertyInfo, embeddedMapping);
                        propertyMappings.add(a);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        for (PropertyInfo propertyInfo : info.getProperties(OneToMany.class)) {
            OneToManyMapping mapping;
            MappedBy mappedBy;
            Object beanElementType;
            OneToMany oneToManyAnn = propertyInfo.getAnnotation(OneToMany.class);
            if (!(propertyInfo instanceof MultiValuedPropertyInfo)) continue;
            MultiValuedPropertyInfo multiValuedProperty = (MultiValuedPropertyInfo)propertyInfo;
            if (multiValuedProperty instanceof MapPropertyInfo) {
                MapPropertyInfo mapProperty = (MapPropertyInfo)multiValuedProperty;
                if (!(mapProperty.getKeyValue() instanceof SimpleValueInfo)) {
                    throw new IllegalStateException("Wrong key value type " + mapProperty.getKeyValue());
                }
                svi = (SimpleValueInfo)mapProperty.getKeyValue();
                if (svi.getSimpleType().getKind() != BaseSimpleTypes.STRING) {
                    throw new IllegalStateException();
                }
            }
            if (!((beanElementType = multiValuedProperty.getElementValue()) instanceof BeanValueInfo)) continue;
            BeanValueInfo bvi2 = (BeanValueInfo)beanElementType;
            type = oneToManyAnn.type();
            if (type == RelationshipType.HIERARCHIC) {
                mappedBy = propertyInfo.getAnnotation(MappedBy.class);
                if (mappedBy != null) {
                    throw new IllegalStateException();
                }
                mapping = new OneToManyMapping(bvi2.getTypeInfo(), RelationshipType.HIERARCHIC);
            } else {
                mappedBy = propertyInfo.getAnnotation(RelatedMappedBy.class);
                if (mappedBy == null) {
                    throw new IllegalStateException();
                }
                mapping = new NamedOneToManyMapping(bvi2.getTypeInfo(), mappedBy.value(), type);
            }
            PropertyMapping<OneToManyMapping> oneToManyMapping = new PropertyMapping<OneToManyMapping>(propertyInfo, mapping);
            propertyMappings.add(oneToManyMapping);
        }
        for (PropertyInfo propertyInfo : info.getProperties(ManyToOne.class)) {
            if (propertyInfo instanceof SingleValuedPropertyInfo) {
                svpi = (SingleValuedPropertyInfo)propertyInfo;
                vi = svpi.getValue();
                if (vi instanceof BeanValueInfo) {
                    bvi = (BeanValueInfo)vi;
                    ManyToOne manyToOneAnn = propertyInfo.getAnnotation(ManyToOne.class);
                    RelationshipType type2 = manyToOneAnn.type();
                    if (type2 == RelationshipType.HIERARCHIC) {
                        ManyToOneMapping hierarchyMapping = new ManyToOneMapping(bvi.getTypeInfo(), RelationshipType.HIERARCHIC);
                        PropertyMapping<ManyToOneMapping> manyToOneMapping = new PropertyMapping<ManyToOneMapping>(propertyInfo, hierarchyMapping);
                        propertyMappings.add(manyToOneMapping);
                        continue;
                    }
                    MappedBy mappedBy = propertyInfo.getAnnotation(MappedBy.class);
                    if (mappedBy == null) {
                        throw new IllegalStateException();
                    }
                    NamedManyToOneMapping referenceMapping = new NamedManyToOneMapping(bvi.getTypeInfo(), mappedBy.value(), type2);
                    PropertyMapping<NamedManyToOneMapping> manyToOneMapping = new PropertyMapping<NamedManyToOneMapping>(propertyInfo, referenceMapping);
                    propertyMappings.add(manyToOneMapping);
                    continue;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL);
        for (MethodInfo method : introspector.resolveMethods(javaClass, Create.class)) {
            if (method.isStatic()) continue;
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.size() < 2) {
                if (parameterTypes.size() == 1) {
                    argTI = (TypeInfo)parameterTypes.get(0);
                    if (argTI instanceof ClassTypeInfo) {
                        argCTI = (ClassTypeInfo)argTI;
                        if (!argCTI.getName().equals(String.class.getName())) {
                            throw new IllegalStateException();
                        }
                    } else {
                        throw new IllegalStateException();
                    }
                }
                ClassTypeInfo cti = (ClassTypeInfo)javaClass.resolve(method.getReturnType());
                methodMappings.add(new CreateMapping(method, cti));
                continue;
            }
            throw new IllegalStateException();
        }
        for (MethodInfo method : introspector.resolveMethods(javaClass, Destroy.class)) {
            if (method.isStatic()) continue;
            parameterTypes = method.getParameterTypes();
            if (parameterTypes.size() != 0) {
                throw new IllegalStateException();
            }
            if (!(method.getReturnType() instanceof VoidTypeInfo)) {
                throw new IllegalStateException();
            }
            methodMappings.add(new DestroyMapping(method));
        }
        for (MethodInfo method : introspector.resolveMethods(javaClass, FindById.class)) {
            if (method.isStatic() || (parameterTypes = method.getParameterTypes()).size() != 1) continue;
            argTI = (TypeInfo)parameterTypes.get(0);
            if (argTI instanceof ClassTypeInfo) {
                argCTI = (ClassTypeInfo)argTI;
                if (argCTI.getName().equals(String.class.getName())) {
                    ClassTypeInfo cti = (ClassTypeInfo)javaClass.resolve(method.getReturnType());
                    methodMappings.add(new FindByIdMapping(method, cti));
                    continue;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        NameConflictResolution onDuplicate = NameConflictResolution.FAIL;
        NamingPolicy namingPolicy = (NamingPolicy)new AnnotationIntrospector(NamingPolicy.class).resolve(javaClass);
        if (namingPolicy != null) {
            onDuplicate = namingPolicy.onDuplicate();
        }
        if ((primaryType = (PrimaryType)javaClass.getDeclaredAnnotation(PrimaryType.class)) == null) {
            MixinType mixinType = (MixinType)javaClass.getDeclaredAnnotation(MixinType.class);
            if (mixinType == null) {
                throw new IllegalStateException("Class " + javaClass + " is not annotated ");
            }
            String mixinName = mixinType != null ? mixinType.name() : null;
            return new MixinTypeMapping(javaClass, propertyMappings, methodMappings, onDuplicate, mixinName);
        }
        String nodeTypeName = primaryType.name();
        FormattedBy formattedBy = info.getAnnotation(FormattedBy.class);
        Class formatter = formattedBy != null ? formattedBy.value() : null;
        return new PrimaryTypeMapping(javaClass, propertyMappings, methodMappings, onDuplicate, nodeTypeName, formatter);
    }
}

