/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.core.DomainSession;
import org.chromattic.core.DomainSessionImpl;
import org.chromattic.core.jcr.SessionWrapper;
import org.chromattic.core.mapper.TypeMapper;
import org.chromattic.core.mapper.TypeMapperBuilder;
import org.chromattic.core.mapping.TypeMapping;
import org.chromattic.spi.instrument.Instrumentor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    private static final ConcurrentHashMap<SessionWrapper, DomainSessionImpl> sessionMapping = new ConcurrentHashMap();
    private final Map<String, TypeMapper> typeMapperByNodeType;
    private final Map<Class<?>, TypeMapper> typeMapperByClass;
    private final Instrumentor instrumentor;
    final ObjectFormatter objectFormatter;
    final boolean stateCacheEnabled;

    public Domain(Set<TypeMapping> typeMappings, Instrumentor instrumentor, ObjectFormatter objectFormatter, boolean stateCacheEnabled) {
        TypeMapperBuilder builder = new TypeMapperBuilder(typeMappings, instrumentor);
        HashMap<String, TypeMapper> typeMapperByNodeType = new HashMap<String, TypeMapper>();
        HashMap typeMapperByClass = new HashMap();
        for (TypeMapper typeMapper : builder.build()) {
            if (typeMapperByNodeType.containsKey(typeMapper.getNodeDef().getPrimaryNodeTypeName())) {
                throw new IllegalStateException("Duplicate node type name " + typeMapper.getNodeDef().getPrimaryNodeTypeName());
            }
            typeMapperByNodeType.put(typeMapper.getNodeDef().getPrimaryNodeTypeName(), typeMapper);
            typeMapperByClass.put(typeMapper.getObjectClass(), typeMapper);
        }
        this.typeMapperByClass = typeMapperByClass;
        this.typeMapperByNodeType = typeMapperByNodeType;
        this.instrumentor = instrumentor;
        this.objectFormatter = objectFormatter;
        this.stateCacheEnabled = stateCacheEnabled;
    }

    public DomainSession getSession(SessionWrapper jcrSession) {
        DomainSessionImpl phantomSession;
        if (jcrSession == null) {
            throw new NullPointerException();
        }
        DomainSessionImpl session = sessionMapping.get(jcrSession);
        if (session == null && (phantomSession = sessionMapping.put(jcrSession, session = new DomainSessionImpl(this, jcrSession))) != null) {
            session = phantomSession;
        }
        return session;
    }

    public Instrumentor getInstrumentor() {
        return this.instrumentor;
    }

    public TypeMapper getTypeMapper(String nodeTypeName) {
        return this.typeMapperByNodeType.get(nodeTypeName);
    }

    public TypeMapper getTypeMapper(Class<?> clazz) {
        return this.typeMapperByClass.get(clazz);
    }
}

