/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.bean;

import java.io.InputStream;
import java.util.Date;
import org.chromattic.core.bean.SimpleType;
import org.chromattic.core.bean.ValueInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.SimpleTypeInfo;

public class SimpleValueInfo
extends ValueInfo {
    private final SimpleType simpleType;
    private final boolean primitive;

    private SimpleValueInfo(ClassTypeInfo typeInfo, SimpleType simpleType, boolean primitive) {
        super(typeInfo);
        this.simpleType = simpleType;
        this.primitive = primitive;
    }

    public SimpleType getSimpleType() {
        return this.simpleType;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public String toString() {
        return "SimpleValueInfo[simpleType=" + (Object)((Object)this.simpleType) + ",primitive=" + this.primitive + "]";
    }

    public static SimpleValueInfo createPath(ClassTypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new NullPointerException();
        }
        if (typeInfo.getName().equals(String.class.getName())) {
            return new SimpleValueInfo(typeInfo, SimpleType.PATH, false);
        }
        throw new IllegalArgumentException("Simple value of type path must have a type of " + String.class.getName());
    }

    public static SimpleValueInfo create(ClassTypeInfo typeInfo) {
        boolean primitive;
        SimpleType simpleType;
        if (typeInfo == null) {
            throw new NullPointerException();
        }
        if (typeInfo instanceof SimpleTypeInfo) {
            switch (((SimpleTypeInfo)typeInfo).getLiteralType()) {
                case BOOLEAN: {
                    simpleType = SimpleType.BOOLEAN;
                    break;
                }
                case INT: {
                    simpleType = SimpleType.INT;
                    break;
                }
                case LONG: {
                    simpleType = SimpleType.LONG;
                    break;
                }
                case FLOAT: {
                    simpleType = SimpleType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    simpleType = SimpleType.DOUBLE;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            primitive = ((SimpleTypeInfo)typeInfo).isPrimitive();
        } else if (String.class.getName().equals(typeInfo.getName())) {
            simpleType = SimpleType.STRING;
            primitive = false;
        } else if (Date.class.getName().equals(typeInfo.getName())) {
            simpleType = SimpleType.DATE;
            primitive = false;
        } else if (InputStream.class.getName().equals(typeInfo.getName())) {
            simpleType = SimpleType.BINARY;
            primitive = false;
        } else {
            throw new AssertionError();
        }
        return new SimpleValueInfo(typeInfo, simpleType, primitive);
    }
}

