/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.query;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.query.ObjectQuery;
import org.chromattic.api.query.QueryLanguage;
import org.chromattic.core.DomainSession;
import org.chromattic.core.query.ObjectQueryImpl;
import org.chromattic.core.query.ObjectQueryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryManager {
    private static EnumMap<QueryLanguage, String> languages = new EnumMap(QueryLanguage.class);
    private EnumMap<QueryLanguage, Map<ObjectQueryKey, ObjectQuery<?>>> globalQueryCache;
    private final DomainSession domainSession;

    public QueryManager(DomainSession domainSession) {
        this.domainSession = domainSession;
    }

    public <O> ObjectQuery<O> getObjectQuery(Class<O> objectClass, String statement) {
        try {
            Map<ObjectQueryKey, ObjectQuery<?>> queryCache;
            QueryLanguage language = QueryLanguage.SQL;
            ObjectQueryKey key = new ObjectQueryKey(objectClass, statement);
            ObjectQuery<?> query = null;
            if (this.globalQueryCache != null && (queryCache = this.globalQueryCache.get(language)) != null) {
                query = queryCache.get(key);
            }
            if (query == null) {
                Map<ObjectQueryKey, ObjectQuery<?>> queryCache2;
                String jcrLanguage = languages.get(language);
                query = new ObjectQueryImpl(objectClass, this.domainSession, statement);
                if (this.globalQueryCache == null) {
                    this.globalQueryCache = new EnumMap(QueryLanguage.class);
                    queryCache2 = new HashMap();
                    this.globalQueryCache.put(language, queryCache2);
                } else {
                    queryCache2 = this.globalQueryCache.get(language);
                    if (queryCache2 == null) {
                        this.globalQueryCache.put(language, queryCache2);
                    }
                }
                queryCache2.put(key, query);
            }
            ObjectQuery<?> ret = query;
            return ret;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    static {
        languages.put(QueryLanguage.SQL, "sql");
        languages.put(QueryLanguage.XPATH, "xpath");
    }
}

